/*
 * Copyright 2011 Tilera Corporation. All Rights Reserved.
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation, version 2.
 *
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 *   NON INFRINGEMENT.  See the GNU General Public License for
 *   more details.
 *
 * Declares state used by the target-side PCIE driver.  This driver
 * takes incoming packets from the PCIE link and adapts them to the
 * bidirectional character-device model.
 */
#ifndef __TLR_HV_PCIE_H__
#define __TLR_HV_PCIE_H__

#include <hv/drv_pcie_channel_intf.h>

#include "tilepci_shared_code.h"

/* Declarations from tilepci_direct_hv.c */
int tlr_hv_direct_zc_open(struct inode *inode, struct file *filp, int cpu,
			  struct pcie_tile_local_init_read *init_read);

/* Declarations from tilepci_barmem.c */
int tlr_barmem_open(struct tlr_pcie_dev *tlr, struct file *filp);

#endif	/* !defined(__TLR_HV_PCIE_H__) */
