/*
 * Copyright 2011 Tilera Corporation. All Rights Reserved.
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation, version 2.
 *
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 *   NON INFRINGEMENT.  See the GNU General Public License for
 *   more details.
 */

#ifndef _ASM_TILE_HUGEVMAP_H
#define _ASM_TILE_HUGEVMAP_H

#include <linux/mm.h>
#include <asm/page.h>

/*
 * Map a single huge page into kernel-addressible memory with the
 * given protection (e.g. PAGE_KERNEL).  A return of NULL indicates
 * that no more huge page vmap slots are available (perhaps the
 * NR_HUGE_VMAPS configuration needs to be increased).
 */
extern void *huge_vmap(struct page *page, pgprot_t prot);

/* Unmap the huge page at the given address. */
extern void huge_vunmap(void *addr);

#endif /* _ASM_TILE_HUGEVMAP_H */
