/*
 * Copyright 2011 Tilera Corporation. All Rights Reserved.
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation, version 2.
 *
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 *   NON INFRINGEMENT.  See the GNU General Public License for
 *   more details.
 */

#ifndef _ASM_TILE_KVM_H
#define _ASM_TILE_KVM_H

struct kvm_regs {
	/* Saved main processor registers; 56..63 are special. */
	/* tp, sp, and lr must immediately follow regs[] for aliasing. */
	__u32 regs[53];
	__u32 tp;		/* aliases regs[TREG_TP] */
	__u32 sp;		/* aliases regs[TREG_SP] */
	__u32 lr;		/* aliases regs[TREG_LR] */

	/* Saved special registers. */
	__u32 pc;		/* stored in EX_CONTEXT_K_0 */
	__u32 ex1;		/* stored in EX_CONTEXT_K_1 (PL and ICS bit) */
};

struct kvm_sregs {
};

struct kvm_fpu {
};

struct kvm_debug_exit_arch {
};

struct kvm_guest_debug_arch {
};

#endif /* _ASM_TILE_KVM_H */
