/*
 * tilepci_host_subset.h
 *
 * Copyright 2011 Tilera Corporation. All Rights Reserved.
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation, version 2.
 *
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 *   NON INFRINGEMENT.  See the GNU General Public License for
 *   more details.
 */
#ifndef __TLR_PCI_H__
#define __TLR_PCI_H__

#include "linux/ioctl.h"
#include "linux/list.h"
#include "hv/drv_pcie_channel_intf.h"

#if !defined(FALSE)
#define FALSE	(0)
#endif /* !defined(FALSE) */

#if !defined(TRUE)
#define TRUE	(1)
#endif /* !defined(TRUE) */


#define DRIVER_NAME_STRING "tilepci_host_subset"

#define STRINGIFY(x) #x
#define TOSTRING(x)	 STRINGIFY(x)
#define MSG_LINE     "%s(%s:" TOSTRING(__LINE__) "-%d):"
#define SIMPLE_MSG_LINE    DRIVER_NAME_STRING "(" TOSTRING(__LINE__) "): "

#define INFO(FMT, ...)	pr_info(SIMPLE_MSG_LINE FMT, ## __VA_ARGS__)
#define WARNING(FMT, ...) \
	pr_warning(SIMPLE_MSG_LINE FMT, ## __VA_ARGS__)
#define ERR(FMT, ...)	pr_err(SIMPLE_MSG_LINE FMT, ## __VA_ARGS__)

#ifdef TRACE_TILEPCI_HOST_SUBSET
#define TRACE(FMT, ...) pr_info(SIMPLE_MSG_LINE FMT, ## __VA_ARGS__)
#else
#define TRACE(...)
#endif

#define NUM_MINOR_DEVICES    256

/* State object for each Tile endpoint PCIe port. */
struct tlr_pcie_dev {
	struct pci_dev *pci_dev;
	struct cdev cdev;
	dev_t first_dev;
	int link_index;
	int global_port_index;           /* Index of this port as probed. */

	/* Address of the card's MMIO region. */
	struct pcie_host_mmio_regs __iomem *regs;

	/* Address of the card's BAR memory. */
	spinlock_t barmem_lock;
	void __iomem *barmem;
	int barmem_count;

	/* A list of pages currently registered with the barmem file. */
	struct list_head barmem_page_list;

	/* Address of the rshim registers. */
	u8 __iomem *rshim_regs;

	/* Lock used to make sure endpoint is only initialized once. */
	spinlock_t is_ready_lock;
	int is_ready;

	/* Serialize access to the 'boot' device file. */
	struct mutex boot_mutex;
	int is_booting;
	int booted;

	int chip_version;           /**< TILE vs. TILEPro. */
	int chip_width;
	int chip_height;
};

/* Keeps track of pages that have been mapped to the bus. */
struct tlr_page_list_entry {
	struct list_head list;
	struct page *page;
	unsigned long size;
	dma_addr_t bus_addr;
};

#endif
