/*
 * Copyright 2011 Tilera Corporation. All Rights Reserved.
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation, version 2.
 *
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 *   NON INFRINGEMENT.  See the GNU General Public License for
 *   more details.
 */

#ifndef _ASM_TILE_KVM_HOST_H
#define _ASM_TILE_KVM_HOST_H

#include <linux/types.h>

#define KVM_MAX_VCPUS 64
/* FIXME - have no idea what these do yet */
#define KVM_MEMORY_SLOTS 32
#define KVM_PRIVATE_MEM_SLOTS 4

#define KVM_NR_PAGE_SIZES 2
/* FIXME - not sure what the * 8 does here, or if it's correct. */
#define KVM_HPAGE_SHIFT(x)      (PAGE_SHIFT + ((x) - 1) * 8)
#define KVM_HPAGE_SIZE(x)       (1UL << KVM_HPAGE_SHIFT(x))
#define KVM_HPAGE_MASK(x)       (~(KVM_HPAGE_SIZE(x) - 1))
#define KVM_PAGES_PER_HPAGE(x)  (KVM_HPAGE_SIZE(x) / PAGE_SIZE)


struct kvm_vcpu_stat {
	/* FIXME - Counters for various events? */
};

struct kvm_vcpu_arch {
	/* FIXME - All CPU state? */

	/* Saved main processor registers; 56..63 are special. */
	/* tp, sp, and lr must immediately follow regs[] for aliasing. */
	__u32 regs[53];
	__u32 tp;		/* aliases regs[TREG_TP] */
	__u32 sp;		/* aliases regs[TREG_SP] */
	__u32 lr;		/* aliases regs[TREG_LR] */

	/* Saved special registers. */
	__u32 pc;		/* stored in EX_CONTEXT_K_0 */
	__u32 ex1;		/* stored in EX_CONTEXT_K_1 (PL and ICS bit) */
};

struct kvm_vm_stat {
	/*
	 * FIXME - does this make sense for us?  It's used in common KVM
	 * code.
	 */
        u32 remote_tlb_flush;
};

struct kvm_arch {
};


#endif /* _ASM_TILE_KVM_HOST_H */
