/*
 * Copyright 2011 Tilera Corporation. All Rights Reserved.
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation, version 2.
 *
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 *   NON INFRINGEMENT.  See the GNU General Public License for
 *   more details.
 */

/**
 * @file drv_hpi_intf.h
 * Interface definitions for the HPI driver.
 */

#ifndef _SYS_HV_INCLUDE_DRV_HPI_INTF_H
#define _SYS_HV_INCLUDE_DRV_HPI_INTF_H

/** Number of bytes of memory for buffering HPI data.  This is
 * used with /dev/hpi/mem.
 */
#define HPI_DATA_BUFFER_SIZE 4096

/** Number of bytes of memory for buffering interrupt acceses.
 * This is used with /dev/hpi/int.
 */
#define HPI_INT_BUFFER_SIZE 4

#endif /* _SYS_HV_INCLUDE_DRV_HPI_INTF_H */
