/*
 * Copyright 2011 Tilera Corporation. All Rights Reserved.
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation, version 2.
 *
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 *   NON INFRINGEMENT.  See the GNU General Public License for
 *   more details.
 */

/**
 * @file
 *
 * MMIO regs for an endpoint that root complex unit tests can
 * communicate with.
 */
#ifndef _SYS_HV_DRV_PCIE_RCTEST_INTF_H
#define _SYS_HV_DRV_PCIE_RCTEST_INTF_H


/** The MMIO registers mapped at the start of BAR0. */
struct testep_mmio_regs
{
  uint32_t status;            /**< Device state value (TLR_xxx) */
  uint32_t trans_in_progress; /**< transaction in progress */
  uint32_t scratch;           /**< Scratch register */
  uint32_t addr_low;          /**< low-order 32 bits of addr for DMA request */
  uint32_t addr_hi;           /**< high-order 32 bits of addr for DMA request*/
  uint32_t length;            /**< length of DMA request */
  uint32_t write_trigger;     /**< starts a DMA write to host when written */
  uint32_t read_trigger;      /**< starts a DMA read from host when written */
  uint32_t interrupt_trigger; /**< triggers an intA interrupt from ep */
};

#endif /* _SYS_HV_DRV_PCIE_RCTEST_INTF_H */
