/*
 * Copyright 2011 Tilera Corporation. All Rights Reserved.
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation, version 2.
 *
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 *   NON INFRINGEMENT.  See the GNU General Public License for
 *   more details.
 */

/**
 * @file drv_softuart_intf.h
 * Interface definitions for the SOFTUART driver.
 */

#ifndef _SYS_HV_INCLUDE_DRV_SOFTUART_INTF_H
#define _SYS_HV_INCLUDE_DRV_SOFTUART_INTF_H

/** pread offset to read data from the UART. */
#define SOFTUART_DATA_READ     0
/** pread offset to find out how much tx buffer space is available. */
#define SOFTUART_WRITEROOM     1000
/** pwrite offset to pass client downcall handler to HV. */
#define SOFTUART_INTARG        1001

/*
 * These are the reasons the hv can do a client downcall to interrupt
 * the client (linux) driver.
 */
#define SOFTUART_CLIENTINT_WRITEROOM 1  ///< tx buffer space has freed up.
#define SOFTUART_CLIENTINT_RX        2  ///< Some data is ready to read.

#endif /* _SYS_HV_INCLUDE_DRV_SOFTUART_INTF_H */
