                       Manuel de l'utilisateur d'aptitude

Version 0.6.3

  Daniel Burrows

   <dburrows@debian.org>

   Copyright (c) 2004-2008 Daniel Burrows

   This manual is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This manual is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along
   with this manual; if not, write to the Free Software Foundation, Inc., 59
   Temple Place, Suite 330, Boston, MA 02111-1307 USA

   --------------------------------------------------------------------------

   Table des matieres

   Introduction

                Qu'est-ce qu'aptitude, au fait ?

                Qu'est-ce qu'un gestionnaire de paquets ?

                Qu'est-ce que le systeme apt ?

                Comment se procure-t-on aptitude ?

                             Pre-built aptitude packages, or, << what 99% of
                             users should do >>

                             Construire aptitude depuis les sources

                             Assurer le suivi, et participer au developpement
                             d'aptitude

   1. Getting started

                Utiliser aptitude

                             aptitude basics

                             Naviguer dans la liste des paquets d'aptitude

                             Rechercher des paquets par leur nom

                             Gerer les paquets

                             Mettre `a jour la liste des paquets et installer
                             des paquets

                Utiliser aptitude depuis la ligne de commande

   2. aptitude reference guide

                The aptitude terminal user interface

                             Utiliser les menus

                             Commandes du menu

                             Travailler avec plusieurs vues

                             Devenir administrateur (<< root >>)

                Gerer les paquets

                             Gerer la liste des paquets

                             Acceder aux informations des paquets

                             Modifier l'etat d'un paquet

                             Telecharger, installer et supprimer des paquets

                             Qu'est-ce que la confiance en matiere de gestion
                             des paquets ?

                             Gerer les paquets automatiquement installes

                Resolving package dependencies

                             Dependency resolution in aptitude

                             Immediate dependency resolution

                             Resolving Dependencies Interactively

                             Costs in the interactive dependency resolver

                             Configuring the interactive dependency resolver

                Search patterns

                             Searching for strings

                             Shorthand for search terms

                             Searches and versions

                             Explicit search targets

                             Search term reference

                Personnalisation d'aptitude

                             Customizing the package list

                             Personnaliser les raccourcis clavier

                             Personnaliser la couleur du texte et les styles

                             Personnaliser la disposition de l'affichage

                             Reference du fichier de configuration

                             Themes

                Jouer au demineur

   3. aptitude frequently asked questions

   4. Credits

   I. Command-line reference

                aptitude -- interface evoluee pour le gestionnaire de paquets

                aptitude-create-state-bundle -- bundle the current aptitude
                state

                aptitude-run-state-bundle -- unpack an aptitude state bundle
                and invoke aptitude on it

   Liste des illustrations

   2.1. Commandes disponibles dans le menu Actions

   2.2. Commandes disponibles dans le menu Annuler

   2.3. Commandes disponibles dans le menu Paquet

   2.4. Commandes disponibles dans le menu Solveur

   2.5. Commandes disponibles dans le menu Rechercher

   2.6. Commandes disponibles dans le menu Options

   2.7. Commandes disponibles dans le menu Vues

   2.8. Commandes disponibles dans le menu Aide

   2.9. Valeurs de l'indicateur de << l'etat courant >>

   2.10. Valeurs de l'indicateur << d'action >>

   2.11. Syntax of compound cost components

   2.12. Safety cost levels

   2.13. Syntax of the ?for term

   2.14. Styles personnalisables dans aptitude

   Liste des tableaux

   2.1. Basic cost components

   2.2. Default safety cost levels

   2.3. Quick guide to search terms

   Liste des exemples

   2.1. Sample resolver costs

   2.2. Use of the ?= term.

   2.3. Use of the ?bind term

   2.4. Use of the ?exact-name term

   2.5. Use of the ?for term

   2.6. Use of the ?term-prefix term

   2.7. Use of pattern to group packages by their maintainer

   2.8. Use of pattern with some packages placed at the top level

   2.9. Use of the pattern grouping policy with sub-policies

   10. Usage of --show-summary

Introduction

   Table des matieres

   Qu'est-ce qu'aptitude, au fait ?

   Qu'est-ce qu'un gestionnaire de paquets ?

   Qu'est-ce que le systeme apt ?

   Comment se procure-t-on aptitude ?

                Pre-built aptitude packages, or, << what 99% of users should
                do >>

                Construire aptitude depuis les sources

                Assurer le suivi, et participer au developpement d'aptitude

     << Maitre, Emacs connait-il la nature du Bouddha ? >> demanda le
     novice.

     << Pourquoi en serait-il autrement ? >>, repondit le maitre. << Il
     fait sacrement bien tout le reste >>. Quelques annees plus tard, le
     novice rec,ut l'illumination.
                                                                -- John Fouhy

   Voici le manuel de l'utilisateur d'aptitude ! Cette introduction explique
   ce qu'est aptitude et `a quoi il sert. Pour acceder aux informations sur
   la maniere de l'utiliser, allez directement au Chapitre 1, Getting
   started.

Qu'est-ce qu'aptitude, au fait ?

   aptitude est un gestionnaire de paquets tres complet pour les systemes
   Debian GNU/Linux ; il est base sur la fameuse infrastructure de gestion de
   paquets apt. aptitude fournit les fonctionnalites de dselect et d'apt-get,
   ainsi que beaucoup d'autres, introuvables dans ces programmes.

Qu'est-ce qu'un gestionnaire de paquets ?

   Un gestionnaire de paquets garde la trace des programmes installes sur
   votre ordinateur. Il facilite l'installation de nouveaux programmes, la
   mise `a jour ou la suppression de ceux que vous aviez precedemment
   installes. Comme le nom le suggere, un gestionnaire de paquets traite des
   paquets : un paquet est un ensemble de fichiers lies et qui peuvent etre
   installes ou supprimes en bloc.

   Generalement, un paquet fournit un programme particulier. Par exemple, le
   client de messagerie instantanee gaim est contenu dans le paquet Debian du
   meme nom. D'un autre cote, il est frequent qu'un programme se compose de
   plusieurs paquets apparentes. Par exemple, l'editeur d'image gimp n'est
   pas constitue que du paquet gimp, mais aussi du paquet gimp-data ; de plus
   plusieurs paquets optionnels supplementaires (contenant des donnees
   diverses, de la documentation, etc.) sont aussi disponibles. Il arrive
   aussi que plusieurs petits programmes apparentes soient fournis dans un
   unique paquet. Par exemple, le paquet fileutils contient plusieurs
   commandes Unix usuelles telles que ls, cp, etc.

   Certains paquets requierent d'autres paquets pour fonctionner. A
   l'interieur de Debian, les paquets peuvent dependre, recommander,
   suggerer, casser,ou etre en conflit (<< conflict >>) avec d'autres
   paquets.

     o Si un paquet A depend d'un paquet B, alors B est necessaire au bon
       fonctionnement de A. Par exemple, le paquet gimp depend du paquet
       gimp-data pour s'assurer que l'editeur de graphismes GIMP aura acces
       `a ses fichiers de donnees.

     o Si un paquet A recommande un autre paquet B, alors B ajoute au paquet
       A une fonctionnalite importante qui sera appreciee dans la plupart des
       cas. Par exemple, le paquet mozilla-browser recommande le paquet
       mozilla-psm qui ajoute la gestion des transferts de donnees securises
       au navigateur web Mozilla. Bien que mozilla-psm ne soit pas absolument
       necessaire pour que Mozilla fonctionne, la plupart des utilisateurs
       veulent que Mozilla gere la transmission securisee de donnees
       confidentielles (tel que leur numero de carte bancaire).

     o Si un paquet A suggere un autre paquet B, alors le paquet B fournit
       une fonctionnalite qui peut ameliorer A sans qu'elle ne soit
       generalement necessaire. Par exemple, le paquet kmail suggere le
       paquet gnupg qui contient un logiciel de chiffrement que KMail peut
       utiliser.

     o Si un paquet A est en conflit avec un autre paquet B, alors les deux
       paquets ne peuvent pas etre installes au meme moment. Par exemple,
       fb-music-hi est en conflit avec fb-music-low car ils fournissent tous
       deux des jeux de musiques de remplacement pour le jeu Frozen Bubble.

   Le travail du gestionnaire de paquets est de presenter une interface qui
   aide l'utilisateur `a gerer l'ensemble des paquets installes sur son
   systeme. aptitude fournit une telle interface en tirant parti du systeme
   de gestion de paquets apt.

Qu'est-ce que le systeme apt ?

   Pouvoir capable d'installer et de supprimer des paquets, c'est formidable,
   mais le programme basique charge de faire cela (connu sous le nom de dpkg)
   ne fait que cela et rien de plus. C'est tres bien si vous telechargez un
   ou deux paquets << `a la main >>, mais cela devient vite fatiguant quand
   vous essayez de gerer un grand nombre de paquets. De plus, si un nouveau
   paquet interessant necessite des programmes que vous n'avez pas encore
   installes, vous devez telecharger vous-memes les nouveaux paquets requis.
   Enfin, si vous decidez par la suite de supprimer ce paquet, les paquets
   additionnels vont rester sur votre systeme et occuper de la place sur vos
   disques `a moins que vous ne les supprimiez vous-meme.

   Toutes ces operations sont fastidieuses et la plupart des systemes de
   gestion de paquets sont accompagnes de programmes qui se chargent de tout
   cela `a votre place. apt est la base commune sur laquelle sont construits
   ces programmes : en plus d'aptitude, des programmes comme synaptic et
   apt-watch utilisent apt.

   apt fonctionne grace `a une liste des paquets qui peuvent etre telecharges
   depuis Debian sur votre ordinateur. Cette liste est utilisee pour trouver
   les paquets qui ont besoin d'etre mis `a jour et pour installer de
   nouveaux paquets. apt peut aussi resoudre automatiquement de nombreux
   problemes de dependances : par exemple, quand vous choisissez d'installer
   un paquet, il recherche tous les paquets supplementaires requis et les
   installe en meme temps.

   Avec un gestionnaire de paquet base sur apt, tel qu'aptitude, vous avez
   trois operations fondamentales : mettre `a jour la liste des paquets
   disponibles en telechargeant de nouvelles listes depuis les serveurs
   Debian, selectionner quels paquets doivent etre installes, mis `a jour ou
   supprimes, et enfin mettre `a execution votre selection en procedant
   reellement aux installations, suppressions, etc.

   Les gestionnaires de paquets bases sur apt lisent la liste des
   << sources >> (depot de paquets Debian) dans le fichier
   /etc/apt/sources.list. La presentation du format et du contenu de ce
   fichier n'entre pas dans le cadre de ce document, mais ils sont decrits
   dans la page de manuel sources.list(5).

Comment se procure-t-on aptitude ?

   Si vous lisez ce document sans avoir installe aptitude sur votre systeme,
   cette section explique comment vous sortir de cette mauvaise passe. Vous
   devriez aller directement `a la partie sur les paquets binaires.

  Pre-built aptitude packages, or, << what 99% of users should do >>

   Un paquet precompile, ou << binaire >>, est le moyen le plus courant et le
   plus facile d'installer aptitude. Vous devriez uniquement tenter
   d'installer depuis les sources si aucun paquet binaire n'est disponible
   pour une raison ou une autre, ou si vous avez des besoins particuliers qui
   ne sont pas satisfaits par les paquets binaires.

   Si vous etes en train d'utiliser un systeme Debian, executez la commande
   suivante en tant que root : apt-get install aptitude. Sinon, le
   fournisseur de votre systeme a du creer un paquet pour aptitude. Dans le
   doute, vous pouvez le contacter pour d'avantage de conseils.

  Construire aptitude depuis les sources

   Vous pouvez aussi construire aptitude depuis les sources. Neanmoins, il
   est probable que ce ne soit pas utile si apt est dej`a installe sur votre
   systeme. Si ce n'est pas le cas vous pouvez installer aptitude depuis les
   sources en suivant les etapes :

    1. Installer les programmes suivants :

          o Un compilateur C++, comme g++.

          o Les fichiers de developpement d'apt, habituellement disponibles
            dans le paquet nomme libapt-pkg-dev.

          o The libsigc++-2.0 library, available in the package
            libsigc++-2.0-dev or from http://libsigc.sourceforge.net.

          o The cwidget library, available in the package libcwidget-dev or
            from http://cwidget.alioth.debian.org.

          o The gettext program, which should be included with your Linux
            distribution.

          o A make tool, such as GNU make.

          o Enfin, telecharger le code source le plus recent d'aptitude,
            disponible sur http://packages.debian.org/unstable/admin/aptitude
            (faites defiler l'ecran jusqu'en bas et telecharger le fichier
            << .orig.tar.gz >>).

   Une fois tous ces composants reunis, ouvrez un terminal et executez la
   commande : tar zxf aptitude-0.6.3.tar.gz pour desarchiver le code source.
   Une fois les sources desarchivees, tapez cd aptitude-0.6.3 && ./configure
   && make pour compiler aptitude. Si cela reussit, assurez-vous que vous
   etes sous l'utilisateur root (en utilisant, par exemple, su), tapez alors
   make install pour installer aptitude sur votre ordinateur. Une fois
   aptitude correctement installe, taper aptitude `a l'invite de la ligne de
   commande devrait lancer le programme.

  Assurer le suivi, et participer au developpement d'aptitude

    Recuperer l'arborescence des sources d'aptitude

   Si vous souhaitez tester le tout dernier code source en date d'aptitude,
   vous pouvez telecharger le code source non encore publie d'aptitude en
   utilisant Mercurial. Installez Mercurial (disponible `a
   http://www.selenic.com/mercurial/) et executez la commande hg clone
   http://hg.debian.org/hg/aptitude/head aptitude afin de recuperer le code
   source le plus recent.

   [Avertissement] Avertissement
                   The aptitude Mercurial repository is an active development
                   tree; it will change as bugs are fixed and features are
                   added, and there is absolutely no guarantee that it will
                   even compile, let alone run properly! Bug reports are
                   welcome, but be aware that you use development code
                   entirely at your own risk!^[1]

    Liste de diffusion

   <aptitude-devel@lists.alioth.debian.org> est la principale liste de
   diffusion concernant le developpement d'aptitude. Les archives de cette
   liste sont accessibles ici
   http://lists.alioth.debian.org/pipermail/aptitude-devel/. Pour s'y
   abonner, consultez la page Web
   http://lists.alioth.debian.org/mailman/listinfo/aptitude-devel.

    Proposer des correctifs (patches).

   Dans l'absolu, les correctifs devraient etre soumis `a la liste de
   diffusion d'aptitude <aptitude-devel@lists.alioth.debian.org>. Mais si
   vous preferez les envoyer en prive, vous pouvez utiliser l'adresse de
   courriel <aptitude@packages.debian.org> ou <dburrows@debian.org>. Une
   rapide description des raisons qui ont motivees ce correctif ainsi qu'une
   explication de son mode de fonctionnement sont grandement apprecies.

    Suivre les modifications dans l'arborescence de sources d'aptitude

   L'arborescence des sources d'aptitude est regulierement mis `a jour avec
   de nouvelles fonctionnalites, des corrections de bogues, et de nouveaux
   bogues. Des qu'un code source est disponible sur votre machine (voir la
   section precedente), vous pouvez vous deplacer dans le repertoire (cd) et
   taper hg pull && hg update afin de le mettre `a jour avec les changements
   apparus sur le depot principal.

   Pour etre averti automatiquement lorsque des modifications ont ete faites
   sur le code de base d'aptitude inscrivez-vous au fil RSS disponible `a
   http://hg.debian.org/hg/aptitude/head?cl=tip;style=rss.

    Construire aptitude `a partir de l'arborescence de developpement.

   To build aptitude from the Mercurial repository, you must have the
   programs autoconf and automake installed. Type sh ./autogen.sh &&
   ./configure to generate the files needed to compile aptitude, then execute
   make and make install.

   --------------

   ^[1] Bien sur, vous utilisez tous les logiciels libres `a vos propres
   risques, mais le risque induit par l'utilisation d'un arbre de
   developpement actif est encore plus grand.

Chapitre 1. Getting started

   Table des matieres

   Utiliser aptitude

                aptitude basics

                Naviguer dans la liste des paquets d'aptitude

                Rechercher des paquets par leur nom

                Gerer les paquets

                Mettre `a jour la liste des paquets et installer des paquets

   Utiliser aptitude depuis la ligne de commande

         Un voyage de mille lieues commence toujours par un premier pas.
                                                                   -- Lao Tsu

   aptitude est un programme assez gros avec de nombreuses fonctionnalites et
   il peut etre un peu lourd pour les nouveaux utilisateurs qui veulent
   l'aborder. Ce chapitre ne decrit pas de fac,on exhaustive les
   fonctionnalites d'aptitude (consultez Chapitre 2, aptitude reference guide
   pour cela), mais il fournit un aperc,u des fonctionnalites de base les
   plus utilisees de ce programme.

Utiliser aptitude

   Cette section decrit comment utiliser l'interface graphique d'aptitude.
   Pour des informations sur l'utilisation de l'interface d'aptitude en ligne
   de commande, consultez la section intitulee << Utiliser aptitude depuis la
   ligne de commande >>.

  aptitude basics

   Pour lancer aptitude, ouvrez votre terminal prefere et tapez sur la ligne
   de commande :

 toto$ aptitude

   Une fois que le cache est charge (ce qui peut prendre un peu de temps sur
   les machines les plus lentes), l'ecran principal d'aptitude apparait :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 --- Installed Packages
 --- Not Installed Packages
 --- Obsolete and Locally Created Packages
 --- Virtual Packages
 --- Tasks






 These packages are currently installed on your computer.









   Comme vous pouvez le voir, l'ecran principal d'aptitude est divise en
   plusieurs parties. La ligne bleue en haut du terminal est la barre de
   menu, et les lignes bleues juste au dessous contient des informations sur
   quelques commandes importantes. La zone noire qui les suit contient la
   liste de tous les paquets disponibles, classes par groupes de paquets. Le
   groupe actuellement selectionne (<< Paquets installes >>) est mis en
   evidence et sa description est indiquee dans l'espace noir du bas.

   Comme le suggerent les lignes en haut de l'ecran, vous pouvez acceder au
   menu d'aptitude avec le raccourci clavier Controle+t ; vous pouvez aussi
   cliquer avec la souris sur un onglet du menu si votre systeme gere ce
   mecanisme. Utilisez le raccourci Controle+t va ouvrir le menu Actions :

  Actions  Undo  Package  Search  Options  Views  Help
 +-------------------------+  u: Update  g: Download/Install/Remove Pkgs
 |Install/remove packages g|
 |Update package list     u|
 |Forget new packages     f|
 |Clean package cache      |eated Packages
 |Clean obsolete files     |
 |Mark Upgradable         U|
 |Play Minesweeper         |
 |Become root              |
 +-------------------------+
 |Quit                    Q|
 +-------------------------+
 These packages are currently installed on your computer.









 Perform all pending installs and removals

   Utilisez les fleches et Entree pour selectionner un onglet du menu (ou, si
   votre systeme le permet, cliquez sur celui-ci avec la souris) ; pour
   fermer le menu sans rien selectionner, utilisez `a nouveau le raccourci
   clavier Controle+t. Le menu actuellement surligne est explique en bas de
   l'ecran. Si une option du menu peut etre utilisee via un raccourci
   clavier, celui-ci est affiche dans le menu : par exemple, la commande
   << Mettre `a jour les listes de paquets >> peut etre lancee en appuyant
   sur u.

   A tout moment, appuyer sur ? vous permet d'afficher une liste des
   principaux raccourcis clavier disponibles.

  Naviguer dans la liste des paquets d'aptitude

   La liste des paquets est l'interface principale d'aptitude. Quand aptitude
   demarre, la liste est organisee suivant un certain nombre de groupes comme
   on peut le voir sur la capture suivante :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 --- Installed Packages
 --- Not Installed Packages
 --- Obsolete and Locally Created Packages
 --- Virtual Packages
 --- Tasks






 These packages are currently installed on your computer.









   [Note] Note
          Les groupes de paquets vides sont automatiquement caches par
          aptitude, donc vous pourriez voir plus ou moins de groupes que ceux
          presents sur cette capture.

   Sur la capture precedente, le premier groupe (<< Paquets installes >>) est
   surligne pour indiquer qu'il est actuellement selectionne. Vous pouvez
   modifier la selection avec les fleches haut et bas. Notez que la
   description affichee en bas change en consequence. Pour << deployer >> un
   groupe, appuyez sur Entree quand le groupe est selectionne :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 --\ Installed Packages
   --- admin - Administrative utilities (install software, manage users, etc)
   --- base - The Debian base system
   --- devel - Utilities and programs for software development
   --- doc - Documentation and specialized programs for viewing documentation
   --- editors - Text editors and word processors
   --- electronics - Programs for working with circuits and electronics
   --- games - Games, toys, and fun programs
   --- gnome - The GNOME Desktop System
   --- graphics - Utilities to create, view, and edit graphics files

 These packages are currently installed on your computer.









   Comme vous pouvez le voir, le groupe << Paquets installes >> a ete deploye
   pour faire apparaitre son contenu : il contient un certain nombre de
   sous-groupes sommairement definis par le type de programmes qu'ils
   contiennent. Deployer la section << admin >> en la selectionnant et en
   appuyant sur Entree affiche :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 --\ Installed Packages
   --\ admin - Administrative utilities (install software, manage users, etc)
     --- main - The main Debian archive
   --- base - The Debian base system
   --- devel - Utilities and programs for software development
   --- doc - Documentation and specialized programs for viewing documentation
   --- editors - Text editors and word processors
   --- electronics - Programs for working with circuits and electronics
   --- games - Games, toys, and fun programs
   --- gnome - The GNOME Desktop System

 Packages in the 'admin' section allow you to perform administrative tasks such
 as installing software, managing users, configuring and monitoring your system,
 examining network traffic, and so on.







   Le groupe << admin >> contient un unique sous-groupe, l'archive Debian
   << main >>. Deployer ce groupe revele quelques paquets !

   [Astuce] Astuce
            Pour aller plus vite, vous pouvez utiliser la touche [ pour
            deployer d'un seul coup tous les sous-groupes d'un groupe donne.
            Selectionner << Paquets installes >> et appuyer sur [ fait
            immediatement apparaitre les paquets sur la capture suivante.

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 --\ Installed Packages
   --\ admin - Administrative utilities (install software, manage users, etc)
     --\ main - The main Debian archive
 i     acpid                                                1.0.3-19   1.0.3-19
 i     alien                                                8.44       8.44
 i     anacron                                              2.3-9      2.3-9
 i     apt-show-versions                                    0.07       0.07
 i A   apt-utils                                            0.5.25     0.5.25
 i     apt-watch                                            0.3.2-2    0.3.2-2
 i     aptitude                                             0.2.14.1-2 0.2.14.1-2

 The Debian distribution consists of packages from the 'main' section. Every
 package in 'main' is Free Software.

 For more information about what Debian considers to be Free Software, see
 http://www.debian.org/social_contract#guidelines





   En plus des touches de fleches, vous pouvez naviguer `a travers la liste
   de paquets, page `a page, en utilisant les touches Page precedente et Page
   suivante.

   [Astuce] Astuce
            Quand toutes les informations ne peuvent etre affichees dans la
            moitie basse de l'ecran, les touches a et z peuvent etre
            utilisees pour faire defiler cette zone.

  Rechercher des paquets par leur nom

   Pour trouver rapidement un paquet dont vous connaissez le nom, appuyez sur
   / pour ouvrir une boite de recherche :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 i     frozen-bubble                                        1.0.0-5    1.0.0-5
 i A   frozen-bubble-data                                   1.0.0-5    1.0.0-5
 i     geekcode                                             1.7.3-1    1.7.3-1
 i     gfpoken                                              0.25-3     0.25-3
 i     ggz-gnome-client                                     0.0.7-2    0.0.7-2
 i     ggz-gtk-client                                       0.0.7-1    0.0.7-1
 i     ggz-gtk-game-data                                    0.0.7-2    0.0.7-2
 i +--------------------------------------------------------------------------+
 i |Search for:                                                               |
 i |froz                                                                      |
 Po|                             [ Ok ]                             [ Cancel ]|
 Fr+--------------------------------------------------------------------------+
 attempt to shoot bubbles into groups of the same color to cause them to pop. It
 features 100 single-player levels, a two-player mode, music and striking
 graphics.

 This game is widely rumored to be responsible for delaying the Woody release.

 URL: http://www.frozen-bubble.org/


   Comme vous pouvez le voir sur la capture precedente, une recherche de froz
   trouve le paquet frozen-bubble. Avec le langage de recherche evolue
   d'aptitude, decrit dans la section intitulee << Search patterns >>, il est
   possible de trouver des paquets en utilisant des criteres plus ou moins
   complexes.

   [Astuce] Astuce
            Vous pouvez rechercher en arriere dans la liste des paquets en
            appuyant sur \ et vous pouvez repeter la derniere recherche en
            appuyant sur n apres avoir ferme la boite de recherche.

   Parfois il est plus pratique de cacher tous les paquets `a l'exception de
   ceux qui correspondent `a quelques criteres particuliers. Pour ce faire,
   appuyez sur l :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 --- Installed Packages
 --- Not Installed Packages
 --- Obsolete and Locally Created Packages
 --- Virtual Packages
 --- Tasks


   +--------------------------------------------------------------------------+
   |Enter the new package tree limit:                                         |
   |apti                                                                      |
   |                             [ Ok ]                             [ Cancel ]|
 Th+--------------------------------------------------------------------------+ a









   Cette boite de dialogue fonctionne exactement comme la boite de recherche,
   sauf qu'au lieu de mettre en evidence le paquet suivant qui correspond `a
   ce que vous tapez dans la boite de dialogue, il cache tous les paquets qui
   ne correspondent pas. Par exemple, taper apti dans cette boite de dialogue
   et appuyer sur Entree va cacher tous les paquets sauf ceux dont le nom
   contient << apti >> :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 --\ Installed Packages
   --\ admin - Administrative utilities (install software, manage users, etc)
     --\ main - The main Debian archive
 i     aptitude                                             0.2.14.1-2 0.2.14.1-2
 i A   synaptic                                             0.51-1     0.51-1
   --\ x11 - The X window system and related software
     --\ main - The main Debian archive
 i     xfree86-driver-synaptics                             0.13.3-1   0.13.3-1
 --- Not Installed Packages
 --- Virtual Packages

 These packages are currently installed on your computer.









  Gerer les paquets

   Maintenant que vous savez vous deplacer dans la liste des paquets, il est
   temps de commencer `a utiliser aptitude pour installer ou supprimer des
   paquets. Dans cette section, vous allez apprendre `a selectionner les
   paquets `a installer, `a supprimer ou `a mettre `a jour.

   [Astuce] Astuce
            Vous ne pouvez changer la configuration globale de votre systeme
            que sous l'utilisateur root. Si vous voulez vous familiariser
            avec aptitude, vous pouvez, sans danger, le lancer en tant
            qu'utilisateur normal avec l'assurance de ne pas pouvoir
            endommager votre systeme. aptitude vous informera quand vous
            essaierez de faire quelque chose que seul l'utilisateur root peut
            faire ; si vous souhaitez continuer, il vous faudra donner le mot
            de passe de root.

   All changes to a package are performed by first highlighting it in the
   package list, then pressing a key corresponding to the action which should
   be performed. The basic action keys ^[2] are + to install or upgrade a
   package, - to remove a package, and = to prevent a package from being
   automatically upgraded (this is known as holding the package). These
   actions are not performed immediately; aptitude will simply update the
   package list to show the change that has been requested.

   Par exemple, dans la capture ci-dessous, le paquet kaffeine a ete
   selectionne et on a presse +. Le paquet est maintenant mis en surbrillance
   en vert et la lettre << i >> est apparue `a gauche de son nom pour
   indiquer qu'il sera installe. De plus, une estimation de l'espace qu'il va
   utiliser est affichee.

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1                  Will use 2925kB of disk space  DL Size: 1375kB
   --\ kde - The KDE Desktop System
     --\ main - The main Debian archive
 p     bibletime-i18n                                        <none>     1.4.1-1
 p     education-desktop-kde                                 <none>     0.771
 p     junior-kde                                            <none>     1.4
 piA   kaffeine                                      +2843kB <none>     0.4.3-1
 pi    kaffeine-mozilla                              +81.9kB <none>     0.4.3-1
 p     karamba                                               <none>     0.17-5
 p     kde-devel                                             <none>     4:3.1.2
 p     kde-devel-extras                                      <none>     4:3.1.2
 The K Desktop Environment (development files)
 A metapackage containing dependencies for the core development suite of KDE
 including kdesdk, qt3-designer, and all core KDE -dev packages.








   [Astuce] Astuce
            A tout moment vous pouvez utiliser Annuler -> Annuler
            (Controle+u) pour << annuler >> les changements faits sur un ou
            plusieurs paquets. C'est tres utile si une action a des
            consequences imprevues, et que vous souhaitez << revenir en
            arriere >>.

   En plus des actions qui affectent des paquets individuels, une autre
   action importante est disponible : taper U va tenter de mettre `a jour
   tous les paquets qui peuvent l'etre. Vous devriez utiliser cette commande
   regulierement pour maintenir votre systeme `a jour.

    Managing broken packages

   Parfois, changer l'etat d'un paquet fait apparaitre ses relations de
   dependances comme non satisfaites. Des paquets avec des dependances non
   satisfaites sont dits casses. aptitude vous avertira quand cela arrive en
   expliquant pourquoi cela est arrive. Par exemple voici ce qui arrive si
   vous tentez de supprimer sound-juicer :

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.3.3       #Broken: 1   Will free 48.6MB of disk space
 i A   nautilus                                             2.10.1-4   2.10.1-4
 i     nautilus-cd-burner                                   2.10.2-1.1 2.10.2-1.1
 i A   nautilus-data                                        2.10.1-4   2.10.1-4
 i     netspeed                                             0.12.1-1   0.12.1-1
 i A   oaf                                                  0.6.10-3   0.6.10-3
 i     pybliographer                                        1.2.6.2-1  1.2.6.2-1
 i     rhythmbox                                            0.8.8-13   0.8.8-13
 i     shermans-aquarium                                    3.0.1-1    3.0.1-1
 idA   sound-juicer                                 -1733kB 2.10.1-3   2.10.1-3
 GNOME 2 CD Ripper
 sound-juicer will be removed.


 The following packages depend on sound-juicer and will be broken by its
 removal:


   * gnome-desktop-environment depends on sound-juicer

 [1(1)/...] Suggest 2 keeps
 e: Examine  !: Apply  .: Next  ,: Previous

   As you can see, aptitude displays three indicators that something has gone
   wrong: first, the number of broken packages is displayed in the upper blue
   area; second, the lower half of the display changes to describe broken
   packages that are related to the currently highlighted package; third, a
   bar appears at the bottom of the screen with a suggestion on how to solve
   the problem. To quickly find broken packages in the package list, you can
   press b or search for ?broken.

   [Note] Note
          Le texte [1(1)/...] indique l'avancement du solveur de dependance
          d'aptitude. Le premier nombre est la solution que vous avez
          actuellement selectionnee, et le second est le nombre de solutions
          qu'aptitude a dej`a trouvees. La presence du texte << ... >>
          indique qu'il pourrait y avoir d'autres solutions que celles dej`a
          trouvees. Si aptitude a l'assurance qu'il a trouve toutes les
          solutions possibles, le texte affiche est alors [1/1].

   Pour voir les autres solutions qui, selon aptitude, peuvent resoudre ce
   probleme, appuyez sur e. Un ecran similaire au suivant apparaitra :

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                 Packages                          Resolve Dependencies
   --\ Keep the following packages at their current version:
     gstreamer0.8-cdparanoia                           [0.8.10-1 (unstable, now)]
     sound-juicer                                                [2.10.1-2 (now)]
















 [1(1)/...] Suggest 2 keeps
 e: Examine  !: Apply  .: Next  ,: Previous

   Ici, vous pouvez voir une autre solution en appuyant sur . ou retourner
   voir les solutions que vous examiniez precedemment en appuyant sur ,. Pour
   appliquer la solution courante et retourner `a la liste des paquets,
   appuyez sur !. Par exemple, appuyer sur . pendant l'ecran precedent passe
   `a la solution suivante :

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                 Packages                          Resolve Dependencies
   --\ Keep the following packages at their current version:
     sound-juicer                                      [2.10.1-3 (unstable, now)]
   --\ Downgrade the following packages:
     gstreamer0.8-cdparanoia          [0.8.11-1 unstable, now -> 0.8.8-3 testing]















 [2(2)/...] Suggest 1 keep,1 downgrade
 e: Examine  !: Apply  .: Next  ,: Previous

   En plus des commandes de navigation, vous pouvez << rejeter >> une
   solution en appuyant sur r. Par exemple, la premiere solution annule la
   suppression de sound-juicer qui est justement l'action que nous tentions
   de faire ! En appuyant sur r pendant la selection de l'item correspondant
   `a cette action, on peut alors faire en sorte qu'aptitude ne tente plus
   d'annuler la suppression de sound-juicer.

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                 Packages                          Resolve Dependencies
   --\ Keep the following packages at their current version:
     gstreamer0.8-cdparanoia                           [0.8.11-1 (unstable, now)]
 R   sound-juicer                                      [2.10.1-3 (unstable, now)]






 GNOME 2 CD Ripper
 gnome-desktop-environment depends upon sound-juicer
 --\ The following actions will resolve this dependency:
   -> Remove gnome-desktop-environment [1:2.10.2.3 (unstable, testing, now)]
 R -> Cancel the removal of sound-juicer
   -> Downgrade sound-juicer [2.10.1-3 (unstable, now) -> 0.6.1-2 (testing)]




 [1(1)/...] Suggest 2 keeps
 e: Examine  !: Apply  .: Next  ,: Previous

   Comme vous pouvez le voir, le choix correspondant `a conserver
   sound-juicer `a sa version actuelle est devenu rouge et a ete marque avec
   << R >> ce qui indique qu'il a ete rejete. Les solutions qui seront
   generees apres cela (c.-`a-d., toutes les solutions que vous n'avez pas
   encore vues) excluront cette action. Cependant les solutions qui incluent
   cette action et qui ont dej`a ete vues resteront disponibles.

   [Note] Note
          Dans la capture d'ecran ci-dessus, la description de sound-juicer
          est affichee au milieu de l'ecran ; En dessous, les dependances,
          qui ont impose de garder sound-juicer dans sa version actuelle,
          sont affichees, suivies de toutes les solutions connues par
          aptitude pour resoudre cette dependance.

   Par exemple, si ce rejet est mis en oeuvre immediatement apres la
   suppression de sound-juicer, appuyer sur . affichera la solution suivante,
   en passant la solution qui annulait l'installation de sound-juicer et
   l'installation de gstreamer0.8-cdparanoia dans une version anterieure.

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                 Packages                          Resolve Dependencies
   --\ Remove the following packages:
     gnome-desktop-environment              [1:2.10.2.3 (unstable, testing, now)]

















 [2(2)/...] Suggest 1 removal
 e: Examine  !: Apply  .: Next  ,: Previous

   Les rejets sont appliques uniquement aux nouvelles solutions,
   c'est-`a-dire `a celles qui sont generees quand vous appuyez sur . lorsque
   la derniere solution generee est affichee. Les solutions dej`a generees
   contiendront toujours ces rejets. Vous pouvez annuler un rejet `a tout
   moment en selectionnant l'action rejetee, puis en appuyant sur r ; des
   solutions contenant cette action pourront etre `a nouveau generees, ainsi
   que celles qui avaient ete precedemment << oubliees >>.

   The opposite of rejecting an action is approving it. To approve an action,
   just select it and press a; this forces the problem resolver to choose the
   action whenever possible^[3]. Approved actions will turn green and will be
   marked with << A >>, as in the following screenshot:

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                 Packages                          Resolve Dependencies
   --\ Remove the following packages:
 A   gnome-desktop-environment              [1:2.10.2.3 (unstable, testing, now)]

















 [2(2)/...] Suggest 1 removal
 e: Examine  !: Apply  .: Next  ,: Previous

   [Important] Important
               Si vous ne resolvez pas toutes les dependances, aptitude
               utilisera automatiquement sa suggestion courante, lorsque vous
               validerez votre selection avec g. Neanmoins, il est difficile
               de resoudre automatiquement des problemes de dependances, et
               vous pourriez ne pas etre satisfait du resultat, si bien qu'il
               est generalement preferable de verifier les suggestions
               d'aptitude avant de mettre `a execution votre selection.

  Mettre `a jour la liste des paquets et installer des paquets

   Arrive ici, vous connaissez assez aptitude pour reellement faire des
   modifications sur votre systeme.

   Vous devriez periodiquement mettre `a jour la liste des paquets
   disponibles depuis les serveurs Debian, afin d'avoir connaissance des
   nouveaux paquets et des nouvelles versions des paquets. Pour ce faire,
   appuyez sur u. A tout moment pendant le telechargement, presser q vous
   permettra de l'abandonner.

   Une fois que vous avez une liste de paquets recente, vous pouvez choisir
   les paquets `a mettre `a jour, `a installer ou `a supprimer comme cela est
   decrit dans la section precedente. Pour passer en revue les actions que
   vous avez demandees, appuyez sur g une seule fois. Si vous installez le
   paquet kaffeine-mozilla (comme dans l'exemple precedent), l'ecran suivant
   apparait :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1                  Will use 2925kB of disk space  DL Size: 1375kB
 --\ Packages being automatically installed to satisfy dependencies
 piA kaffeine                                        +2843kB <none>     0.4.3-1
 --\ Packages to be installed
 pi  kaffeine-mozilla                                +81.9kB <none>     0.4.3-1







 These packages are being installed because they are required by another package
 you have chosen for installation.

 If you select a package, an explanation of its current state will appear in this
 space.





   Comme vous pouvez le voir, aptitude a decide d'installer automatiquement
   kaffeine car kaffeine-mozilla le requiert. A ce moment, vous avez le choix
   entre continuer l'installation en appuyant sur g ou l'abandonner en
   appuyant sur q.

Utiliser aptitude depuis la ligne de commande

   En plus de son interface << visuelle >> decrite dans la section
   precedente, aptitude peut etre utilise pour gerer les paquets directement
   depuis la ligne de commande de la meme maniere que vous utiliseriez
   apt-get. Cette section couvre les actions en ligne de commande les plus
   courantes d'aptitude. Pour plus d'informations, consultez la reference
   pour la ligne de commande d'aptitude.

   En general, une invocation d'aptitude sur la ligne de commande ressemble
   `a ceci :

   aptitude action [arguments...]

   action tells aptitude what action it is to take; the remaining arguments
   are used in an option-specific fashion. Typically they will consist of
   package names and command-line switches^[4].

   Les actions les plus importantes sont :

   aptitude update

           Cette commande met `a jour la liste des paquets comme si vous
           etiez entre dans l'interface graphique et aviez appuye sur u.

   aptitude safe-upgrade

           This command will upgrade as many packages as it can upgrade
           without removing existing packages.

           It is sometimes necessary to remove one package in order to
           upgrade another; this command is not able to upgrade packages in
           such situations. Use the full-upgrade command to upgrade those
           packages as well.

   aptitude full-upgrade

           Like safe-upgrade, this command will attempt to upgrade packages,
           but it is more aggressive about solving dependency problems: it
           will install and remove packages until all dependencies are
           satisfied. Because of the nature of this command, it is possible
           that it will do undesirable things, and so you should be careful
           when using it.

           [Note] Note
                  Pour des raisons historique, cette commande s'appelait `a
                  l'originedist-upgrade, et ce nom est toujours reconnu par
                  aptitude.

   aptitude [ install | remove | purge ] pkg1 [pkg2...]

           These commands install, remove, or purge^[5] the specified
           packages. << Installing >> a package which is already installed
           but can be upgraded will cause it to be upgraded.

   aptitude search pattern1 [pattern2...]

           This command searches for packages whose name contains any of the
           given patterns, printing the result to the terminal. In addition
           to just being a string of text, each pattern can be a search
           pattern as described in la section intitulee << Search
           patterns >>. ^[6] For instance, << aptitude search gnome kde >>
           will list all packages whose name contains either << gnome >> or
           << kde >>.

   aptitude show pkg1 [pkg2...]

           Afficher les informations sur chaque pqt sur le terminal.

   Les commandes qui installent, mettent `a jour ou suppriment des paquets
   acceptent toutes le parametre << -s >>, qui signifie << simuler >>. Quand
   << -s >> est passe sur la ligne de commande, le programme execute les
   actions qu'il devrait normalement effectuer sans reellement telecharger ou
   installer/supprimer aucun fichier.

   aptitude presentera parfois une invite comme celle-ci :

 Les NOUVEAUX paquets suivants vont etre automatiquement installes :
   space-orbit-common
 Les NOUVEAUX paquets suivants vont etre installes :
   space-orbit space-orbit-common
 0 paquets mis `a jour, 2 nouvellement installes, 0 `a enlever et 0 non mis `a jour.
 Il est necessaire de telecharger 3200ko d'archives. Apres depaquetage, 8413ko
 seront utilises.
 Voulez-vous continuer ? [O/n/?]

   En plus des options << Oui >> et << Non >> qui sont evidentes, un certain
   nombre de commandes sont disponibles et peuvent etre utilisees pour
   modifier les informations affichees `a l'invite ou pour specifier des
   options supplementaires. Par exemple, taper s affichera ou cachera
   l'information sur l'espace disque que chaque paquet va utiliser :

 Voulez-vous continuer ? [O/n/?] s

 Les changements de taille seront affiches.

 Les NOUVEAUX paquets suivants vont etre automatiquement installes :
   space-orbit-common <+8020kB>
 Les NOUVEAUX paquets suivants vont etre installes :
   space-orbit <+393kB> space-orbit-common <+8020kB>
 0 paquets mis `a jour, 2 nouvellement installes, 0 `a enlever et 0 non mis `a jour.
 Il est necessaire de telecharger 3200ko d'archives. Apres depaquetage, 8413ko
 seront utilises.
 Voulez-vous continuer ? [O/n/?]

   De maniere analogue, taper d affichera des informations sur les paquets
   automatiquement installes ou supprimes :

 Les NOUVEAUX paquets suivants vont etre automatiquement installes :
   space-orbit-common (D: space-orbit)
 Les NOUVEAUX paquets suivants vont etre installes :
   space-orbit space-orbit-common
 0 paquets mis `a jour, 2 nouvellement installes, 0 `a enlever et 0 non mis `a jour.
 Il est necessaire de telecharger 3200ko d'archives. Apres depaquetage, 8413ko
 seront utilises.

   Cela indique que space-orbit-common est sur le point d'etre installe parce
   que space-orbit en depend. Vous pouvez voir la liste complete des options
   possibles en entrant ? `a l'invite.

   Si votre demande casse une dependance d'une maniere qui ne peut pas etre
   resolue simplement, aptitude vous demandera quoi faire :

 The following packages are BROKEN:
   libsdl1.2debian
 The following packages will be REMOVED:
   libsdl1.2debian-alsa
 .
 .
 .
 The following actions will resolve these dependencies:

 Install the following packages:
 libsdl1.2debian-all [1.2.12-1 (unstable)]

 Score is 41

 Accept this solution? [Y/n/q/?]

   Taper y (ou simplement sur entree) validera la solution proposee. Taper n
   affichera la << meilleure >> solution suivante :

 Accept this solution? [Y/n/q/?] n
 The following actions will resolve these dependencies:

 Install the following packages:
 libsdl1.2debian-esd [1.2.12-1 (unstable)]

 Score is 19

 Accept this solution? [Y/n/q/?]

   Comme dans l'invite principale de la ligne de commande, vous pouvez
   effectuer des actions supplementaires, comme par exemple la modification
   de l'etat d'un paquet depuis l'invite de resolution des dependances. Tapez
   ? pour afficher la liste complete.

   Typing q will abort the automatic resolver and allow you to resolve the
   dependencies manually:

 Accept this solution? [Y/n/q/?] q
 aptitude failed to find a solution to these dependencies.  You can solve them yourself by hand or type 'n' to quit.
 The following packages have unmet dependencies:
   libsdl1.2debian: Depends: libsdl1.2debian-alsa (= 1.2.12-1) but it is not installable or
                             libsdl1.2debian-all (= 1.2.12-1) but it is not installable or
                             libsdl1.2debian-esd (= 1.2.12-1) but it is not installable or
                             libsdl1.2debian-arts (= 1.2.12-1) but it is not installable or
                             libsdl1.2debian-oss (= 1.2.12-1) but it is not installable or
                             libsdl1.2debian-nas (= 1.2.12-1) but it is not installable or
                             libsdl1.2debian-pulseaudio (= 1.2.12-1) but it is not installable
 Resolve these dependencies by hand? [N/+/-/_/:/?]

   You can use any of the package manipulation commands to resolve the broken
   dependencies (type ? for a full list of the available commands). Type n or
   press enter to quit aptitude:

 Resolve these dependencies by hand? [N/+/-/_/:/?] n
 Abort.

   Pour une documentation complete des caracteristiques de la ligne de
   commande d'aptitude, consultez la Command-line reference.

   --------------

   ^[2] Vous pouvez aussi utiliser le menu Paquet pour modifier l'etat d'un
   paquet. Consultez la section intitulee << The Package menu >> pour plus de
   details.

   ^[3] Approuver une action est un peu different de simplement imposer que
   toute solution contienne l'action ; cela signifie qu'`a choisir entre une
   action approuvee et une qui ne l'est pas, il prendra la premiere. S'il y a
   plusieurs actions approuvees, elles seront toutes susceptibles d'etre
   proposees dans la solution.

   ^[4] Une << option courte >> est une lettre precedee d'un tiret, par
   exemple, << -a >>, << -v >>, etc.

   ^[5] Purger un paquet supprime le paquet ainsi que tous ses fichiers de
   configuration.

   ^[6] En fait, c'est aussi vrai pour les commandes qui prennent des paquets
   en argument, comme install ou show.

Chapitre 2. aptitude reference guide

   Table des matieres

   The aptitude terminal user interface

                Utiliser les menus

                Commandes du menu

                Travailler avec plusieurs vues

                Devenir administrateur (<< root >>)

   Gerer les paquets

                Gerer la liste des paquets

                Acceder aux informations des paquets

                Modifier l'etat d'un paquet

                Telecharger, installer et supprimer des paquets

                Qu'est-ce que la confiance en matiere de gestion des
                paquets ?

                Gerer les paquets automatiquement installes

   Resolving package dependencies

                Dependency resolution in aptitude

                Immediate dependency resolution

                Resolving Dependencies Interactively

                Costs in the interactive dependency resolver

                Configuring the interactive dependency resolver

   Search patterns

                Searching for strings

                Shorthand for search terms

                Searches and versions

                Explicit search targets

                Search term reference

   Personnalisation d'aptitude

                Customizing the package list

                Personnaliser les raccourcis clavier

                Personnaliser la couleur du texte et les styles

                Personnaliser la disposition de l'affichage

                Reference du fichier de configuration

                Themes

   Jouer au demineur

     Le Lapin Blanc mit ses lunettes. << Ou dois-je commencer votre
     Majeste ? >> demanda-t-il.

     << Commence au commencement >>, repondit gravement le Roi, << et
     continue jusqu'`a ce que tu arrives `a la fin, alors arrete-toi. >>
                                -- Lewis Carrol, Alice au pays des merveilles

   aptitude is a large program with many features, and it is sometimes
   difficult to remember how to do something, or even to remember whether
   that something is even possible. Indeed, many feature requests received by
   the author describe features which are already present but are difficult
   to find.^[7]

   Dans une tentative pour combattre cette opacite, ce guide de reference
   decrit toutes les fonctionnalites et les parametres de configuration
   d'aptitude. Pour un guide plus abordable sur les fonctionnalites les plus
   importantes d'aptitude, consultez Chapitre 1, Getting started.

   [Note] Note
          Le comportement et l'apparence d'aptitude peuvent etre configures
          de nombreuses fac,ons. Ce manuel decrit comment le programme
          fonctionne avec la configuration par defaut. La description de la
          maniere dont differentes configurations affectent son comportement
          est donnee dans la section intitulee << Personnalisation
          d'aptitude >>.

The aptitude terminal user interface

   This section describes the parts of the terminal-based user interface of
   aptitude that do not deal with managing packages.

  Utiliser les menus

   La barre de menu en haut de l'ecran liste les commandes les plus
   importantes d'aptitude. Pour activer la barre de menu, utilisez le
   raccourci clavier Control+t, vous pouvez alors vous y deplacer avec les
   touches de fleches et selectionner une entree du menu avec Entree.

   Certaines entrees du menu ont aussi des << cles d'acces rapide >> :
   lettres ou chiffres qui peuvent etre utilises pour selectionner une entree
   alors que le menu est actif. Ces cles d'acces rapide sont affichees avec
   une nuance de blanc plus clair que le reste du menu.

   En plus, certaines entrees du menu ont des << raccourcis clavier >> qui
   effectuent la meme action que l'entree du menu meme lorsque le menu n'est
   pas actif. Ces raccourcis sont indiques `a droite des entrees du menu.

   In the remainder of the manual, menu commands will be written like this:
   Menu -> Item (key). This indicates that you should choose Item from the
   Menu menu, and that key is the shortcut for this command.

  Commandes du menu

    The Actions menu

   Figure 2.1. Commandes disponibles dans le menu Actions

   +------------------------------------------------------------------------+
   |         Commande          |                Description                 |
   |---------------------------+--------------------------------------------|
   |                           | Si un aperc,u d'installation n'est pas     |
   | Actions ->                | visible, en affiche un. Sinon lance un     |
   | Installer/enlever des     | processus d'installation comme decrit dans |
   | paquets (g)               | la section intitulee << Telecharger,       |
   |                           | installer et supprimer des paquets >>.     |
   |---------------------------+--------------------------------------------|
   | Actions -> Mettre `a jour | Met `a jour la liste des paquets.          |
   | les listes de paquets (u) |                                            |
   |---------------------------+--------------------------------------------|
   | Actions -> Marquer comme  | Marque tous les paquets susceptibles de    |
   | etant susceptible de mise | l'etre, `a l'exception de ceux qui sont    |
   | `a jour (U)               | geles ou interdits de mise `a jour, comme  |
   |                           | devant etre mis `a jour.                   |
   |---------------------------+--------------------------------------------|
   | Actions -> Oublier quels  | Oublie quels paquets sont << nouveaux >>   |
   | paquets sont nouveaux (f) | (c'est-`a-dire vide l'arborescence         |
   |                           | << Nouveaux paquets >>).                   |
   |---------------------------+--------------------------------------------|
   |                           | Annule toutes les installations, les       |
   | Actions -> Annuler les    | suppressions et les gels de paquets en     |
   | actions en attente        | attente. Cela revient `a executer sur      |
   |                           | l'ensemble des paquets la commande pour    |
   |                           | les garder dans leur etat actuel.          |
   |---------------------------+--------------------------------------------|
   | Actions -> Nettoyer le    | Delete all the compressed packages that    |
   | cache des paquets         | were downloaded by aptitude ^[a].          |
   |---------------------------+--------------------------------------------|
   |                           | Supprime toutes les archives de paquets    |
   |                           | qui ont ete telechargees par aptitude^[a]  |
   |                           | et qui ne sont plus disponibles dans les   |
   | Actions -> Enlever les    | archives Debian. On peut supposer que ce   |
   | fichiers perimes          | sont des paquets obsoletes et qui peuvent  |
   |                           | etre supprimes pour liberer de l'espace    |
   |                           | disque sans que cela ne necessite de       |
   |                           | telechargements inutiles par ailleurs.     |
   |---------------------------+--------------------------------------------|
   | Actions -> Jouer au       | Lance le demineur, comme cela est decrit   |
   | demineur                  | dans la section intitulee << Jouer au      |
   |                           | demineur >>.                               |
   |---------------------------+--------------------------------------------|
   |                           | Continue `a travailler en tant             |
   | Actions -> Devenir        | qu'utilisateur root. Voir la section       |
   | administrateur            | intitulee << Devenir administrateur        |
   |                           | (<< root >>) >>.                           |
   |---------------------------+--------------------------------------------|
   | Actions -> Quitter (Q)    | Quit aptitude, saving any changes to       |
   |                           | package states.                            |
   |------------------------------------------------------------------------|
   | ^[a] ou tout autre utilitaire apt.                                     |
   +------------------------------------------------------------------------+

    The Undo menu

   Figure 2.2. Commandes disponibles dans le menu Annuler

   +------------------------------------------------------------------------+
   |      Commande      |                    Description                    |
   |--------------------+---------------------------------------------------|
   |                    | Cancel the effect of the last change to a         |
   | Annuler -> Annuler | package's state, up to the last time aptitude was |
   | (Controle+u)       | started, the package list was updated, or an      |
   |                    | install run was performed.                        |
   +------------------------------------------------------------------------+

    The Package menu

   Figure 2.3. Commandes disponibles dans le menu Paquet

   +------------------------------------------------------------------------+
   |        Commande         |                 Description                  |
   |-------------------------+----------------------------------------------|
   | Paquet -> Installer (+) | Marque le paquet actuellement selectionne    |
   |                         | pour installation.                           |
   |-------------------------+----------------------------------------------|
   | Paquet -> Supprimer (-) | Marque le paquet actuellement selectionne    |
   |                         | pour suppression.                            |
   |-------------------------+----------------------------------------------|
   | Paquet -> Purger (_)    | Marque le paquet actuellement selectionne    |
   |                         | pour purge.                                  |
   |-------------------------+----------------------------------------------|
   |                         | Annule toute installation, mise `a jour ou   |
   | Paquet -> Garder (:)    | suppression prevue pour le paquet            |
   |                         | actuellement selectionne et retire tout gel  |
   |                         | qui aurait ete mis sur le paquet.            |
   |-------------------------+----------------------------------------------|
   | Paquet -> Geler (=)     | Gele le paquet actuellement selectionne.     |
   |-------------------------+----------------------------------------------|
   |                         | Marque le paquet actuellement selectionne    |
   |                         | comme etant un paquet << installe            |
   | Paquet -> Marquer       | automatiquement >>. Pour plus d'informations |
   | automatiquement (M)     | sur les paquets installes manuellement et    |
   |                         | automatiquement, consultez la section        |
   |                         | intitulee << Gerer les paquets               |
   |                         | automatiquement installes >>.                |
   |-------------------------+----------------------------------------------|
   |                         | Marque le paquet actuellement selectionne    |
   |                         | comme etant un paquet << installe            |
   | Paquet -> Marquer       | manuellement >>. Pour plus d'informations    |
   | manuellement (m)        | sur les paquets installes manuellement et    |
   |                         | automatiquement, consultez la section        |
   |                         | intitulee << Gerer les paquets               |
   |                         | automatiquement installes >>.                |
   |-------------------------+----------------------------------------------|
   |                         | Si un paquet qui peut etre mis `a jour est   |
   |                         | selectionne, cela interdit sa mise `a jour   |
   | Paquet -> Interdire la  | vers la version actuellement disponible      |
   | version (F)             | uniquement. Si une version du paquet est     |
   |                         | selectionnee, cela interdit au paquet d'etre |
   |                         | mis `a jour vers cette version.              |
   |-------------------------+----------------------------------------------|
   |                         | Affiche un ecran contenant des informations  |
   | Paquet -> Informations  | sur le paquet actuellement selectionne,      |
   | (entree)                | comme les paquets dont il depend, les        |
   |                         | paquets qui en dependent, et ses versions    |
   |                         | disponibles.                                 |
   |-------------------------+----------------------------------------------|
   |                         | When browsing the package list, cycles       |
   |                         | through the information that can be          |
   |                         | displayed in the information area (the lower |
   |                         | half of the display). The information area   |
   | Package -> Cycle        | can display the long description of the      |
   | Information (i)         | selected package (its default behavior), a   |
   |                         | summary of the dependencies related to the   |
   |                         | package, or an analysis of which other       |
   |                         | packages require or suggest the selected     |
   |                         | package.                                     |
   |-------------------------+----------------------------------------------|
   |                         | Affiche la liste des modifications du paquet |
   | Paquet -> Liste des     | Debian actuellement selectionne. Pour voir   |
   | modifications (C)       | les modifications d'une version              |
   |                         | particuliere, selectionnez cette version     |
   |                         | avant d'executer cette commande.             |
   +------------------------------------------------------------------------+

    The Resolver menu

   Figure 2.4. Commandes disponibles dans le menu Solveur

   +------------------------------------------------------------------------+
   |    Commande    |                      Description                      |
   |----------------+-------------------------------------------------------|
   | Solutions ->   | Affiche une description detaillee de la suggestion    |
   | Examiner la    | actuelle.                                             |
   | solution (e)   |                                                       |
   |----------------+-------------------------------------------------------|
   | Solutions ->   |                                                       |
   | Appliquer la   | Execute les actions actuellement suggerees.           |
   | solution (!)   |                                                       |
   |----------------+-------------------------------------------------------|
   | Solutions ->   |                                                       |
   | Solution       | Selectionne la suggestion suivante.                   |
   | suivante (.)   |                                                       |
   |----------------+-------------------------------------------------------|
   | Solutions ->   |                                                       |
   | Solution       | Selectionne la suggestion precedente.                 |
   | precedente (,) |                                                       |
   |----------------+-------------------------------------------------------|
   | Solutions ->   |                                                       |
   | Premiere       | Selectionne la premiere suggestion.                   |
   | solution (<)   |                                                       |
   |----------------+-------------------------------------------------------|
   | Solutions ->   | Selectionne la suggestion la plus recente (voir la    |
   | Derniere       | section intitulee << Resolving Dependencies           |
   | solution (>)   | Interactively >>).                                    |
   |----------------+-------------------------------------------------------|
   |                | Lors de l'examen d'une solution, rejette l'action     |
   | Solutions ->   | actuellement selectionnee et passe `a l'action        |
   | Marquer comme  | suivante (voir la section intitulee << Resolving      |
   | rejete (r)     | Dependencies Interactively >>). Si l'action etait     |
   |                | dans l'etat approuve, son approbation est annulee.    |
   |----------------+-------------------------------------------------------|
   |                | Lors de l'examen d'une solution, approuve l'action    |
   | Solutions ->   | actuellement selectionnee et passe `a l'action        |
   | Marquer comme  | suivante (voir la section intitulee << Resolving      |
   | retenu (a)     | Dependencies Interactively >>). Si l'action etait     |
   |                | dans l'etat rejete, son rejet est annule.             |
   |----------------+-------------------------------------------------------|
   |                | Lors de l'examen d'une solution, affiche des          |
   | Solveur ->     | informations detaillees sur le paquet touche par      |
   | Afficher la    | l'action actuellement selectionnee (voir la section   |
   | cible (entree) | intitulee << Resolving Dependencies                   |
   |                | Interactively >>).                                    |
   |----------------+-------------------------------------------------------|
   |                | Reject (as if with Solutions -> Marquer comme rejete  |
   |                | (r)) all actions that would break a hold on a package |
   | Resolver ->    | or install a forbidden version. These actions are     |
   | Reject         | rejected by default unless                            |
   | Breaking Holds | Aptitude::ProblemResolver::Allow-Break-Holds is set   |
   |                | to true, but this menu item allows you to reject them |
   |                | manually at any time.                                 |
   +------------------------------------------------------------------------+

    The Search menu

   Figure 2.5. Commandes disponibles dans le menu Rechercher

   +------------------------------------------------------------------------+
   |         Commande         |                 Description                 |
   |--------------------------+---------------------------------------------|
   |                          | Recherche le paquet suivant dans la liste   |
   | Rechercher -> Rechercher | des paquets qui correspond au motif de      |
   | (/)                      | recherche (voir la section intitulee        |
   |                          | << Search patterns >>).                     |
   |--------------------------+---------------------------------------------|
   |                          | Recherche le paquet precedent dans la liste |
   | Search -> Rechercher en  | des paquets qui correspond au motif de      |
   | arriere (\)              | recherche (voir la section intitulee        |
   |                          | << Search patterns >>).                     |
   |--------------------------+---------------------------------------------|
   | Rechercher -> Rechercher | Repete la derniere recherche.               |
   | `a nouveau (n)           |                                             |
   |--------------------------+---------------------------------------------|
   |                          | Repeter la derniere commande, mais dans le  |
   | Rechercher -> Rechercher | sens inverse. Si la derniere commande       |
   | en arriere (N)           | Rechercher etait Rechercher vers le haut,   |
   |                          | alors cela executera un Rechercher vers le  |
   |                          | bas, et vice versa.                         |
   |--------------------------+---------------------------------------------|
   |                          | Filtre la liste de paquets en omettant tous |
   | Rechercher -> Affichage  | les paquets qui ne correspondent pas au     |
   | restreint (l)            | motif de recherche (voir la section         |
   |                          | intitulee << Search patterns >>).           |
   |--------------------------+---------------------------------------------|
   | Rechercher -> Affichage  | Retire le filtrage de la liste de paquets   |
   | complet                  | (tous les paquets sont affiches).           |
   |--------------------------+---------------------------------------------|
   | Rechercher -> Rechercher | Find the next broken package. This is       |
   | les casses (b)           | equivalent to searching for ?broken.        |
   +------------------------------------------------------------------------+

    The Options menu

   Figure 2.6. Commandes disponibles dans le menu Options

   +------------------------------------------------------------------------+
   |        Commande        |                  Description                  |
   |------------------------+-----------------------------------------------|
   |                        | Open a new top-level view in which you can    |
   |                        | modify aptitude's settings. Configuration     |
   |                        | options are displayed in a tree similar to    |
   | Options -> Preferences | the tree of packages; to enable or disable an |
   |                        | option, select it and press Space or Enter.   |
   |                        | Configuration options are saved to            |
   |                        | ~/.aptitude/config immediately upon being     |
   |                        | selected.                                     |
   |------------------------+-----------------------------------------------|
   | Options -> Revenir aux | Revient aux options de configuration par      |
   | options par defaut     | defaut.                                       |
   +------------------------------------------------------------------------+

    The Views menu

   [Note] Note
          Pour un aperc,u du fonctionnement des vues, voir la section
          intitulee << Travailler avec plusieurs vues >>.

   Figure 2.7. Commandes disponibles dans le menu Vues

   +------------------------------------------------------------------------+
   |          Commande          |                Description                |
   |----------------------------+-------------------------------------------|
   | Vues -> Suivant (F6)       | Va `a la vue active suivante.             |
   |----------------------------+-------------------------------------------|
   | Vues -> Precedent (F7)     | Va `a la precedente vue active.           |
   |----------------------------+-------------------------------------------|
   | Vues -> Fermer (q)         | Ferme la vue actuelle.                    |
   |----------------------------+-------------------------------------------|
   | Vues -> Nouvelle vue des   | Cree une nouvelle vue de la liste des     |
   | paquets                    | paquets.                                  |
   |----------------------------+-------------------------------------------|
   | Vues -> Voir les           | Cree une vue qui affiche les paquets qui  |
   | recommandations            | ne sont pas installes et qu'un paquet     |
   |                            | installe sur votre systeme recommande.    |
   |----------------------------+-------------------------------------------|
   | Vues -> Nouvelle liste des | Cree une nouvelle vue de la liste des     |
   | paquets                    | paquets dans laquelle les paquets ne sont |
   |                            | pas tries.                                |
   |----------------------------+-------------------------------------------|
   |                            | Cree une nouvelle vue de la liste des     |
   | Vues -> Consultation par   | paquets dans laquelle les paquets sont    |
   | << Debtags >>              | ranges en fonction de leur entree         |
   |                            | debtags.                                  |
   |----------------------------+-------------------------------------------|
   | Vues -> Consultation par   | Affiche la liste des paquets, organisee   |
   | categories                 | par categorie.                            |
   |----------------------------+-------------------------------------------|
   |                            | D'autres entrees du menu apparaissent. Il |
   | Entrees supplementaires    | s'agit des vues actuellement actives.     |
   |                            | Pour atteindre directement une vue,       |
   |                            | selectionnez-la dans ce menu.             |
   +------------------------------------------------------------------------+

    The Help menu

   Figure 2.8. Commandes disponibles dans le menu Aide

   +------------------------------------------------------------------------+
   |          Commande          |                Description                |
   |----------------------------+-------------------------------------------|
   | Aide -> A propos           | Affiche des informations de copyright.    |
   |----------------------------+-------------------------------------------|
   | Aide -> Aide (?)           | Affiche l'aide en ligne.                  |
   |----------------------------+-------------------------------------------|
   | Aide -> Manuel Utilisateur | Affiche le manuel de l'utilisateur (ce    |
   |                            | document).                                |
   |----------------------------+-------------------------------------------|
   | Aide -> FAQ                | Affiche la FAQ d'aptitude.                |
   |----------------------------+-------------------------------------------|
   | Aide -> Liste des          | Affiche la liste des principales          |
   | modifications              | modifications apportees `a aptitude.      |
   |----------------------------+-------------------------------------------|
   |                            | Affiche les termes de la licence sous     |
   | Aide -> Licence            | laquelle vous pouvez copier, modifier et  |
   |                            | distribuer aptitude.                      |
   +------------------------------------------------------------------------+

  Travailler avec plusieurs vues

   aptitude vous permet de travailler avec plusieurs << vues >> `a la fois.
   Une << vue >> (parfois appelee << ecran >>) est simplement quelque chose
   qui apparait dans une zone de l'ecran en dessous de la barre de menu. La
   vue la plus courante est la liste des paquets, la vue des telechargements
   est aussi assez courante.

   Quand plusieurs vues sont ouvertes en meme temps, une barre listant
   l'ensemble des vues actives apparait en haut de l'ecran. Par exemple, si
   on examine apt en appuyant sur entree, puis qu'on examine libc6, l'ecran
   ressemblera `a ceci :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
          Packages                  apt info                  libc6 info
 aptitude 0.3.1
 i A  --\ libc6                                             2.3.2.ds1- 2.3.2.ds1-
   Description: GNU C Library: Shared libraries and Timezone data
     Contains the standard libraries that are used by nearly all programs on the
     system. This package includes shared versions of the standard C library and
     the standard math library, as well as many others. Timezone data is also
     included.
   Priority: required
   Section: base
   Maintainer: GNU Libc Maintainers <debian-glibc@lists.debian.org>
   Compressed size: 4901k
   Uncompressed size: 15.9M
   Source Package: glibc
   --\ Depends
     --- libdb1-compat
   --\ Suggests
     --- locales
     --- glibc-doc
   --\ Conflicts
 GNU C Library: Shared libraries and Timezone data

   Vous pouvez fermer la vue courante avec Vues -> Fermer (q). Pour atteindre
   les vues precedentes et suivantes, utilisez Vues -> Suivant (F6) et Vues
   -> Precedent (F7) ou cliquez sur le nom de la vue en haut de l'ecran. Vous
   pouvez aussi trouver une liste de toutes les vues actives dans le menu
   Vues.

   Comme ci-dessus, certaines commandes (par exemple, voir les informations
   d'un paquet) vont creer automatiquement de nouvelles vues. Vous pouvez
   aussi demander la creation d'une nouvelle vue avec Vues -> Nouvelle vue
   des paquets ou Vues -> Consultation par categories.

  Devenir administrateur (<< root >>)

   Certaines actions, telles que la mise `a jour de la liste des paquets, ne
   peuvent etre realisees qu'en tant que root. Si vous n'etes pas root au
   moment de mettre `a jour la liste des paquets, aptitude va vous demander
   de le devenir :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 --- Installed Packages
 --- Not Installed Packages
 --- Obsolete and Locally Created Packages
 --- Virtual Packages
 --- Tasks

   +-------------------------------------------------------------------------+
   |Updating the package lists requires administrative privileges, which     |
   |you currently do not have.  Would you like to change to the root account?|
   |                                                                         |
   |         [ Become root ]                  [ Don't become root ]          |
 Th+-------------------------------------------------------------------------+









   Si vous selectionnez << Devenir administrateur >>, aptitude va vous
   demander de saisir le mot de passe de root. Une fois que vous l'aurez
   correctement saisi, aptitude effectuera les actions qui ont necessite les
   droits d'administration. Vous resterez root apres la fin de l'action.

   Vous pouvez passer sous le compte root `a tout moment en utilisant la
   commande Actions -> Devenir administrateur. Tous les changements que vous
   avez apportes `a l'etat des paquets sont preserves (mais ils ne seront
   sauvegardes qu'`a la fermeture d'aptitude).

   By default, aptitude will use the command su to gain root privileges. If
   you would like it to use some other command (such as sudo), set the
   configuration option Aptitude::Get-Root-Command.

Gerer les paquets

   Cette section decrit comment manipuler la liste des paquets, comment
   installer de nouveaux paquets sur votre systeme et comment supprimer de
   vieux paquets.

  Gerer la liste des paquets

   Pour garder la liste des paquets `a jour, il est recommande de la mettre
   `a jour regulierement. Vous pouvez le faire grace `a la commande Actions
   -> Mettre `a jour les listes de paquets (u).

  Acceder aux informations des paquets

   Les informations sur les paquets sont presentes `a plusieurs endroits : la
   liste des paquets donne un aperc,u rapide de l'etat de chaque paquet et
   d'autres vues sont aussi disponibles avec des informations detaillees sur
   chaque paquet.

    The package list

   La liste des paquets montre un resume succinct de l'etat d'un paquet. Par
   exemple, le paquet webmin pourrait avoir le resume suivant :

 piAU  webmin                                        +5837kB <aucun>    1.160-2

   Les quatre caracteres sur la gauche indiquent que le paquet n'est pas
   installe (<< p >>), qu'il est sur le point d'etre installe (<< i >>),
   qu'il a ete installe automatiquement (<< A >>), et qu'il ne provient pas
   d'une source fiable (<< U >>). A droite, on peut lire la version actuelle
   et la version la plus recente disponible, ainsi qu'une indication de
   l'espace supplementaire que l'installation va utiliser.

   [Astuce] Astuce
            Vous pouvez personnaliser la maniere d'afficher ce resume.
            Consultez la section intitulee << Personnaliser la maniere
            d'afficher les paquets >> pour plus de details.

   Les quatre indicateurs d'etat sur la gauche de l'ecran donnent les
   informations de base sur l'etat d'un paquet. Le premier caractere indique
   l'etat courant du paquet. Le second indique l'action qui sera entreprise
   sur le paquet. Le troisieme indique si le paquet a ete automatiquement
   installe (voir la section intitulee << Gerer les paquets automatiquement
   installes >>). Enfin, le quatrieme indique si le paquet est fiable (voir
   la section intitulee << Qu'est-ce que la confiance en matiere de gestion
   des paquets ? >>).

   Les valeurs possibles pour l'indicateur de << l'etat courant >> sont
   donnees dans Figure 2.9, << Valeurs de l'indicateur de << l'etat
   courant >> >> et les valeurs possibles de l'indicateur << d'action >> sont
   donnees dans Figure 2.10, << Valeurs de l'indicateur << d'action >> >>.

   Figure 2.9. Valeurs de l'indicateur de << l'etat courant >>

   i - le paquet est installe et toutes ses dependances sont satisfaites.
   c - le paquet a ete supprime mais ses fichiers de configuration sont
       toujours presents sur le systeme.
   p - le paquet et tous ses fichiers de configuration ont ete supprimes, ou
       le paquet n'a jamais ete installe.
   v - le paquet est virtuel.
   B - le paquet a des dependances cassees.
   u - le paquet a ete depaquete mais pas configure.
   C - `a moitie configure : la configuration du paquet a ete interrompue.
   H - `a moitie installe : l'installation du paquet a ete interrompue.

   Figure 2.10. Valeurs de l'indicateur << d'action >>

   i - le paquet va etre installe.
   u - le paquet va etre mis `a jour.
   d - le paquet va etre supprime : il sera supprime mais ses fichiers de
       configuration resteront sur le systeme.
   p - le paquet va etre purge : lui et ses fichiers de configuration seront
       supprimes.
       le paquet est gele : il sera garde dans sa version actuelle, meme si
   h - une version plus recente est disponible, jusqu'`a ce que le gel soit
       retire.
   F - toute mise `a jour du paquet est interdite.
   r - le paquet va etre reinstalle.
       le paquet est << casse >> : certaines de ses dependances ne sont pas
   B - satisfaites. aptitude ne vous permettra pas d'installer, supprimer ou
       mettre `a jour quoique ce soit tant que des paquets sont casses.

   De plus, si le terminal le permet, aptitude utilise des couleurs pour
   indiquer l'etat d'un paquet. La distinction entre les etats se fait
   principalement grace `a la couleur de l'arriere plan :

   Noir

           Le paquet ne peut pas etre mise `a jour (ou il ne sera pas
           installe) et il n'a pas de probleme de dependance. Si le paquet
           est dej`a installe, son nom est en surbrillance.

   Vert

           Le paquet est sur le point d'etre installe.

   Bleu

           Le paquet est actuellement installe et il va etre mis `a jour.

   Magenta

           Le paquet est actuellement installe, mais il va etre supprime.

   Blanc

           Le paquet est actuellement installe et il est << gele >> dans sa
           version courante : les mises `a jour automatiques l'ignoreront.

   Rouge

           Le paquet est casse : certaines de ces dependances ne sont pas
           satisfaites.

   Enfin, la moitie inferieure de l'ecran affiche la description longue.
   aptitude tentera de detecter si le paquet est implique dans des problemes
   de dependances. Si c'est le cas, des informations concernant ces problemes
   de dependances y seront affichees. Pour passer des informations de
   dependances `a la description du paquet, et inversement, appuyez sur i.

    Information detaillee d'un paquet

   Appuyer sur Entree pendant qu'un paquet est en surbrillance affichera un
   ecran contenant les informations sur ce paquet :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 i A --\ apt                                                0.5.25     0.5.25
   Description: Advanced front-end for dpkg
     This is Debian's next generation front-end for the dpkg package manager. It
     provides the apt-get utility and APT dselect method that provides a simpler,
     safer way to install and upgrade packages.

     APT features complete installation ordering, multiple source capability and
     several other unique features, see the Users Guide in apt-doc.
   Essential: yes
   Priority: important
   Section: base
   Maintainer: APT Development Team <deity@lists.debian.org>
   Compressed size: 970k
   Uncompressed size: 2961k
   Source Package: apt
   --\ Depends
     --- libc6 (>= 2.3.2.ds1-4)
     --- libgcc1 (>= 1:3.3.3-1)
     --- libstdc++5 (>= 1:3.3.3-1)
   --\ Suggests
     --- aptitude | synaptic | gnome-apt | wajig
     --- dpkg-dev
     --\ apt-doc (UNSATISFIED)
 p     0.6.25
 p     0.5.25
   --\ Replaces
     --- libapt-pkg-doc (< 0.3.7)
     --- libapt-pkg-dev (< 0.3.7)
   --- Package names provided by apt
   --- Packages which depend on apt
   --\ Versions
 p A 0.6.25
 i A 0.5.25


   On peut naviguer dans cet ecran de maniere similaire `a la liste des
   paquets : par exemple, dans la capture precedente, l'arbre des dependances
   sur apt-doc fait apparaitre les versions disponibles d'apt-doc qui peuvent
   satisfaire la dependance. Ces versions peuvent etre manipulees de la meme
   maniere que les paquets : par exemple, pour installer la version 0.5.25 de
   apt-doc, il vous suffit de la mettre en surbrillance et d'appuyer sur +.

   [Astuce] Astuce
            Pour satisfaire rapidement une dependance, selectionnez-la et
            appuyez sur +. aptitude tentera automatiquement de la satisfaire.

   En plus des dependances d'un paquet, vous pouvez voir le nom des paquets
   qu'il fournit, les paquets qui dependent de lui, ainsi que les versions
   disponibles du paquet (en incluant tous les paquets qui le fournissent).

   Comme d'habitude, vous pouvez quitter cet ecran et retourner `a la vue
   principale en appuyant sur q. Par commodite, quelques autres ecrans
   d'information (qui n'affichent que quelques informations courantes et
   cachent le reste) sont disponibles : appuyez sur v pour voir les versions
   d'un paquet, d pour voir les dependances d'un paquet et r pour voir les
   << dependances inverses >> d'un paquet (c'est-`a-dire les paquets qui
   dependent de ce paquet).

  Modifier l'etat d'un paquet

   Les commandes suivantes sont disponibles pour modifier l'etat des paquets.
   Ces commandes prennent effet au prochain lancement d'un processus
   d'installation. Jusque-l`a, toutes ces commandes peuvent etre annulees en
   utilisant Annuler -> Annuler (Controle+u).

   Pour appliquer une commande `a un paquet, il suffit de le selectionner
   dans une liste de paquets et d'executer la commande. Ces commandes peuvent
   aussi etre appliquees `a un groupe de paquets en selectionnant l'en-tete
   du groupe (par exemple : << Paquets pouvant etre mis `a jour >>) et en
   executant la commande.

   +------------------------------------------------------------------------+
   |          Commande           |               Description                |
   |-----------------------------+------------------------------------------|
   |                             | Marque le paquet courant pour            |
   |                             | installation.                            |
   |                             |                                          |
   | Installation : Paquet ->    | Si le paquet n'est pas installe, il le   |
   | Installer (+)               | sera. S'il est dej`a installe, il sera   |
   |                             | mis `a jour, si possible, et les         |
   |                             | eventuels marquages empechant sa mise `a |
   |                             | jour (p. ex. Gel) seront annules.        |
   |-----------------------------+------------------------------------------|
   |                             | Marque le paquet courant pour            |
   | Suppression : Paquet ->     | suppression.                             |
   | Supprimer (-)               |                                          |
   |                             | Si le paquet est installe, il sera       |
   |                             | supprime.                                |
   |-----------------------------+------------------------------------------|
   |                             | Marque le paquet courant pour purge.     |
   |                             |                                          |
   | Purge : Paquet -> Purger    | Si le paquet est installe, il sera       |
   | (_)                         | supprime. De plus, s'il est dej`a        |
   |                             | supprime, tout fichier restant (comme    |
   |                             | les fichiers de configuration) lie `a ce |
   |                             | paquet sera supprime du systeme.         |
   |-----------------------------+------------------------------------------|
   |                             | Marque le paquet courant pour qu'il soit |
   |                             | garde dans sa version actuelle.          |
   | Garde : Paquet -> Garder    |                                          |
   | (:)                         | Toute action qui etait prevue sur le     |
   |                             | paquet (installation, suppression ou     |
   |                             | mise `a jour) est annulee et tout gel    |
   |                             | persistant sur le paquet est retire.     |
   |-----------------------------+------------------------------------------|
   |                             | Place un gel persistant sur le paquet.   |
   |                             |                                          |
   |                             | As with Keep, any action that was to be  |
   | Gel : Paquet -> Geler (=)   | performed on the package is cancelled.   |
   |                             | In addition, the package will not be     |
   |                             | automatically upgraded ^[a] until the    |
   |                             | hold is removed. You may cancel a hold   |
   |                             | by issuing the Install command.          |
   |-----------------------------+------------------------------------------|
   |                             | Le paquet ne sera pas automatiquement    |
   |                             | mis `a jour^[a] vers la version vers     |
   |                             | laquelle il peut actuellement l'etre.    |
   |                             | S'il est sur le point d'etre installe,   |
   |                             | sa mise `a jour sera annulee.            |
   |                             |                                          |
   |                             | Si vous lancez cette commande sur une    |
   |                             | version particuliere d'un paquet, le     |
   | Paquet -> Interdire la      | paquet ne sera pas mis `a jour vers la   |
   | version (F)                 | version selectionnee. Remarquez qu'on ne |
   |                             | peut interdire qu'une seule version `a   |
   |                             | la fois.                                 |
   |                             |                                          |
   |                             | Cette fonction est principalement        |
   |                             | fournie pour faciliter la vie des        |
   |                             | utilisateurs de la distribution          |
   |                             | << unstable >>, afin qu'ils puissent     |
   |                             | eviter certaines versions de paquet      |
   |                             | connues comme etant defectueuses.        |
   |-----------------------------+------------------------------------------|
   |                             | Reinstalle le paquet.                    |
   |                             |                                          |
   |                             | Remarquez que la marque de               |
   |                             | reinstallation ne sera pas sauvegardee   |
   |                             | quand vous quitterez aptitude ou         |
   | Reinstaller : appuyer sur L | lancerez un processus d'installation     |
   |                             | pour des raisons techniques.             |
   |                             | (Brievement, les couches logicielles     |
   |                             | sous-jacentes (dpkg et apt) ne           |
   |                             | fournissent aucun moyen de savoir si une |
   |                             | reinstallation a reussi ou non).         |
   |-----------------------------+------------------------------------------|
   |                             | Indique si le paquet doit etre traite    |
   |                             | comme ayant ete automatiquement          |
   | Paquet -> Marquer           | installe. Les paquets automatiquement    |
   | automatiquement (M), Paquet | installes sont supprimes quand plus      |
   | -> Marquer manuellement (m) | aucun paquet ne les requiert. Pour plus  |
   |                             | d'informations, consultez la section     |
   |                             | intitulee << Gerer les paquets           |
   |                             | automatiquement installes >>.            |
   |------------------------------------------------------------------------|
   | ^[a] That is, it will be unaffected by Actions -> Marquer comme etant  |
   | susceptible de mise `a jour (U) or the full-upgrade or safe-upgrade    |
   | command-line actions.                                                  |
   +------------------------------------------------------------------------+

   En plus de ces commandes qui affectent le paquet selectionne, il y a deux
   commandes qui affectent un grand nombre de paquets d'un seul coup quelque
   soit ce qui est selectionne. Actions -> Oublier quels paquets sont
   nouveaux (f) enleve l'etat << nouveau >> de tous les paquets de la liste
   de paquets et Actions -> Marquer comme etant susceptible de mise `a jour
   (U) marque tous les paquets qui peuvent l'etre pour mise `a jour, `a
   l'exception des paquets qui sont geles ou qui seraient mis `a jour vers
   une version interdite.

   [Note] Note
          Tout changement de l'etat des paquets est enregistre quand vous
          quittez aptitude, mettez `a jour la liste des paquets ou lancez un
          processus d'installation. Si vous ne voulez pas enregistrer vos
          changements, vous pouvez toujours abandonner aptitude en pressant
          Ctrl-C.

  Telecharger, installer et supprimer des paquets

   Changing package states as described in the previous section does not
   actually affect what is installed on your system. Thus, you can adjust the
   state of packages without affecting your system until you are happy with
   what you see; once you are, you can << commit >> the changes by actually
   installing and removing packages.^[8]

   Pour appliquer vos changements, utilisez la commande Actions ->
   Installer/enlever des paquets (g). Selectionner cette commande va afficher
   un aperc,u decrivant les changements qui seront effectues. Cet ecran n'est
   qu'une liste de paquets et vous pouvez manipuler les paquets (par exemple,
   annuler des suppressions non desirees) de la meme maniere que vous le
   feriez dans la liste principale.

   Quand vous etes pret, utilisez Vues -> Fermer (q) pour annuler
   l'installation ou Actions -> Installer/enlever des paquets (g) pour la
   lancer. aptitude telechargera tous les fichiers necessaires, puis vous
   demandera s'il faut continuer le processus. Si vous validez par
   << Continuer >>, les installations et suppressions vont debuter.

   Les paquets qui sont telecharges par aptitude sont places dans un
   repertoire de cache (habituellement /var/cache/apt/archives). Normalement,
   ils y sont laisses ad infinitum. Pour supprimer tous les fichiers de ce
   repertoire, utilisez Actions -> Nettoyer le cache des paquets, pour ne
   supprimer que les fichiers qui ne peuvent plus etre telecharges
   (c'est-`a-dire les paquets obsoletes), utilisez Actions -> Enlever les
   fichiers perimes.

  Qu'est-ce que la confiance en matiere de gestion des paquets ?

   La possibilite pour apt d'acceder `a de nombreuses sources de paquets
   conduit `a un risque potentiel en matiere de securite. Supposons que vous
   ajoutiez une archive publiee par Jean-Kevin Lepirate `a votre fichier
   sources.list afin d'installer le paquet ubersuper de Jean-Kevin. Il est
   possible que l'archive de Jean-Kevin contienne aussi ses propres versions
   << personnalisees >> de paquets comme libc6 ou ssh... et ces versions vont
   voler vos informations personnelles ou ouvrir des portes derobees sur
   votre systeme ! Si ces paquets ont un numero de version superieur `a ceux
   des paquets Debian legitimes, apt les installera sur votre systeme `a la
   prochaine mise `a jour, sans se soucier de rien, permettant `a Jean-Kevin
   de faire sa sale besogne dans votre dos. Jean-Kevin pourrait aussi
   modifier votre miroir des archives Debian et remplacer les logiciels
   legitimes par ses versions corrompues.

   Heureusement, les nouvelles versions d'apt et d'aptitude, comme celle qui
   est documentee dans ce manuel, integrent des mecanismes de protection pour
   contrer ce genre d'attaque. apt utilise de puissants mecanismes de
   securite bases sur le celebre logiciel de chiffrement GPG pour verifier
   que les paquets qui sont distribues depuis les miroirs officiels Debian
   sont bien les memes que ceux qui ont ete envoyes par les responsables de
   paquets Debian. aptitude vous avertira alors si vous tentez d'installer un
   paquet depuis une source non-Debian, ou si vous tentez de mettre `a jour
   un paquet provenant d'une source Debian vers une version qui ne vient pas
   d'une source Debian.

   [Avertissement] Avertissement
                   Les mecanismes de securite d'apt fournissent une garantie
                   presque totale que le contenu de votre miroir est
                   identique au contenu de l'archive Debian principale.
                   Neanmoins, ce n'est pas une panacee. Par exemple, il
                   existe theoriquement de nombreuses fac,ons de mettre un
                   paquet corrompu dans l'archive Debian principale.

                   S'assurer que vous n'installez des logiciels que depuis
                   des sources fiables vous apportera un degre important de
                   protection contre les paquets malveillants, mais c,a ne
                   peut pas eliminer tous les risques inherents `a
                   l'installation de logiciels.

    Comprendre la confiance

   apt allows the administrator of an archive to provide a signature of the
   archive's index. This signature, which (for all practical purposes) cannot
   be forged, indicates that the package files listed in the index are the
   same files that the administrator intended to place in the archive: ie,
   that the contents of the archive have not been tampered with since it was
   created.^[9] The signature can be validated by checking that it
   corresponds to the administrator's public key. The public key of the
   Debian archive is distributed with apt, typically on your Debian CD.

   Quand aptitude telecharge l'index d'une archive, il verifie si l'index est
   bien signe. S'il ne l'est pas, aptitude ne fera pas confiance aux paquets
   de cette archive (voir plus bas pour savoir ce que cela signifie). S'il a
   une signature mais que celle-ci est incorrecte ou ne peut etre verifiee,
   un avertissement sera affiche et aptitude refusera de faire confiance aux
   paquets de cette archive.

   Plus tard, quand vous lancerez un processus d'installation, aptitude
   verifiera si les paquets viennent de sources fiables. Si un paquet douteux
   est sur le point d'etre installe, ou si un paquet est mis `a jour d'une
   version fiable vers une version non fiable, un avertissement est affiche
   et vous avez la possibilite d'interrompre le telechargement :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.3.0                    Will use 831kB of disk space   DL Size: 30.4MB
 --\ Packages to be upgraded
 iu U wesnoth                                       -98.3kB 0.8.7-1    0.8.8-1.0w
 iuAU wesnoth-data                                  +930kB  0.8.7-1    0.8.8-1.0w
 +------------------------------------------------------------------------------+
 |WARNING: untrusted versions of the following packages will be installed!     #|
 |                                                                             #|
 |Untrusted packages could compromise your system's security.  You should only #|
 |proceed with the installation if you are certain that this is what you want  #|
 |to do.                                                                       #|
 |                                                                             #|
 |  * wesnoth [version 0.8.8-1.0wesnoth.org]                                   #|
 |  * wesnoth-data [version 0.8.8-1.0wesnoth.org]                              #|
 |  * wesnoth-music [version 0.8.8-1.0wesnoth.org]                             #|
 |         [ Really Continue ]                  [ Abort Installation ]          |
 +------------------------------------------------------------------------------+
                                                                                #
                                                                                #
                                                                                #
                                                                                #
                                                                                #
                                                                                #

    Faire confiance `a d'autres cles

   Il peut etre pratique de faire en sorte qu'apt fasse confiance `a d'autres
   archives, en plus de l'archive Debian principale. Pour chaque archive `a
   laquelle vous voulez faire confiance, vous devez recuperer la cle publique
   utilisee pour signer l'index des paquets de cette archive. C'est
   habituellement un fichier texte dont le nom fini par .asc. Il doit etre
   fourni par l'administrateur du serveur ou telechargeable depuis un serveur
   de cles publiques. Pour plus d'information sur ce que sont les cles
   publiques et comment les recuperer, consultez la page web de GPG.

   La liste des cles auxquelles apt fait confiance est stockee dans le
   fichier porte-cles /etc/apt/trusted.gpg. Une fois que vous avez la cle
   GPG, vous pouvez l'ajouter `a ce fichier en executant la commande gpg
   --no-default-keyring --keyring /etc/apt/trusted.gpg --import
   nouvelleclef.asc. aptitude fera alors confiance `a toutes les archives
   signees avec la cle contenue dans nouvelleclef.asc.

   [Avertissement] Avertissement
                   Une fois que la cle d'une archive a ete ajoutee au
                   porte-cles d'apt, il lui sera accorde autant de confiance
                   qu'aux miroirs Debian eux-memes ! Vous ne devriez faire
                   cela que si vous etes absolument sur que la cle que vous
                   ajoutez est la bonne et que la personne qui detient cette
                   cle est `a la fois fiable et competente.

  Gerer les paquets automatiquement installes

   >Pour installer un paquet, il est souvent necessaire d'en installer
   plusieurs autres (pour satisfaire ses dependances). Par exemple, si vous
   voulez installer le paquet clanbomber, vous devez aussi installer le
   paquet libclanlib2. Lorsque vous supprimez clanbomber, vous n'avez
   probablement plus besoin du paquet libclanlib2. aptitude tentera de le
   detecter et de supprimer automatiquement le paquet libclanlib2.

   It works like this: when you install a package, aptitude will
   automatically install any other packages on which it depends. These
   packages are marked as having been << automatically installed >>; aptitude
   will monitor them and remove them when they are no longer depended upon by
   any manually installed package ^[10] . They will appear in the preview as
   << packages being removed because they are no longer used. >>

   Comme pour tout procede automatique, les choses peuvent potentiellement
   mal tourner. Par exemple, meme si un paquet a ete installe automatiquement
   pour commencer, il peut s'averer utile par lui-meme. Vous pouvez retirer
   la marque << automatique >> `a tout moment en appuyant sur m et, si le
   paquet est dej`a marque `a supprimer, vous pouvez annuler la suppression
   et retirer la marque << automatique >> avec Paquet -> Installer (+).

Resolving package dependencies

  Dependency resolution in aptitude

   There are two main dependency resolution algorithms in aptitude.

   The first is an algorithm that is also used by programs such as apt-get
   and synaptic; I will call it << immediate resolution >>. It is invoked
   whenever you select a package for installation interactively, and
   immediately after one or more packages are marked for installation at the
   command-line. Immediate resolution is fast and will solve most dependency
   problems, but it is sometimes unable to find any solution.

   The second algorithm, which I will call << interactive resolution >>, is
   invoked when packages have broken dependencies even after immediate
   resolution^[11]. It can resolve more dependencies, it allows you to review
   a solution before applying it, and it allows you to provide feedback to
   the resolver, guiding it towards a better solution.

  Immediate dependency resolution

   Whenever you choose to install or upgrade a package in aptitude, aptitude
   makes an immediate attempt to resolve any of its dependencies that are not
   fulfilled. For each unsatisfied dependency (either a << Depends >>, a
   << Recommends >>, or a << Conflicts >>), it performs the following steps:

    1. If the dependency is a recommendation, aptitude tries to guess whether
       it is a << new >> recommendation or a << previously satisfied >>
       recommendation. aptitude considers a recommendation to be << new >> if
       the package declaring the recommendation is not currently installed,
       or if its installed version does not recommend a package of the same
       name. On the other hand, a recommendation is << previously
       satisfied >> if the package declaring the recommendation is installed,
       the currently installed version recommends a package of the same name,
       and that recommendation is currently fulfilled.

       For example: suppose that version 1.0 of prog recommends version 4.0
       of libcool1, but version 2.0 of prog recommends version 5.0 of
       libcool1, and also recommends apache. If you choose to upgrade prog
       from version 1.0 to version 2.0, the recommendation of apache will be
       considered to be << new >> because version 1.0 of prog did not
       recommend apache. On the other hand, the recommendation of libcool1 is
       not << new >>, because version 1.0 of prog recommended libcool1, even
       though it recommended a different version. However, if libcool1 is
       installed, then that recommendation will be considered to be
       << previously satisfied >>.

       If the configuration option Apt::Install-Recommends is true, aptitude
       will always attempt to fulfill << new >> and << previously
       satisfied >> recommendations; all others will be ignored by immediate
       resolution. If that option is false, immediate dependency resolution
       will ignore all recommendations.

    2. If the dependency is on several packages combined with OR, examine
       each of the alternatives in the order that they are given. For
       instance, if a package depends on << exim | mail-transport-agent >>,
       aptitude will first process exim, then mail-transport-agent.

    3. For each alternative, attempt to resolve it. If the dependency is a
       conflict, remove the current alternative if it is installed (and for
       an unversioned conflict, also remove any package providing the target
       of the conflict). Otherwise, install the candidate version of the
       current alternative if it satisfies the dependency. If not, or if
       there is no candidate version (for instance, because the current
       alternative is a virtual package), and if the dependency is
       unversioned, attempt to install the highest-priority package^[12]
       whose candidate version provides the target of the current
       alternative.

       For instance, say we are attempting to resolve << Depends: exim |
       mail-transport-agent >>. aptitude will first attempt to install the
       package exim. If exim is not available, aptitude will then attempt to
       install the highest-priority package whose candidate version provides
       exim. If there is no such package, aptitude will install the
       highest-priority package whose candidate version provides the virtual
       package mail-transport-agent. On the other hand, suppose that the
       dependency is << Depends: exim (>= 2.0.0) | mail-transport-agent >>,
       but only version 1.0 of exim is available. In this case, aptitude will
       not install exim (because the version does not match), nor will it
       attempt to install packages providing exim (because virtual packages
       cannot match a dependency with a version restriction). Thus, aptitude
       will fall back to installing the highest-priority package whose
       candidate version provides mail-transport-agent.

    4. If a package was installed by the previous step, resolve its
       dependencies using this algorithm, then stop.

   While this technique very often solves all the outstanding package
   dependencies, it can fail in a number of common circumstances.

     o Conflicts are resolved by removing the package that is the target of
       the conflict. But now other packages that depend on this package have
       unresolved dependencies; the immediate resolver makes no attempt to
       fix them.

     o A dependency might not be satisfiable due to version restrictions and
       due to the limitation that only candidate versions are considered. For
       instance, say that versions 1.0 and 2.0 of fileutils are available,
       that the candidate version is 1.0, and that the package octopus
       declares a dependency << Depends: fileutils (>= 2.0) >>. Immediate
       resolution is unable to resolve this dependency: it will never
       consider version 2.0 of the package, since that is not the candidate
       version.

   The interactive dependency resolver can solve these situations and more.
   When there are broken dependencies left over, or when immediate dependency
   resolution is disabled, the interactive resolver will automatically start
   searching for a solution. The next section describes how to use the
   interactive dependency resolver.

  Resolving Dependencies Interactively

   If a dependency problem arises that cannot be handled using the immediate
   dependency resolver, aptitude can assist you in resolving it. As soon as a
   problem occurs, a red bar will appear at the bottom of the screen with a
   summary of aptitude's suggestion about how to fix it. For instance, in the
   following screenshot, aptitude is indicating that it can resolve the
   situation by keeping two packages at their current versions.

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.3.3       #Broken: 1   Will free 48.6MB of disk space
 i A   nautilus                                             2.10.1-4   2.10.1-4
 i     nautilus-cd-burner                                   2.10.2-1.1 2.10.2-1.1
 i A   nautilus-data                                        2.10.1-4   2.10.1-4
 i     netspeed                                             0.12.1-1   0.12.1-1
 i A   oaf                                                  0.6.10-3   0.6.10-3
 i     pybliographer                                        1.2.6.2-1  1.2.6.2-1
 i     rhythmbox                                            0.8.8-13   0.8.8-13
 i     shermans-aquarium                                    3.0.1-1    3.0.1-1
 idA   sound-juicer                                 -1733kB 2.10.1-3   2.10.1-3
 GNOME 2 CD Ripper
 sound-juicer will be removed.


 The following packages depend on sound-juicer and will be broken by its
 removal:


   * gnome-desktop-environment depends on sound-juicer

 [1(1)/...] Suggest 2 keeps
 e: Examine  !: Apply  .: Next  ,: Previous

   Comme il est indique en bas de l'ecran, vous pouvez voir d'autres
   solutions en appuyant sur . et ,, appliquer la solution courante en
   appuyant sur ! et examiner la solution plus en detail en appuyant sur e.
   Quand vous examinez la solution courante, un ecran semblable au suivant
   apparait.

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                 Packages                          Resolve Dependencies
   --\ Keep the following packages at their current version:
     gstreamer0.8-cdparanoia                           [0.8.10-1 (unstable, now)]
     sound-juicer                                                [2.10.1-2 (now)]
















 [1(1)/...] Suggest 2 keeps
 e: Examine  !: Apply  .: Next  ,: Previous

   Vous pouvez acceder aux informations sur le paquet affecte par une action
   en appuyant simplement sur entree lorsque le paquet est selectionne. Pour
   obtenir une explication detaillee sur les raisons d'un choix particulier,
   il suffit de selectionner l'element dans la liste. Dans la moitie basse de
   l'ecran, s'afficheront la dependance qui a ete resolue par aptitude et
   tous les moyens par lesquels la dependance aurait pu etre resolue.

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                 Packages                          Resolve Dependencies
   --\ Keep the following packages at their current version:
     gstreamer0.8-cdparanoia                           [0.8.11-1 (unstable, now)]
     sound-juicer                                      [2.10.1-3 (unstable, now)]






 cdparanoia plugin for GStreamer
 sound-juicer depends upon gstreamer0.8-cdparanoia
 --\ The following actions will resolve this dependency:
   -> Downgrade sound-juicer [2.10.1-3 (unstable, now) -> 0.6.1-2 (testing)]
   -> Remove sound-juicer [2.10.1-3 (unstable, now)]
   -> Cancel the removal of gstreamer0.8-cdparanoia
   -> Downgrade gstreamer0.8-cdparanoia [0.8.11-1 (unstable, now) -> 0.8.8-3 (tes



 [1(1)/...] Suggest 2 keeps
 e: Examine  !: Apply  .: Next  ,: Previous

   You can guide the dependency resolver to a solution of which you approve
   by approving or rejecting the individual actions of a solution. If you
   approve an action, the resolver will choose it whenever possible, ignoring
   alternatives (when there are several approved alternatives, any one of
   them could be chosen). On the other hand, if you reject an action, the
   resolver will never choose that action.

   To reject an action, highlight it and press r; the rejection can be
   cancelled by pressing r again. Similarly, select an action and press a to
   approve it; press a again to restore its original state. You can undo
   either action by using Annuler -> Annuler (Controle+u) while the resolver
   screen is active. If you cancel a rejection or an approval, any solutions
   that were ignored will be available the next time that you generate a new
   solution.

   [Note] Note
          By default, the resolver rejects actions that change the state of
          held packages, or that install forbidden versions of packages. You
          can override these rejections, thus allowing the hold or forbidding
          to be automatically overridden, in the same way that you would
          override any other rejection. Setting the configuration option
          Aptitude::ProblemResolver::Allow-Break-Holds to true will disable
          this behavior, meaning that the resolver will always break holds
          (albeit at a penalty, see
          Aptitude::ProblemResolver::BreakHoldScore).

   Les actions rejetees sont mises en rouge et marquees avec un << R >>, et
   celles approuvees sont mises en vert et marquees avec un << A >>. Comme
   vous pouvez le voir dans la capture suivante ou l'action de << conserver
   gstreamer0.8-cdparanoia dans sa version actuelle >> a ete rejetee et
   l'action de << conserver sound-juicer dans sa version actuelle >>
   approuvee.

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                 Packages                          Resolve Dependencies
   --\ Keep the following packages at their current version:
 R   gstreamer0.8-cdparanoia                           [0.8.11-1 (unstable, now)]
 A   sound-juicer                                      [2.10.1-3 (unstable, now)]
















 [1(1)/...] Suggest 2 keeps
 e: Examine  !: Apply  .: Next  ,: Previous

   Rejections and approvals only affect newly generated solutions. You can
   tell when a new solution will be generated by examining the indicator in
   the lower left hand corner of the screen: if there is a number in
   parentheses, it is the number of solutions that have been generated. Thus,
   when the number outside the parentheses and the number inside are
   identical (as above), pressing . will generate a new solution. If there is
   no number in parentheses (for instance, the indicator reads [1/5]), then
   there are no more solutions to generate. At any time, you can select the
   last generated solution by pressing >, and the first generated solution by
   pressing <.

   [Important] Important
               L'etat du systeme de resolution des problemes est mis `a zero
               quand vous modifiez l'etat d'un paquet. Si vous marquez un
               paquet pour installation, pour mise `a jour, pour suppression,
               etc., aptitude oubliera tous vos rejets et approbations, ainsi
               que toutes les solutions generees jusque l`a.

   En plus de la selection des actions dans la liste en haut de l'ecran, vous
   pouvez selectionner ces actions dans la liste du bas. Pour avoir acces `a
   cette seconde liste, vous pouvez soit cliquer dessus avec votre souris,
   soit appuyer sur Tab. Enfin, en appuyant sur o, vous afficherez les
   decisions triees. Cela consiste en une liste des dependances qui ont ete
   resolues et des actions qui ont amene ce resultat, comme le montre la
   capture suivante .

  Actions  Undo  Package  Resolver  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
                 Packages                          Resolve Dependencies
   --\ gnome-desktop-environment depends upon sound-juicer
     -> Cancel the removal of sound-juicer
   --\ sound-juicer depends upon gstreamer0.8-cdparanoia
     -> Cancel the removal of gstreamer0.8-cdparanoia





 GNOME 2 CD Ripper
 gnome-desktop-environment depends upon sound-juicer
 --\ The following actions will resolve this dependency:
   -> Remove gnome-desktop-environment [1:2.10.2.3 (unstable, testing, now)]
   -> Cancel the removal of sound-juicer
   -> Downgrade sound-juicer [2.10.1-3 (unstable, now) -> 0.6.1-2 (testing)]




 [1(1)/...] Suggest 2 keeps
 e: Examine  !: Apply  .: Next  ,: Previous

   Appuyer `a nouveau sur o quitte ce mode d'affichage.

  Costs in the interactive dependency resolver

    Costs and cost components

   The cost of a solution produced by the interactive dependency resolver is
   a value that aptitude uses to determine how << bad >> that solution is.
   Solutions that are << better >> are always displayed before solutions that
   are << worse >>. The cost of solutions is defined in the configuration
   option Aptitude::ProblemResolver::SolutionCost.

   Some typical costs are shown in Exemple 2.1, << Sample resolver costs >>.

   Exemple 2.1. Sample resolver costs

   The default cost, sorting solutions by their safety cost, then by their
   apt pin priority:

 safety, priority

   Remove as few packages as possible, then cancel as few actions as
   possible:

 removals, canceled-actions

   Sort solutions by the number of packages they remove plus twice the number
   of actions they cancel.

 removals + 2 * canceled-actions

   As can be seen from the above examples, a cost is not necessarily a single
   number. In fact, a cost consists of one or more cost components, each of
   which is a number associated with the solution. When sorting solutions,
   the resolver examines cost components in order, proceeding to later
   components only if the earlier ones are equal. For instance, in the cost
   << removals, canceled-actions >>, solutions with fewer removals always
   appear before solutions with more removals, regardless of how many
   canceled actions they have. However, solutions with the same number of
   removals are sorted so that solutions with fewer canceled actions appear
   first.

   Cost components come in two flavors: basic cost components and compound
   cost components.

   Basic components simply name some property of the solution, such as
   << upgrades >> or << removals >>. A list of built-in basic components
   provided by aptitude can be found in Tableau 2.1, << Basic cost
   components >>. You can also create your own cost components using the
   add-to-cost-component and raise-cost-component hints; see la section
   intitulee << Configuring resolver hints >> for details.

   Each basic component is either a counter or a level. Counters count how
   many of a solution's actions meet some condition (such as removing
   packages or installing new packages), while levels associate a number with
   each action and compute the highest number associated with any action in
   the solution.

   Tableau 2.1. Basic cost components

+----------------------------------------------------------------------------------+
|        Nom         | Type  |                     Description                     |
|--------------------+-------+-----------------------------------------------------|
|                    |       |Counts the number of holds that the solution breaks, |
|broken-holds        |Counter|if the resolver is allowed to break holds            |
|                    |       |(Aptitude::ProblemResolver::Allow-Break-Holds).      |
|--------------------+-------+-----------------------------------------------------|
|                    |       |Counts the number of pending actions that the        |
|canceled-actions    |Counter|solution cancels (keeping packages at their current  |
|                    |       |version).                                            |
|--------------------+-------+-----------------------------------------------------|
|installs            |Counter|Counts the number of packages that the solution      |
|                    |       |installs.                                            |
|--------------------+-------+-----------------------------------------------------|
|non-default-versions|Counter|Counts the number of versions that the solution      |
|                    |       |installs or upgrades from non-default sources.       |
|--------------------+-------+-----------------------------------------------------|
|                    |       |A value that increases as the apt pin priority of a  |
|priority            |Level  |version decreases. Specifically, this is computed by |
|                    |       |negating the pin priority (so, e.g., if the pin      |
|                    |       |priority is 500, this component will compute -500).  |
|--------------------+-------+-----------------------------------------------------|
|removals            |Counter|Counts the number of packages that the solution      |
|                    |       |removes.                                             |
|--------------------+-------+-----------------------------------------------------|
|removals-of-manual  |Counter|Counts the number of manually installed packages that|
|                    |       |the solution removes.                                |
|--------------------+-------+-----------------------------------------------------|
|                    |       |A broad heuristic that increases as actions become   |
|safety              |Level  |less << safe >>; see la section intitulee << Safety  |
|                    |       |costs >> for details.                                |
|--------------------+-------+-----------------------------------------------------|
|upgrades            |Counter|Counts the number of packages that the solution      |
|                    |       |upgrades.                                            |
+----------------------------------------------------------------------------------+

   Compound components are built by combining the values of basic components.
   For instance, removals + canceled-actions adds the components removal and
   canceled-actions, resulting in a component that counts the number of
   removals and canceled actions. Compound components combine counters by
   adding them together and levels by taking their maximum value, as shown in
   Figure 2.11, << Syntax of compound cost components >>.

   [Note] Note
          It is an error to add two levels, or to take the maximum of two
          counters, or to combine levels and counters in any way. For
          instance, the costs removals + safety and max(upgrades, installs)
          will be treated as errors and ignored by the resolver.^[13]

   Figure 2.11. Syntax of compound cost components

   Add two or more basic costs:

                 [scale1]*cost1 + [scale2]*cost2 + ...


   Take the maximum value of two or more basic costs:

                 max([scale1]*cost1, [scale2]*cost2, ...)


   Note that each individual basic component can be multiplied by a scaling
   factor before it is combined with other components. This can be used to
   control the trade-offs that the resolver makes between costs. For
   instance, a cost of 2*removals + 3*upgrades says that two removals are
   exactly as << bad >> as three upgrades. Solutions that contain four
   removals and one upgrade will be considered equivalent to solutions
   containing one removal and three upgrades, since both have a cost of
   eleven.

    Safety costs

   Figure 2.12. Safety cost levels

   Safety cost levels

   The safety cost component is a heuristic estimate of how << safe >> or
   << unsafe >> a solution is. Safety costs can be thought of as a way of
   dividing solutions into several numbered << levels >>, where << less
   safe >> levels are given higher numbers. Figure 2.12, << Safety cost
   levels >> shows how this works with aptitude's default settings.

   [Astuce] Astuce
            Safety cost levels are just one way to control the order in which
            dependency solutions are returned. See la section intitulee
            << Costs in the interactive dependency resolver >> for a full
            description of how to change the order in which aptitude sorts
            solutions.

   By default, aptitude initializes the resolver with a << reasonable >> set
   of safety cost levels. They are:

   Tableau 2.2. Default safety cost levels

+----------------------------------------------------------------------------------+
| Cost |       Description       |              Configuration option               |
|level |                         |                                                 |
|------+-------------------------+-------------------------------------------------|
|      |Solutions that include   |                                                 |
|      |only << safe >> actions  |                                                 |
|      |(installing the default  |Aptitude::ProblemResolver::Safe-Level,           |
|10,000|target for a package or  |Aptitude::ProblemResolver::Remove-Level          |
|      |keeping a package at its |                                                 |
|      |current version) and     |                                                 |
|      |package removals.        |                                                 |
|------+-------------------------+-------------------------------------------------|
|20,000|The solution that cancels|Aptitude::ProblemResolver::Keep-All-Level        |
|      |all the user's actions.  |                                                 |
|------+-------------------------+-------------------------------------------------|
|      |Solutions that break     |                                                 |
|40,000|holds set by the user or |Aptitude::ProblemResolver::Break-Hold-Level      |
|      |install forbidden        |                                                 |
|      |versions.                |                                                 |
|------+-------------------------+-------------------------------------------------|
|      |Solutions that install   |                                                 |
|      |packages from non-default|                                                 |
|50,000|versions (such as        |Aptitude::ProblemResolver::Non-Default-Level     |
|      |<< experimental >>, for  |                                                 |
|      |instance).               |                                                 |
|------+-------------------------+-------------------------------------------------|
|60,000|Solutions that remove    |Aptitude::ProblemResolver::Remove-Essential-Level|
|      |Essential packages.      |                                                 |
+----------------------------------------------------------------------------------+

   If a solution qualifies for several safety cost levels, it will be placed
   in the highest one, that is, the one that appears last. For example, a
   solution that upgrades one package to its default version and breaks a
   hold on a second package will be placed at level 40,000. You can adjust
   the levels of individual versions using resolver hints; see la section
   intitulee << Configuring resolver hints >> for details. The default levels
   are illustrated in Figure 2.12, << Safety cost levels >>.

  Configuring the interactive dependency resolver

    Configuring resolver hints

   To improve the quality of the dependency solutions that you receive, you
   can provide hints to the interactive dependency resolver. These hints can
   alter the priorities of the resolver, biasing it more strongly in favor of
   one version or package, or they can be used to << pre-load >> the resolver
   with rejections and approvals, as if you had entered the resolver and
   manually rejected or approved various versions.

   Hints are stored in the apt configuration file, /etc/apt/apt.conf, in the
   configuration group << Aptitude::ProblemResolver::Hints >> (see la section
   intitulee << Reference du fichier de configuration >> for details on the
   configuration file).

   Each resolver hint consists of an action, a target, and an optional
   version. A hint is written like this: "action target [version]". To apply
   a resolver hint, aptitude locates one or more packages using the value of
   target, chooses one or more versions of those packages using the value of
   version, and finally performs the given action.

   The action field of a resolver hint may be one of the following:

    1. << approve >>: Approve the version, as if the command Solutions ->
       Marquer comme retenu (a) had been invoked on it.

    2. << reject >>: Reject the version, as if the command Solutions ->
       Marquer comme rejete (r) had been invoked on it.

    3. << discard >>: Discard every solution containing the version. Differs
       from << reject >> in that it is not visible to the user and cannot be
       modified interactively.

    4. << increase-safety-cost-to number >>: increase the safety cost of any
       solution that contains the version to number; if its safety cost is
       already higher than number, this hint has no effect. The safety cost
       can be used (and is used by default) to control the order in which
       solutions appear; see la section intitulee << Costs and cost
       components >> and la section intitulee << Safety costs >> for details.

       Several special cost levels can be chosen by name:

         a. conflict, discard: instead of changing the safety cost, discard
            solutions containing the version as if the << discard >> hint had
            been applied.

         b. maximum: the highest safety cost.

         c. minimum: the lowest safety cost. All searches start at this cost,
            so << increasing >> a version to this cost has no effect.
            However, this value can also be used when adjusting the
            predefined cost levels: for instance, setting
            Aptitude::ProblemResolver::Remove-Level to << minimum >> will
            cause removed packages to have no effect on the safety cost of a
            solution.

       [Note] Note
              The increase-safety-cost-to hint is applied in addition to any
              default safety cost that is due to the selected action. For
              instance, a hint that increases the safety cost of << install
              hal from experimental >> to 15,000 will have no effect, because
              that action already has a safety cost of 50,000 (assuming that
              this version of hal is not the default candidate version).

    5. << number >>: add the given number to the version's score, biasing the
       resolver in favor of it or (with a negative number) away from it. For
       instance, the hint 200 emacs adds 200 to the score of emacs, whereas
       the hint -10 emacs subtracts 10 from its score.

   If target field of a resolver hint contains a question mark (<< ? >>) or
   tilde (<< ~ >>), it is considered to be a search pattern and all matching
   package versions are considered. Otherwise, it is considered to be the
   name of a package to select. So the target << g++ >> will select only the
   g++ package, but the target << ?section(non-free) >> will select any
   package in the non-free section. See la section intitulee << Search
   patterns >> for more information on search patterns.

   If the version field is not present, then all versions of the package are
   affected by the hint. Otherwise, it may have any of the following forms:

    1. << /archive >>: the hint only affects versions that are available in
       the given archive.

    2. << <version >>: the hint only affects versions whose version number is
       less than version.

    3. << <=version >>: the hint only affects versions whose version number
       is less than or equal to version.

    4. << =version >>: the hint only affects versions whose version number is
       version.

    5. << <>version >>: the hint only affects versions whose version number
       is not version.

    6. << >=version >>: the hint only affects versions whose version number
       is greater than or equal to version.

    7. << >version >>: the hint only affects versions whose version number is
       greater than version.

    8. << :UNINST >>: instead of affecting any of the versions of target, the
       hint affects the decision to remove target. For instance, << reject
       aptitude :UNINST >> will prevent the resolver from attempting to
       remove aptitude.

    9. << version >>: the hint only affects versions whose version number is
       version.

Search patterns

   When you search for a package or set a display limit in aptitude, the
   string you enter is known as a << search pattern >>. While the most basic
   usage of search patterns is to match packages by name, aptitude allows you
   to create much more complex searches. In addition to the visual interface,
   some command-line operations can use search patterns; see Command-line
   reference for details.

   A search pattern consists of one or more conditions (sometimes known as
   << terms >>); packages match the pattern if they match all of its terms.
   Terms generally start with a question mark (<< ? >>), followed by the name
   of the match term, which describes the search that the term performs: for
   instance, the term ?name matches package names, while the term ?version
   matches package versions. Finally, any additional parameters to the search
   term are placed in parentheses (see the documentation of individual terms
   for details of what each term's parameters mean).

   [Note] Note
          Text with no leading << ? >> also forms a search pattern: aptitude
          will treat each word (or quoted string) as the argument to a ?name
          pattern, which searches for a package whose name matches the text
          when the text is interpreted as a regular expression.

   [Avertissement] Avertissement
                   The behavior of aptitude when given a search pattern
                   without a leading << ? >> (or << ~ >>) is provided as a
                   convenience for interactive use and will change in future
                   releases; scripts that invoke aptitude should explicitly
                   name the search strategy they want to use. That is,
                   scripts should search for << ?name(coq) >> rather than
                   << coq >>).

  Searching for strings

   Many search terms take a string as a parameter and match it against one or
   more fields of a package. Strings can be entered either with or without
   double quotes (<< " >>), so << ?name(scorch) >> and << ?name("scorch") >>
   will perform the same search. If you enter a search string using double
   quotes, you can include a literal double-quote in the search string by
   placing a backslash (<< \ >>) immediately before it: for instance,
   << ?description("\"easy\"") >> will match any package whose description
   contains the string << "easy" >>.

   If you enter a << bare >> string, one not surrounded by double quotes,
   then aptitude will consider the string to have << ended >> when it
   encounters the closing parenthesis or the comma before a second argument
   to the search term. ^[14] To remove the special meaning of these
   characters, place a tilde (<< ~ >>) directly before them. For instance,
   << ?description(etc)) >> is a syntax error, because the first << ) >> ends
   the ?description term, and the second << ) >> does not correspond to any
   << ( >>. In contrast, << ?description(etc~)) >> matches any package whose
   description contains the text << etc) >>. There are additional
   considerations if you are using the shorthand notation for a term; see la
   section intitulee << Shorthand for search terms >> for details.

   Most textual searches (for package names, descriptions, etc) are performed
   using case-insensitive regular expressions. A regular expression will
   match against a field if any portion of the field matches the expression;
   for instance, << ogg[0-9] >> will match << libogg5 >>, << ogg123 >>, and
   << theogg4u >>. Some characters have a special meaning within regular
   expressions ^[15] , so if you want to match them in searches you need to
   backslash-escape them: for instance, to find << g++ >>, you should use the
   pattern << g\+\+ >>.

   The characters << ! >> and << | >> have special meanings within search
   patterns. In order to include these characters in an unquoted string, you
   can place a tilde (<< ~ >>) directly before them. For instance, to match
   packages whose description contains either << grand >> or << oblique >>,
   use the pattern << ?description(grand~|oblique) >>. However, you will
   probably find it more convenient to simply use a quoted string in these
   cases: << ?description("grand|oblique") >>.

  Shorthand for search terms

   Some search terms can be written using << short >> forms, which consist of
   a tilde (<< ~ >>) followed by a single character that identifies the term,
   and finally the arguments (if any) to the term. For instance, the short
   form of ?name(aptitude) is ~n aptitude.

   When writing a term using its short form, tilde characters and
   << whitespace >> -- that is, space characters, tabs, and so on -- will
   break the term off and start a new term. For instance, << ~mDaniel
   Burrows >> will match any package whose maintainer field contains
   << Daniel >> and whose name contains << Burrows >>, while << ~i~napt >>
   matches installed packages whose name contains apt. To include whitespace
   characters in the search expression, you can either place a tilde in front
   of it (as in Daniel~ Burrows) or place quotation marks around it (as in
   "Debian Project" or even Debian" "Project). Inside a quoted string, the
   backslash character (<< \ >>) can be used to cancel the special meaning of
   the quotation mark: for instance, ~d"\"email" will match any package whose
   description contains a quotation mark followed immediately by email. ^[16]

   [Note] Note
          Question marks (<< ? >>) will not end the short form of a term,
          even if they are followed by the name of a search term. For
          instance, << ~napt?priority(required) >> will match all packages
          whose name matches the regular expression
          << apt?priority(required) >>. To combine a short query term with a
          search term specified by name, add one or more spaces between the
          two terms, as in << ~napt ?priority(required) >>, or place
          quotation marks around the text (if any) following the short form
          of a term, as in << ~n"apt"?priority(required) >>.

   Tableau 2.3, << Quick guide to search terms >> lists the short form of
   each search term.

  Searches and versions

   By default, a pattern matches a package if any version of the package
   matches the pattern. However, some patterns will restrict their
   sub-patterns to only match against some versions of a package. For
   instance, the search term ?depends(pattern) will select any package that
   depends on a package matching pattern. However, pattern will only be
   checked against the versions of the package that actually satisfy a
   dependency. This means that if foo depends on bar (>= 3.0) and versions
   2.0, 3.0, and 4.0 of bar are available, then in the search pattern
   ?depends(?version(2\.0)), only versions 3.0 and 4.0 will be tested against
   ?version(2\.0), and hence foo will not be found by this search.

   It matters which versions are checked because, as in the example above,
   some patterns will match one version but not another. For instance, the
   pattern ?installed will only match the version of the package (if any)
   that is currently installed. Similarly, the pattern
   ?maintainer(maintainer) will only match versions that have the given
   maintainer. Normally all versions of a package have the same maintainer,
   but this is not always the case; in fact, any search pattern that examines
   the fields of a package (other than its name, of course) will behave this
   way, because all the fields of a package can change between versions.

   To test a pattern against all the versions of a package, even if the
   pattern would normally be tested against only some of the versions, use
   the ?widen term. For instance, ?depends(?widen(?version(2\.0))) will match
   any package A that depends on a package B, where B has a version matching
   2.0, regardless of whether that version actually satisfies A's dependency.
   On the other hand, the ?narrow term restricts the versions that its
   sub-pattern is matched against: ?narrow(?installed,
   ?depends(?version(ubuntu))) will match any package whose installed version
   has a dependency that can be satisfied by a package whose version string
   contains << ubuntu >>.

   [Note] Note
          There is a subtle, but important, distinction between matching a
          pattern against a package, and matching it against all the versions
          of that package. When a pattern is matched against a package, each
          of its terms is matched against the package, and so each term will
          match if any version of the package matches. In contrast, when a
          pattern is matched against each version of a package, it will
          successfully match if it matches when all its terms are matched
          against the same version of the package.

          For example: suppose that version 3.0-1 of the package aardvark is
          installed, but that version 4.0-1 is available. Then the search
          expression ?version(4\.0-1)?installed matches aardvark, because
          ?version(4\.0-1) matches against version 4.0-1 of aardvark, while
          ?installed matches against version 3.0-1. On the other hand, this
          expression does not match against all the versions of aardvark,
          because no single version is installed and also has a version
          number of 4.0-1.

  Explicit search targets

   Some particularly complex searches can be expressed in aptitude using
   explicit targets. In normal search expressions, there is no way to refer
   to the package or version that is currently being tested. For instance,
   suppose that you want to search for all packages P that depend on a second
   package Q such that Q recommends P. Clearly you need to start out with a
   ?depends(...) term. But the term filling in the ... needs to somehow
   select packages that are identical to the one being matched against
   ?depends. When describing the goal above, I dealt with this by giving the
   packages names, calling them P and Q; terms with explicit targets do
   exactly the same thing. ^[17]

   An explicit target is introduced by the ?for term:

   Figure 2.13. Syntax of the ?for term

 ?for variable: pattern

   This behaves exactly like pattern, but variable can be used within pattern
   to refer to the package or version that pattern is being matched against.
   You can use variable in two ways:

    1. The term ?= will match exactly the package or version indicated by the
       given variable. Specifically: if the corresponding ?for term is
       limited to a particular version, then ?= will match either that
       version (if ?= is limited) or the whole package; otherwise it will
       match any version of the package.

       See Exemple 2.2, <<  Use of the ?= term.  >> for an example of how to
       use ?=.

    2. The term ?bind(variable, pattern) will match any package or version if
       the value of variable matches against pattern.

       For ?-style terms, a shorthand form is available. The expression
       ?bind(variable, ?term[(args)]) can be replaced by
       ?variable:term(args).

       See Exemple 2.3, << Use of the ?bind term >> for an example of how to
       use ?bind.

  Search term reference

   Tableau 2.3, << Quick guide to search terms >> provides a brief summary of
   all the search terms provided by aptitude. A full description of each term
   can be found below.

   Tableau 2.3. Quick guide to search terms

+-----------------------------------------------------------------------------------+
|           Long form            |         Short form         |     Description     |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select the package   |
|                                |                            |bound to variable;   |
|?=variable                      |                            |see la section       |
|                                |                            |intitulee << Explicit|
|                                |                            |search targets >>.   |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select any package   |
|?not(pattern)                   |!pattern                    |that does not match  |
|                                |                            |pattern.             |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|                                |                            |have been marked for |
|?action(action)                 |~aaction                    |the given action     |
|                                |                            |(e.g., << install >> |
|                                |                            |or << upgrade >>).   |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages whose|
|?all-versions(pattern)          |                            |versions all match   |
|                                |                            |pattern.             |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select any package   |
|?and(pattern1, pattern2)        |pattern1 pattern2           |that matches both    |
|                                |                            |pattern1 and         |
|                                |                            |pattern2.            |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages for  |
|?any-version(pattern)           |                            |which at least one   |
|                                |                            |version matches      |
|                                |                            |pattern.             |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages from |
|?archive(archive)               |~Aarchive                   |the given archive    |
|                                |                            |(such as             |
|                                |                            |<< unstable >>).     |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|?automatic                      |~M                          |were automatically   |
|                                |                            |installed.           |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Selects anything if  |
|                                |                            |variable matches     |
|?bind(variable, pattern)        |?variable:term-name[(args)] |pattern; see la      |
|                                |                            |section intitulee    |
|                                |                            |<< Explicit search   |
|                                |                            |targets >>.          |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|?broken                         |~b                          |have a broken        |
|                                |                            |dependency.          |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select package that  |
|?broken-depType                 |~BdepType                   |have a broken        |
|                                |                            |dependency of the    |
|                                |                            |given depType.       |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|                                |                            |have a broken        |
|?broken-depType(pattern)        |~DB[depType:]pattern        |dependency of the    |
|                                |                            |given depType        |
|                                |                            |matching pattern.    |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|                                |                            |a package matching   |
|?broken-reverse-depType(pattern)|~RBdepType:pattern          |pattern declares a   |
|                                |                            |broken dependency of |
|                                |                            |type depType.        |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|?conflicts(pattern)             |~Cpattern                   |conflict with a      |
|                                |                            |package matching     |
|                                |                            |pattern.             |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|?config-files                   |~c                          |were removed but not |
|                                |                            |purged.              |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Match packages that  |
|                                |                            |declare a dependency |
|?depType(pattern)               |~D[depType:]pattern         |of type depType on a |
|                                |                            |package matching     |
|                                |                            |pattern.             |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages whose|
|?description(description)       |~ddescription               |description matches  |
|                                |                            |description.         |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select essential     |
|?essential                      |~E                          |packages, those with |
|                                |                            |Essential: yes in    |
|                                |                            |their control files. |
|--------------------------------+----------------------------+---------------------|
|?exact-name(name)               |                            |Select packages named|
|                                |                            |name.                |
|--------------------------------+----------------------------+---------------------|
|?false                          |~F                          |Select no packages.  |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|                                |                            |match pattern with   |
|                                |                            |variable bound to the|
|?for variable: pattern          |                            |package being        |
|                                |                            |matched; see la      |
|                                |                            |section intitulee    |
|                                |                            |<< Explicit search   |
|                                |                            |targets >>.          |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|?garbage                        |~g                          |are not required by  |
|                                |                            |any manually         |
|                                |                            |installed package.   |
|--------------------------------+----------------------------+---------------------|
|?installed                      |~i                          |Select installed     |
|                                |                            |packages.            |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages      |
|?maintainer(maintainer)         |~mresponsable               |maintained by        |
|                                |                            |maintainer.          |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages for  |
|?narrow(filter, pattern)        |~S filter pattern           |which a single       |
|                                |                            |version matches both |
|                                |                            |filter and pattern.  |
|--------------------------------+----------------------------+---------------------|
|?name(name)                     |~nname, name                |Select packages with |
|                                |                            |the given name.      |
|--------------------------------+----------------------------+---------------------|
|?new                            |~N                          |Select new packages. |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Match installed      |
|?obsolete                       |~o                          |packages that cannot |
|                                |                            |be downloaded.       |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|?or(pattern1, pattern2)         |pattern1 | pattern2         |match pattern1,      |
|                                |                            |pattern2, or both.   |
|--------------------------------+----------------------------+---------------------|
|?origin(origin)                 |~Oorigine                   |Select packages with |
|                                |                            |the given origin.    |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|?provides(pattern)              |~Ppattern                   |provide a package    |
|                                |                            |matching pattern.    |
|--------------------------------+----------------------------+---------------------|
|?priority(priority)             |~ppriorite                  |Select packages with |
|                                |                            |the given priority.  |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|                                |                            |are the targets of a |
|?reverse-depType(pattern)       |~R[depType:]pattern         |dependency of type   |
|                                |                            |depType declared by a|
|                                |                            |package matching     |
|                                |                            |pattern.             |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|                                |                            |are the targets of a |
|?reverse-broken-depType(pattern)|~RBdepType:pattern          |broken dependency of |
|                                |                            |type depType declared|
|                                |                            |by a package matching|
|                                |                            |pattern.             |
|--------------------------------+----------------------------+---------------------|
|?section(section)               |~ssection                   |Select packages in   |
|                                |                            |the given section.   |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages whose|
|?source-package(name)           |                            |source package name  |
|                                |                            |matches the regular  |
|                                |                            |expression name.     |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages whose|
|?source-version(version)        |                            |source version       |
|                                |                            |matches the regular  |
|                                |                            |expression version.  |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|?tag(tag)                       |~Gmarqueur                  |have the given       |
|                                |                            |debtags tag.         |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Full-text search for |
|?term(keyword)                  |                            |packages that contain|
|                                |                            |the given keyword.   |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Full-text search for |
|                                |                            |packages that contain|
|?term-prefix(keyword)           |                            |a keyword that begins|
|                                |                            |with the given       |
|                                |                            |keyword.             |
|--------------------------------+----------------------------+---------------------|
|?true                           |~T                          |Select all packages. |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|?task(task)                     |~ttache                     |are in the given     |
|                                |                            |task.                |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|?upgradable                     |~U                          |are installed and can|
|                                |                            |be upgraded.         |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages that |
|                                |                            |are marked with a    |
|?user-tag                       |                            |user-tag matching the|
|                                |                            |regular expression   |
|                                |                            |user-tag.            |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select packages whose|
|                                |                            |version matches      |
|?version(version)               |~Vversion                   |version (special     |
|                                |                            |values: CURRENT,     |
|                                |                            |CANDIDATE, and       |
|                                |                            |TARGET).             |
|--------------------------------+----------------------------+---------------------|
|?virtual                        |~v                          |Select virtual       |
|                                |                            |packages.            |
|--------------------------------+----------------------------+---------------------|
|                                |                            |Select versions for  |
|                                |                            |which pattern matches|
|                                |                            |any version of the   |
|?widen(pattern)                 |~Wpattern                   |corresponding        |
|                                |                            |package, discarding  |
|                                |                            |local version        |
|                                |                            |restrictions.        |
+-----------------------------------------------------------------------------------+

   nom

           Est en correspondance avec les paquets dont le nom correspond `a
           l'expression rationnelle nom. C'est le mode de recherche par
           << defaut >>, utilise pour les motifs qui ne commencent pas par ~.

           [Note] Note
                  To match packages whose names contain several different
                  substrings, use the ?name term (described below); for
                  instance, << ?name(apti)?name(tude) >> will match any
                  package whose name contains both << apti >> and << tude >>.

   ?=variable

           Matches packages that correspond to the value of variable, which
           must be bound by an enclosing ?for. For instance, ?for x:
           ?depends( ?recommends( ?=x ) ) will match any package x that
           depends on a package which recommends x.

           For instance, the following search expression matches packages
           that conflict with themselves:

           Exemple 2.2.  Use of the ?= term.

           ?for x: ?conflicts(?=x)

           See la section intitulee << Explicit search targets >> for more
           information.

   ?not(pattern), !pattern

           Matches packages which do not match the pattern pattern. For
           instance, << ?not(?broken) >> selects packages that are not
           << broken >>.

           [Note] Note
                  To include a << ! >> in a search string, it must be
                  << escaped >> by placing a tilde (<< ~ >>) in front of it;
                  otherwise, aptitude will consider it to be part of a ?not
                  term. For instance, to select packages whose description
                  contains << extra! >>, use << ?description(extra~!) >>.

   ?and(pattern1, pattern2), pattern1 pattern2

           Matches packages that match both pattern1 and pattern2.

   ?or(pattern1, pattern2), pattern1 | pattern2

           Matches packages that match either pattern1 or pattern2.

           [Note] Note
                  Pour inclure un << | >> dans une expression rationnelle, il
                  doit etre << despecialise >> pour eviter qu'aptitude ne
                  fasse un OU logique sur les mots. Pour ce faire, ecrivez
                  << ~| >>.

   (pattern)

           Matches pattern. For instance, << opengl (perl|python) >> matches
           any package whose name contains opengl, and also contains either
           perl or python.

   ?action(action), ~aaction

           Correspond avec les paquets sur lesquels l'action donnee va etre
           effectuee. Action peut etre << install >>, << upgrade >>,
           << downgrade >>, << remove >>, << purge >>, << hold >> (si le
           paquet a ete marque `a conserver), ou << keep >> (si un paquet
           n'est pas modifie).

           Note that this only tests whether an action is actually queued up
           to be performed on a package, not whether it could be performed.
           Thus, for instance, ?action(upgrade) matches exactly those
           packages that you have already decided to upgrade, not packages
           which could be upgraded in the future (for that, use ?upgradable).

   ?all-versions(pattern)

           Matches any package whose versions all match the given expression.
           Each version of a package will be separately tested against
           pattern, and the package will match if all of its versions match.
           Packages without versions, such as virtual packages, will always
           be matched by this search term.

           This term may not be used in a context in which the versions to
           match against have already been narrowed, such as within ?depends
           or ?narrow. However, it may always be used within ?widen.

   ?any-version(pattern)

           Matches a package if any one of its versions matches the enclosed
           pattern. This is the dual to ?all-versions.

           This term may not be used in a context in which the versions to
           match against have already been narrowed, such as within ?depends
           or ?narrow. However, it may always be used within ?widen.

           [Note] Note
                  This term is closely related to ?narrow. In fact,
                  ?any-version(pattern1 pattern2) is exactly the same as
                  ?narrow(pattern1, pattern2).

   ?archive(archive), ~Aarchive

           Matches package versions which are available from an archive that
           matches the regular expression archive. For instance,
           << ?archive(testing) >> matches any package available from the
           testing archive.

   ?automatic, ~M

           Correspond aux paquets qui ont ete automatiquement installes.

   ?bind(variable, pattern), ?variable:term-name[(args)]

           Matches any package or version if the given pattern matches the
           package or version bound to variable, which must be defined in an
           enclosing ?for.

           Exemple 2.3. Use of the ?bind term

           ?for x: ?depends(?depends(?for z: ?bind(x, ?depends(?=z))))

           ?for x: ?depends(?depends(?for z: ?x:depends(?=z)))

           The two search patterns in the above example both match any
           package x such that x depends on a package y which in turn depends
           on a package z such that x also depends directly on z. The first
           pattern uses ?bind directly, while the second one uses an
           equivalent shorthand syntax.

           See la section intitulee << Explicit search targets >> for more
           information.

   ?broken, ~b

           Correspond aux paquets qui sont << casses >> : ils cassent, ou ont
           une dependance, une pre-dependance, ou un conflit non satisfait.

   ?broken-depType, ~BdepType

           Matches packages which have an unfulfilled (<< broken >>)
           dependency of the given depType. depType can be << depends >>,
           << predepends >>, << recommends >>, << suggests >>, << breaks >>,
           << conflicts >>, or << replaces >>.

   ?broken-depType(pattern), ~DB[depType:]pattern

           Matches packages with an unsatisfied dependency of type depType on
           a package matching pattern. depType may be any one of the
           dependency types listed in the documentation of ?broken-depType.

   ?conflicts(pattern), ~Cpattern

           Matches packages which conflict with a package matching the given
           pattern. For instance,
           << ?conflicts(?maintainer(dburrows@debian.org)) >> matches any
           package which conflicts with a package I maintain.

   ?config-files, ~c

           Correspond aux paquets qui ont ete supprimes mais dont les
           fichiers de configuration restent sur le systeme (c'est-`a-dire
           qu'ils ont ete supprimes, mais pas purges).

   ?depType(pattern), ~D[depType:]pattern

           depType may be any one of the dependency types given in the
           documentation of ?broken-depType, as well as provides: for
           instance, ?depends(libpng3) will match any package that depends on
           libpng3. If the short form (~D) is used and depType is not
           present, it defaults to depends.

           If depType is << provides >>, matches packages that provide a
           package matching pattern (the equivalent of ?provides). Otherwise,
           matches packages which declare a dependency of type depType upon a
           package version which matches pattern.

   ?description(description), ~ddescription

           Correspond aux paquets dont la description correspond `a
           l'expression rationnelle description.

   ?essential, ~E

           Correspond aux paquets Essentiels.

   ?exact-name(name)

           Matches packages named name. This is similar to ?name, but the
           name must match exactly. For instance, the following pattern will
           match only the package apt; with ?name, it would also match
           aptitude, uvccapture, etc.

           Exemple 2.4. Use of the ?exact-name term

           ?exact-name(apt)

   ?false, ~F

           This term does not match any package. ^[18]

   ?for variable: pattern

           Matches pattern, but the given variable may be used inside pattern
           to refer to the package or package version this term to.

           You can use variable in two ways. To apply a ?-style term to the
           variable, write ?variable:term-name(args); for instance,
           ?x:depends(apt). In addition, the term ?=variable will select any
           package or version that matches the value of the given variable.

           For instance, the following term will match any package x that
           both depends and recommends a second package y.

           Exemple 2.5. Use of the ?for term

           ?for x: ?depends( ?for y: ?x:recommends( ?=y ) )

           See la section intitulee << Explicit search targets >> for more
           information.

   ?garbage, ~g

           Correspond aux paquets qui ne sont pas installes, ou qui ont ete
           installes automatiquement mais desquels aucun paquet installe ne
           depend.

   ?installed, ~i

           Correspond aux paquets qui sont actuellement installes.

           Bien que par defaut toutes les versions sont testees, ceci n'entre
           en correspondance qu'avec les paquets installes.

   ?maintainer(maintainer), ~mmaintainer

           Matches packages whose Maintainer field matches the regular
           expression maintainer. For instance, << ?maintainer(joeyh) >> will
           find all packages maintained by Joey Hess.

   ?narrow(filter, pattern), ~S filter pattern

           This term << narrows >> the search to package versions matching
           filter. In particular, it matches any package version which
           matches both filter and pattern. The string value of the match is
           the string value of pattern.

   ?name(name), ~nname

           Matches packages whose name matches the regular expression name.
           For instance, most of the packages that match << ?name(^lib) >>
           are libraries of one sort or another.

   ?new, ~N

           Matches packages which are << new >>: that is, they have been
           added to the archive since the last time the list of packages was
           cleared using Actions -> Oublier quels paquets sont nouveaux (f)
           or the command-line action forget-new.

   ?obsolete, ~o

           Ce mot correspond `a tout paquet installe qui n'est disponible
           dans aucune version d'une quelconque archive. Ces paquets
           apparaissent dans l'interface visuel en tant que << Obsolete ou
           installe localement >>

   ?origin(origin), ~Oorigin

           Matches package versions whose origin matches the regular
           expression origin. For instance, << !?origin(debian) >> will find
           any unofficial packages on your system (packages not from the
           Debian archive).

   ?provides(pattern), ~Ppattern

           Matches package versions which provide a package that matches the
           pattern. For instance, << ?provides(mail-transport-agent) >> will
           match all the packages that provide << mail-transport-agent >>.

   ?priority(priority), ~ppriority

           Matches packages whose priority is priority; priority must be
           extra, important, optional, required, or standard. For instance,
           << ?priority(required) >> matches packages whose priority is
           << required >>.

   ?reverse-depType(pattern), ~R[depType:]pattern

           depType may be either << provides >> or one of the dependency
           types given in the documentation of ?broken-depType. If depType is
           not present, it defaults to depends.

           If depType is << provides >>, matches packages whose name is
           provided by a package version matching pattern. Otherwise, matches
           packages which a package version matching pattern declares a
           dependency of type depType upon.

   ?reverse-broken-depType(pattern), ?broken-reverse-depType(pattern),
   ~RB[depType:]pattern

           depType may be either << provides >> or one of the dependency
           types given in the documentation of ?broken-depType. If depType is
           not present, it defaults to depends.

           Matches packages which a package version matching pattern declares
           an unsatisfied dependency of type depType upon.

   ?section(section), ~ssection

           Correspond aux paquets dont la section correspond `a l'expression
           rationnelle section.

   ?source-package(name)

           Matches packages whose source package name matches the regular
           expression name.

   ?source-version(version)

           Matches packages whose source version matches the regular
           expression version.

   ?tag(tag), ~Gtag

           Matches packages whose Tag field matches the regular expression
           tag. For instance, the pattern ?tag(game::strategy) would match
           strategy games.

           Pour plus d'informations sur l'etiquetage et debtags, consultez
           http://debtags.alioth.debian.org.

   ?task(task), ~ttask

           Correspond aux paquets qui font partie d'une tache dont le nom
           correspond `a l'expression rationnelle tache.

   ?term(keyword)

           This term performs a full-text search for keyword in the apt
           package cache. When used with << aptitude search >>, Rechercher ->
           Affichage restreint (l) in the curses front-end, or typed into a
           package search box in the GTK+ front-end, this term will allow
           aptitude to accelerate the search using a Xapian index.

   ?term-prefix(keyword)

           This term performs a full-text search for any keyword beginning
           with keyword in the apt package cache. When used with << aptitude
           search >>, Rechercher -> Affichage restreint (l) in the curses
           front-end, or typed into a package search box in the GTK+
           front-end, this term will allow aptitude to accelerate the search
           using a Xapian index.

           This is similar to ?term, but matches extensions of the keyword.
           For instance, the following search pattern will match any package
           indexed under the keywords hour, hourglass, hourly, and so on:

           Exemple 2.6. Use of the ?term-prefix term

           ?term-prefix(hour)

   ?true, ~T

           This term matches any package. For instance,
           << ?installed?provides(?true) >> matches installed packages which
           are provided by any package.

   ?upgradable, ~U

           Ce mot correspond `a tout paquet installe qui peut etre mis `a
           jour.

   ?user-tag(tag)

           This term matches any package that is marked with a user-tag
           matching the regular expression tag.

   ?version(version), ~Vversion

           Matches any package version whose version number matches the
           regular expression version, with the exceptions noted below. For
           instance, << ?version(debian) >> matches packages whose version
           contains << debian >>.

           Les valeurs suivantes de version sont traitees specialement. Pour
           rechercher une version contenant ces valeurs, faites les preceder
           d'une barre oblique inverse ; par exemple, pour rechercher des
           paquets dont le numero de version contient << CURRENT >>,
           rechercher << \CURRENT >>.

              o CURRENT correspond `a la version actuellement installee d'un
                paquet, s'il y en a une.

              o CANDIDATE correspond `a la version, si elle existe, du paquet
                qui sera installee si vous appuyez sur + quand le paquet est
                selectionne ou si vous lancez aptitude install avec son nom.

              o TARGET correspond `a la version d'un paquet dont
                l'installation est prevue, si elle existe.

   ?virtual, ~v

           Matches any package which is purely virtual: that is, its name is
           provided by a package or mentioned in a dependency, but no package
           of that name exists. For instance, << ?virtual!?provides(?true) >>
           matches packages which are virtual and are not provided by any
           package: ie, packages which are depended upon but do not exist.

   ?widen(pattern), ~Wpattern

           << Widens >> the match: if the versions to match against have been
           limited by an enclosing term (such as ?depends), these limits are
           dropped. Thus, ?widen(pattern) matches a package version if
           pattern matches any version of that package.

Personnalisation d'aptitude

  Customizing the package list

   La liste de paquets peut etre enormement personnalisee : la maniere
   d'afficher les paquets, de les ranger, de les trier et meme l'organisation
   de l'affichage sont toutes modifiables.

    Personnaliser la maniere d'afficher les paquets

   This section describes how to configure the contents and format of the
   package list, status line, and header line, as well as the output of
   aptitude search.

   Le format de chacune de ces zones est defini par une << chaine de
   format >>. Une chaine de format est une chaine de texte contenant des
   commandes de format debutant par % comme %p, %S, etc. L'affichage
   correspondant est cree en remplac,ant les commandes debutant par % en
   fonction de leur signification (donnee ci-dessous).

   Une commande de format (commenc,ant par %) peut soit avoir une taille fixe
   et dans ce cas elle est toujours remplacee par la meme quantite de texte
   (avec l'ajout d'espaces pour le completer si necessaire), soit elle est
   << etirable >> ce qui signifie qu'elle prend tout l'espace laisse libre
   par les colonnes de texte `a taille fixe. S'il y a plusieurs colonnes
   etirables, l'espace supplementaire est divise equitablement entre les
   colonnes.

   Toutes les commandes de format possedent une taille fixe et/ou etirable
   par defaut. La taille d'une commande de format peut etre modifiee en
   inserant la valeur de la taille voulue entre le signe pourcentage (%) et
   le caractere identifiant le format. Par exemple, %20V produit une colonne
   version installable des paquets d'une largeur de 20 caracteres. Placer un
   point d'interrogation (?) entre le signe % et le caractere identifiant la
   commande de format entraine la variation de la largeur de base de la
   colonne en fonction de son contenu. Remarquez, neanmoins, que les colonnes
   de ce type risque de ne plus s'aligner verticalement.

   Si vous souhaitez qu'une commande de format soit etirable, meme si elle
   possede normalement une largeur fixe, placez un signe diese (<< # >>)
   immediatement apres elle. Par exemple, pour afficher la version
   installable d'un paquet sans vous soucier de sa longueur, utilisez la
   commande de format %V#. Vous pouvez aussi mettre un # apres autre chose
   qu'une commande de format ; aptitude va alors << etirer >> le texte qui
   precede le # en inserant des espaces additionnelles apres lui.

   En resume, la syntaxe des commandes de format est :

 %[largeur][?]code[#]

   The configuration variables Aptitude::UI::Package-Display-Format,
   Aptitude::UI::Package-Status-Format, and
   Aptitude::UI::Package-Header-Format define the default formats the package
   list, the header at the top of the package list, and the status line below
   the package list respectively. To change how the results of an aptitude
   search command are displayed, use the -F option.

   Les commandes de format (debutant par %) suivantes sont disponibles :

   [Note] Note
          Plusieurs des descriptions ci-dessous font reference << au
          paquet >>. Avec l'interface graphique, c'est soit le paquet qui est
          affiche, soit le paquet actuellement selectionne. Dans la recherche
          avec l'interface en ligne de commande, c'est le paquet qui est
          affiche.

   Commande       Nom         Taille par   Etirable        Description
                                defaut
                                                    Ce n'est pas vraiment une
                                                    commande de format, cela
   %%       % litteral       1             Non      insere simplement un
                                                    signe pourcentage dans
                                                    l'affichage `a l'endroit
                                                    ou elle est placee.
                                                    Dans certaines
                                                    circonstances, une chaine
                                                    de format d'affichage
                                                    comportera des
                                                    << parametres >> : par
                                                    exemple, dans la ligne de
            Remplacement de                         commande search, les
   %#nombre parametre        Variable      Non      groupes correspondants `a
                                                    la recherche sont
                                                    utilises comme parametres
                                                    lors de l'affichage du
                                                    resultat. Le code de
                                                    format sera remplace par
                                                    le parametre indique par
                                                    nombre.
                                                    Caractere unique resumant
                                                    l'action `a executer sur
                                                    le paquet, comme decrit
   %a       Marque d'action  1             Non      dans Figure 2.10,
                                                    << Valeurs de
                                                    l'indicateur
                                                    << d'action >> >>.
                                                    Description plus lisible
   %A       Action           10            Non      de l'action `a executer
                                                    sur le paquet.
                                                    S'il n'y a pas de paquet
                                                    casse, cela ne produit
            Comptage des                            rien. Sinon, cela produit
   %B       casses           12            Non      une chaine telle que
                                                    << Casse : 10 >>
                                                    indiquant le nombre de
                                                    paquets casses.
                                                    Caractere unique resumant
                                                    l'etat actuel du paquet,
   %c       Marqueur d'etat  1             Non      comme decrit dans
            actuel                                  Figure 2.9, << Valeurs de
                                                    l'indicateur de << l'etat
                                                    courant >> >>.
                                                    Description plus lisible
   %C       Etat actuel      11            Non      de l'etat actuel du
                                                    paquet.
   %d       Description      40            Oui      Description courte du
                                                    paquet.
   %D       Taille du paquet 6             Non      Taille de l'archive
                                                    contenant le paquet.
                                                    Nom d'hote de
   %H       Nom d'hote       15            Non      l'ordinateur sur lequel
                                                    aptitude fonctionne.
                                                    Affiche la priorite
                                                    maximale assignee `a la
                                                    version du paquet. Pour
   %i       Priorite (Pin    4             Non      les paquets, cela affiche
            priority)                               la priorite de la version
                                                    dans laquelle le paquet
                                                    est force d'etre installe
                                                    (s'il y en a une).
   %I       Taille installee 6             Non      Espace (estime) que prend
                                                    le paquet sur le disque.
   %m       Responsable      30            Oui      Responsable du paquet.
                                                    Si le paquet a ete
   %M       Marquage         1             Non      installe automatiquement,
            automatique                             affiche << A >>, sinon
                                                    n'affiche rien.
            Version du       Longueur de            Outputs the version of
   %n       programme        << 0.6.3 >>   Non      aptitude that is running,
                                                    currently << 0.6.3 >>.
                             The length of          Outputs the name of the
   %N       Nom du programme the name.     Non      program; usually
                                                    << aptitude >>.
                                                    Si aucun paquet ne doit
                                                    etre installe, n'affiche
                                                    rien. Sinon, affiche une
                                                    chaine indiquant la
            Taille `a                               taille totale prise par
   %o       telecharger      15            Non      les paquets `a installer
                                                    (c'est-`a-dire une
                                                    estimation de ce qu'il
                                                    faut telecharger) ; par
                                                    exemple, << 28,5ko `a
                                                    telecharger >>.
                                                    Affiche le nom du paquet.
                                                    Quand un paquet est
                                                    affiche dans une
   %p       Nom du paquet    30            Oui      arborescence, le nom sera
                                                    indente, si possible, en
                                                    fonction de la profondeur
                                                    de l'arbre.
   %P       Priorite         9             Non      Affiche la priorite du
                                                    paquet.
            Compteur des                            Affiche le nombre
   %r       dependances      2             Non      approximatif de paquets
            inverses                                installes qui dependent
                                                    du paquet.
                                                    Affiche la description
            Abreviation de                          abregee de la priorite du
   %R       la priorite      3             Non      paquet : par exemple,
                                                    << Important >> devient
                                                    << Imp >>.
   %s       Section          10            Non      Affiche la section du
                                                    paquet.
                                                    Si le paquet n'est pas
   %S       Niveau de        1             Non      certifie par une source
            confiance                               de confiance, affiche la
                                                    lettre "U".
   %t       Archive          10            Oui      Archive dans laquelle se
                                                    trouve le paquet.
                                                    Outputs << * >> if the
   %T       Etiquete         1             Non      package is tagged,
                                                    nothing otherwise.^[19]
                                                    Si l'action prevue doit
            Modification de                         modifier l'espace disque
   %u       l'utilisation du 30            Non      utilise, cela indique le
            disque                                  changement, par exemple,
                                                    << Utilisera 100,0Mo
                                                    d'espace disque. >>
                                                    Affiche la version
                                                    actuellement installee du
   %v       Version actuelle 10            Non      paquet, ou <aucun> si le
                                                    paquet n'est pas
                                                    actuellement installe.
                                                    Affiche la version du
                                                    paquet qui serait
                                                    installee si Paquet ->
   %V       Version          10            Non      Installer (+) etait
            installable                             execute sur le paquet, ou
                                                    <aucun> si le paquet
                                                    n'est pas actuellement
                                                    installe.
                                                    Affiche l'espace
                                                    supplementaire utilise ou
   %Z       Changement de    7             Non      l'espace libere par
            taille                                  l'installation, la mise
                                                    `a jour ou la suppression
                                                    du paquet.

    Personnaliser la hierarchie des paquets

   La hierarchie des paquets est produite par une politique de regroupement :
   des regles decrivant la maniere de construire la hierarchie. La politique
   de regroupement decrit une << succession >> de regles. Chaque regle peut
   retirer des paquets, creer une sous-hierarchie dans laquelle on place des
   paquets ou encore manipuler l'arborescence. Les variables de configuration
   Aptitude::UI::Default-Grouping et Aptitude::UI::Default-Preview-Grouping
   definissent les politiques de regroupement lors de la creation,
   respectivement, de nouvelles listes de paquets et de nouveaux ecrans de
   previsualisation. Vous pouvez definir la politique de regroupement pour la
   liste de paquets actuelle en appuyant sur G.

   La politique de regroupement est decrite par une liste de regles separees
   par des virgules : regle1,regle2,.... Chaque regle est constituee du nom
   de la regle, eventuellement suivi d'arguments : par exemple, versions ou
   section(subdir). Le fait que des arguments soient requis et le nombre
   d'arguments requis (ou permis) depend du type de regle.

   Une regle peut etre non terminale ou terminale. Une regle non terminale va
   traiter un paquet en produisant une partie de la hierarchie, puis en le
   passant `a la regle suivante. Une regle terminale, au contraire, va aussi
   traiter une partie de l'arborescence (typiquement les entrees
   correspondant au paquet), mais ne passera pas le paquet `a la regle qui
   suit. Si aucune regle terminale n'est specifiee, aptitude va utiliser la
   regle par defaut qui cree les << entrees de paquet >> standards.

 action

           Regroupe les paquets suivant l'action prevue sur ceux-ci. Les
           paquets qui ne peuvent etre mis `a jour ou qui sont inchanges sont
           ignores. C'est le regroupement qui est utilise dans l'arborescence
           d'aperc,u d'installation.

 deps

           C'est une regle terminale.

           Cree les entrees de paquets standard qui peuvent etre depliees
           pour laisser apparaitre les dependances d'un paquet.

 filter(motif)

           N'inclut que les paquets dont au moins une version correspond `a
           motif.

           Si motif est manquant, aucun paquet n'est ecarte. Ceci est une
           fonctionnalite de compatibilite ascendante et peut etre supprimee
           dans le futur.

 firstchar

           Regroupe les paquets en fonction de la premiere lettre de leur
           nom.

 hier

           Regroupe les paquets en fonction d'un fichier de donnees annexe
           qui decrit une << hierarchie >> de paquets.

 pattern(pattern [=> title] [{ policy }] [, ...])

           A customizable grouping policy. Each version of every package is
           matched against the given patterns. The first match found is used
           to assign a title to the package; packages are then grouped by
           their title. Strings of the form \N that occur in title will be
           replaced by the Nth result of the match. If title is not present,
           it is assumed to be \1. Note that packages which do not match any
           patterns will not appear in the tree at all.

           Exemple 2.7. Use of pattern to group packages by their maintainer

           pattern(?maintainer() => \1)

           The example above will group packages according to their
           Maintainer field. The policy pattern(?maintainer()) will do the
           same thing, as the absent title defaults to \1.

           Instead of => title, an entry may end with ||. This indicates that
           packages matching the corresponding pattern will be inserted into
           the tree at the same level as the pattern grouping, rather than
           being placed in subtrees.

           Exemple 2.8.  Use of pattern with some packages placed at the top
           level

           pattern(?action(remove) => Packages Being Removed, ?true ||)

           The example above will place packages that are being removed into
           a subtree, and place all the other packages at the current level,
           grouped according to the policies that follow pattern.

           By default, all the packages that match each pattern are grouped
           according to the rules that follow the pattern policy. To specify
           a different policy for some packages, write the policy in braces
           ({}) after the title of the group, after the ||, or after the
           pattern if neither is present. For instance:

           Exemple 2.9.  Use of the pattern grouping policy with sub-policies

           pattern(?action(remove) => Packages Being Removed {},
           ?action(install) => Packages Being Installed, ?true || {status})

           The policy in the above example has the following effects:

              o Packages that are being removed are placed into a subtree
                labeled << Packages Being Removed >>; the grouping policy for
                this subtree is empty, so the packages are placed into a flat
                list.

              o Packages that are being installed are placed into a subtree
                labeled Packages Being Installed and grouped according to the
                policies that follow pattern.

              o All remaining packages are placed at the top level of the
                tree, grouped according to their status.

           Consultez la section la section intitulee << Search patterns >>
           pour plus d'information sur le format de motif.

 priority

           Regroupe les paquets en fonction de leur priorite.

 section[(mode[,passthrough])]

           Regroupe les paquets en fonction de leur champ Section.

           mode peut prendre les valeurs suivantes :

                none

                        Group based on the whole Section field, so categories
                        like << non-free/games >> will be created. This is
                        the default if no mode is specified.

                topdir

                        Group based on the part of the Section field before
                        the first / character; if this part of the Section is
                        not recognized, or if there is no /, the first entry
                        in the list Aptitude::Sections::Top-Sections will be
                        used instead.

                subdir

                        Group based on the part of the Section field after
                        the first / character, if it is contained in the list
                        Aptitude::Sections::Top-Sections. If not, or if there
                        is no /, group based on the entire Section field
                        instead.

                subdirs

                        Group based on the part of the Section field after
                        the first / character, if the portion of the field
                        preceding it is contained in the list
                        Aptitude::Sections::Top-Sections; if not, or if there
                        is no /, the entire field will be used. If there are
                        multiple / characters in the portion of the field
                        that is used, a hierarchy of groups will be formed.
                        For instance, if << games >> is not a member of
                        Aptitude::Sections::Top-Sections, then a package with
                        a section of << games/arcade >> will be placed under
                        the top-level heading << games >>, in a sub-tree
                        named << arcade >>.

           Si passthrough est present, les paquets qui, pour une raison ou
           une autre, ne possedent pas de veritable Section (par exemple, les
           paquets virtuels) sont passes directement au niveau de
           regroupement suivant sans etre places en premier dans une
           sous-categorie.

 status

           Trie les paquets dans les categories suivantes :

              o Installes

              o Non installes

              o Mise `a jour de securite

              o Pouvant etre mis `a jour

              o Obsoletes ou crees localement

              o Virtuels

 tag[(aspect)]

           Regroupe les paquets en fonction de l'information du champ
           Marqueur contenu dans les fichiers de paquets Debian. Si aspect
           est fourni, alors seuls les marqueurs correspondants `a cet aspect
           seront affiches. Sinon, tous les paquets seront affiches au moins
           une fois (les paquets sans marqueur seront places dans une liste
           separee de ceux qui en ont).

           Pour plus d'informations sur debtags, consultez le site
           http://debtags.alioth.debian.org.

 task

           Cree une arborescence appelee << Taches >> qui contient les taches
           disponibles (les informations sur les taches sont lues depuis
           debian-tasks.desc du paquet tasksel). La regle suivant task va
           creer ses categories comme des enfants de Taches.

 versions

           C'est une regle terminale.

           Cree des entrees de paquets standard qui peuvent etre depliees
           pour laisser apparaitre les versions du paquet.

    Personnaliser la maniere de trier les paquets

   By default, packages in the package list or in the output of aptitude
   search are sorted by name. However, it is often useful to sort them
   according to different criteria (for instance, package size), and aptitude
   allows you to do just that by modifying the sorting policy.

   Comme la politique de regroupement decrite dans la section precedente, la
   politique de tri est une liste separee par des virgules. Chaque entree de
   la liste est le nom d'une regle de tri ; si les paquets sont identiques
   selon la premiere regle, la seconde tente de les trier, et ainsi de suite.
   Placer un caractere tilde (~) avant la regle inverse la signification
   habituelle de la regle. Par exemple, priority,~name va trier les paquets
   par priorite, et les paquets de meme priorite seront places dans l'ordre
   alphabetique inverse.

   To change the sorting policy for an active package list, press S. To
   change the default sorting for all package lists, set the configuration
   option Aptitude::UI::Default-Sorting. To change the sorting policy for
   aptitude search, use the --sort command-line option.

   Les regles disponibles sont :

   installsize

           Trie les paquets selon l'estimation de la taille necessaire `a
           l'installation.

   name

           Trie les paquets selon leur nom.

   priority

           Trie les paquets selon leur priorite.

   version

           Trie les paquets selon leur version.

  Personnaliser les raccourcis clavier

   Les touches utilisees pour lancer des commandes d'aptitude peuvent etre
   personnalisees dans le fichier de configuration. Chaque commande possede
   une variable de configuration associee sous Aptitude::UI::Keybindings.
   Pour changer la sequence de touches liee `a une commande, il suffit de
   modifier la variable correspondant `a la sequence de touches. Par exemple,
   pour associer la touche s `a une recherche, mettez
   Aptitude::UI::Keybindings::Search `a << s >>. Vous pouvez demander `a ce
   que la touche Controle soit aussi enfonce en plac,ant << C- >> devant la
   touche : par exemple mettre << C-s >> `a la place de << s >> va lier la
   recherche `a la recherche `a Controle+s au lieu de s. Enfin, vous pouvez
   lier une commande `a plusieurs sequences de touches en une seule fois en
   les separant par des virgules : par exemple utiliser << s,C-s >> aura pour
   consequence que s et Controle+s lanceront une recherche.

   Les commandes suivantes peuvent etre liees `a une sequence de touches en
   configurant les variables Aptitude::UI::Keybindings::commande, ou commande
   est le nom de la commande `a lier :

   +------------------------------------------------------------------------+
   |        Commande        | Valeur par defaut |        Description        |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Si des paquets sont       |
   |                        |                   | casses et aptitude a      |
   | ApplySolution          | !                 | suggere une solution au   |
   |                        |                   | probleme, applique        |
   |                        |                   | immediatement la          |
   |                        |                   | solution.                 |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Se deplace au debut de    |
   |                        |                   | l'affichage courant : au  |
   | Begin                  | home,C-a          | debut de la liste ou `a   |
   |                        |                   | gauche d'un champ de      |
   |                        |                   | saisie de texte.          |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Envoie un rapport de      |
   | BugReport              | B                 | bogue contre le paquet    |
   |                        |                   | couramment selectionne,   |
   |                        |                   | en utilisant reportbug.   |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Annule l'interaction      |
   | Cancel                 | C-g,escape,C-[    | courante. Par exemple,    |
   |                        |                   | sort d'une boite de       |
   |                        |                   | dialogue ou du menu.      |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Affiche le fichier        |
   |                        |                   | changelog.Debian du       |
   | Changelog              | C                 | paquet actuellement       |
   |                        |                   | selectionne ou de la      |
   |                        |                   | version du paquet.        |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Change la politique de    |
   | ChangePkgTreeGrouping  | G                 | regroupement de la liste  |
   |                        |                   | de paquets actuellement   |
   |                        |                   | active.                   |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Change la restriction     |
   | ChangePkgTreeLimit     | l                 | d'affichage de la liste   |
   |                        |                   | de paquets actuellement   |
   |                        |                   | active.                   |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Change la politique de    |
   | ChangePkgTreeSorting   | S                 | tri de la liste de        |
   |                        |                   | paquets actuellement      |
   |                        |                   | active.                   |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Marque le paquet          |
   | ClearAuto              | m                 | actuellement selectionne  |
   |                        |                   | comme ayant ete installe  |
   |                        |                   | manuellement.             |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Replie toute              |
   | CollapseAll            | ]                 | l'arborescence            |
   |                        |                   | selectionnee dans une     |
   |                        |                   | liste hierarchique.       |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Replie la racine de       |
   | CollapseTree           | Aucune sequence   | l'arborescence            |
   |                        |                   | selectionnee dans une     |
   |                        |                   | liste hierarchique.       |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans l'editeur de         |
   |                        |                   | hierarchie garde en       |
   | Commit                 | N                 | memoire l'emplacement     |
   |                        |                   | hierarchique du paquet    |
   |                        |                   | actuel et passe au paquet |
   |                        |                   | suivant.                  |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans les boites de        |
   |                        |                   | dialogue, c'est           |
   |                        |                   | equivalent `a << Ok >>.   |
   | Confirm                | enter             | Lors d'une interaction en |
   |                        |                   | ligne de commande avec    |
   |                        |                   | une question `a choix     |
   |                        |                   | multiples, cela choisit   |
   |                        |                   | l'option par defaut.      |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Change le focus clavier   |
   | Cycle                  | tab               | vers le << widget >>      |
   |                        |                   | suivant.                  |
   |------------------------+-------------------+---------------------------|
   | CycleNext              | f6                | Change vers la vue active |
   |                        |                   | suivante.                 |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Circule parmi des         |
   | CycleOrder             | o                 | elements predefinis de    |
   |                        |                   | l'affichage.              |
   |------------------------+-------------------+---------------------------|
   | CyclePrev              | f7                | Change vers la vue active |
   |                        |                   | precedente.               |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Supprime tout le texte    |
   | DelBOL                 | C-u               | entre le curseur et le    |
   |                        |                   | debut de la ligne.        |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Supprime le caractere     |
   | DelBack                | backspace,C-h     | precedent lors de la      |
   |                        |                   | saisie de texte.          |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Supprime tout le texte    |
   | DelEOL                 | C-k               | depuis le curseur         |
   |                        |                   | jusqu'`a la fin de la     |
   |                        |                   | ligne.                    |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Supprime le caractere     |
   | DelForward             | delete,C-d        | sous le curseur lors de   |
   |                        |                   | la saisie de texte.       |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Affiche les dependances   |
   | Dependencies           | d                 | du paquet actuellement    |
   |                        |                   | selectionne.              |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans la liste de paquets, |
   | DescriptionCycle       | i                 | alterne les vues          |
   |                        |                   | disponibles dans la zone  |
   |                        |                   | d'information.            |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans la liste de paquets, |
   | DescriptionDown        | z                 | descend d'une ligne dans  |
   |                        |                   | la zone d'information.    |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans la liste de paquets, |
   | DescriptionUp          | a                 | monte d'une ligne dans la |
   |                        |                   | zone d'information.       |
   |------------------------+-------------------+---------------------------|
   |                        |                   | If not in a preview       |
   |                        |                   | screen, display the       |
   | DoInstallRun           | g                 | preview screen ^[a]; if   |
   |                        |                   | in a preview screen,      |
   |                        |                   | perform an install run.   |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Descend : par exemple,    |
   |                        |                   | descend dans un affichage |
   | Down                   | down,j            | de texte, ou selectionne  |
   |                        |                   | l'entree suivante dans    |
   |                        |                   | une liste.                |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Lance                     |
   | DpkgReconfigure        | R                 | << dpkg-reconfigure >>    |
   |                        |                   | sur le paquet             |
   |                        |                   | actuellement selectionne. |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Si des paquets sont       |
   |                        |                   | casses, ecrit l'etat      |
   | DumpResolver           | *                 | actuel du solveur de      |
   |                        |                   | probleme dans un fichier  |
   |                        |                   | (pour des raisons de      |
   |                        |                   | debogage).                |
   |------------------------+-------------------+---------------------------|
   | EditHier               | E                 | Ouvre l'editeur           |
   |                        |                   | hierarchique.             |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Se deplace `a la fin de   |
   |                        |                   | l'affichage courant : `a  |
   | End                    | end,C-e           | la fin de la liste ou `a  |
   |                        |                   | droite d'un champ de      |
   |                        |                   | saisie de texte.          |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Si des paquets sont       |
   |                        |                   | casses et qu'aptitude a   |
   |                        |                   | suggere une solution au   |
   | ExamineSolution        | e                 | probleme, affiche une     |
   |                        |                   | boite de dialogue         |
   |                        |                   | contenant une description |
   |                        |                   | detaillee de la solution. |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Deploie toute             |
   | ExpandAll              | [                 | l'arborescence            |
   |                        |                   | selectionnee dans une     |
   |                        |                   | liste hierarchique.       |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Deploie la racine de      |
   | ExpandTree             | Aucune sequence   | l'arborescence            |
   |                        |                   | selectionnee dans une     |
   |                        |                   | liste hierarchique.       |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Selectionne la premiere   |
   | FirstSolution          | <                 | solution generee par le   |
   |                        |                   | solveur de probleme.      |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Interdit `a un paquet     |
   |                        |                   | d'etre mis `a jour vers   |
   | ForbidUpgrade          | F                 | la version actuelle d'un  |
   |                        |                   | paquet (ou une version    |
   |                        |                   | particuliere).            |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Oublie quels paquets sont |
   |                        |                   | << nouveaux >> (ce qui    |
   | ForgetNewPackages      | f                 | implique que la liste des |
   |                        |                   | << nouveaux >> paquets    |
   |                        |                   | devienne vide).           |
   |------------------------+-------------------+---------------------------|
   | Help                   | ?                 | Affiche l'aide en ligne   |
   |                        |                   | `a l'ecran.               |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans un editeur           |
   | HistoryNext            | down,C-n          | comportant un historique, |
   |                        |                   | descend dans              |
   |                        |                   | l'historique.             |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans un editeur           |
   | HistoryPrev            | up,C-p            | comportant un historique, |
   |                        |                   | remonte dans              |
   |                        |                   | l'historique.             |
   |------------------------+-------------------+---------------------------|
   | Hold                   | =                 | Gele un paquet.           |
   |------------------------+-------------------+---------------------------|
   | Install                | +                 | Marque un paquet pour     |
   |                        |                   | installation.             |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Marque un unique paquet   |
   |                        |                   | pour installation. Tous   |
   | InstallSingle          | I                 | les autres paquets sont   |
   |                        |                   | gardes dans leur version  |
   |                        |                   | actuelle.                 |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Annule toute demande      |
   | Keep                   | :                 | d'installation ou de      |
   |                        |                   | suppression d'un paquet.  |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Selectionne la derniere   |
   | LastSolution           | <                 | solution generee par le   |
   |                        |                   | solveur de probleme.      |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Se deplace vers la        |
   |                        |                   | gauche : par exemple, se  |
   |                        |                   | deplace vers la gauche    |
   | Left                   | left,h            | dans la barre de menu, ou |
   |                        |                   | deplace le curseur vers   |
   |                        |                   | la gauche lors de la      |
   |                        |                   | saisie de texte.          |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans une liste            |
   |                        |                   | hierarchique, selectionne |
   |                        |                   | l'enfant suivant l'entree |
   | LevelDown              | J                 | actuellement selectionnee |
   |                        |                   | (l'entree suivante au     |
   |                        |                   | meme niveau avec le meme  |
   |                        |                   | parent).                  |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans une liste            |
   |                        |                   | hierarchique, selectionne |
   |                        |                   | l'enfant precedent        |
   | LevelUp                | K                 | l'entree actuellement     |
   |                        |                   | selectionnee (l'entree    |
   |                        |                   | precedente au meme niveau |
   |                        |                   | avec le meme parent).     |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Tente de mettre `a jour   |
   |                        |                   | tous les paquets qui ne   |
   | MarkUpgradable         | U                 | sont pas bloques ou       |
   |                        |                   | interdits de mise `a      |
   |                        |                   | jour.                     |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans le demineur, place   |
   | MineFlagSquare         | f                 | ou enleve le drapeau      |
   |                        |                   | d'une case.               |
   |------------------------+-------------------+---------------------------|
   | MineLoadGame           | L                 | Charge une partie de      |
   |                        |                   | demineur.                 |
   |------------------------+-------------------+---------------------------|
   | MineSaveGame           | S                 | Sauvegarde une partie de  |
   |                        |                   | demineur.                 |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Fait le menage autour de  |
   | MineSweepSquare        | Aucune sequence   | la case actuelle dans le  |
   |                        |                   | demineur.                 |
   |------------------------+-------------------+---------------------------|
   | MineUncoverSquare      | Aucune sequence   | Decouvre la case actuelle |
   |                        |                   | dans le demineur          |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Decouvre la case actuelle |
   | MineUncoverSweepSquare | enter             | dans le demineur si elle  |
   |                        |                   | est couverte, sinon fait  |
   |                        |                   | le menage autour d'elle.  |
   |------------------------+-------------------+---------------------------|
   | NextPage               | pagedown,C-f      | Va `a la page suivante de |
   |                        |                   | l'affichage courant.      |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Va `a la solution         |
   | NextSolution           | .                 | suivante du solveur de    |
   |                        |                   | dependance.               |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Selectionne la reponse    |
   | No                     | n^[b]             | << non >> dans une boite  |
   |                        |                   | de dialogue oui/non.      |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Selectionne le parent de  |
   | Parent                 | ^                 | l'entree selectionnee     |
   |                        |                   | dans une liste            |
   |                        |                   | hierarchique.             |
   |------------------------+-------------------+---------------------------|
   | PrevPage               | pageup,C-b        | Va `a la page precedente  |
   |                        |                   | de l'affichage courant.   |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Revient `a la solution    |
   | PrevSolution           | ,                 | precedente du solveur de  |
   |                        |                   | dependance.               |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Marque le paquet          |
   | Purge                  | _                 | actuellement selectionne  |
   |                        |                   | pour purge.               |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Active le bouton          |
   | PushButton             | space,enter       | actuellement selectionne, |
   |                        |                   | ou modifie l'etat d'une   |
   |                        |                   | boite `a cocher.          |
   |------------------------+-------------------+---------------------------|
   | Quit                   | q                 | Ferme la vue actuelle.    |
   |------------------------+-------------------+---------------------------|
   | QuitProgram            | Q                 | Quitte le programme.      |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Reject all resolver       |
   |                        |                   | actions that would break  |
   | RejectBreakHolds       |                   | a hold; equivalent to     |
   |                        |                   | Resolver -> Reject        |
   |                        |                   | Breaking Holds.           |
   |------------------------+-------------------+---------------------------|
   | Refresh                | C-l               | Redessine la totalite de  |
   |                        |                   | l'ecran.                  |
   |------------------------+-------------------+---------------------------|
   | Remove                 | -                 | Marque un paquet pour     |
   |                        |                   | suppression.              |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Marque le paquet          |
   | ReInstall              | L                 | actuellement selectionne  |
   |                        |                   | pour reinstallation.      |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Repete la derniere        |
   | RepeatSearchBack       | N                 | recherche, mais dans la   |
   |                        |                   | direction opposee.        |
   |------------------------+-------------------+---------------------------|
   | ReSearch               | n                 | Repete la derniere        |
   |                        |                   | recherche.                |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Affiche les paquets qui   |
   | ReverseDependencies    | r                 | dependent du paquet       |
   |                        |                   | actuellement selectionne. |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Se deplace vers la        |
   |                        |                   | droite : par exemple, se  |
   |                        |                   | deplace vers la droite    |
   | Right                  | right,l           | dans la barre de menu, ou |
   |                        |                   | deplace le curseur vers   |
   |                        |                   | la droite lors de la      |
   |                        |                   | saisie de texte.          |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans l'editeur de         |
   | SaveHier               | S                 | hierarchie, sauvegarde la |
   |                        |                   | hierarchie actuelle.      |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Active la fonction de     |
   | Search                 | /                 | << recherche >> sur       |
   |                        |                   | l'element de l'interface  |
   |                        |                   | actuellement actif.       |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Active la fonction de     |
   |                        |                   | << recherche arriere >>   |
   | SearchBack             | \                 | sur l'element de          |
   |                        |                   | l'interface actuellement  |
   |                        |                   | actif.                    |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans une arborescence de  |
   | SearchBroken           | b                 | paquets, recherche le     |
   |                        |                   | paquet casse suivant.     |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Marque le paquet courant  |
   | SetAuto                | M                 | comme ayant ete           |
   |                        |                   | automatiquement installe. |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Dans une liste de         |
   | ShowHideDescription    | D                 | paquets, definit si la    |
   |                        |                   | zone d'information est    |
   |                        |                   | visible ou non.           |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Lors de l'affichage d'une |
   |                        |                   | solution, marque l'action |
   |                        |                   | actuellement selectionnee |
   | SolutionActionApprove  | a                 | comme << approuvee >>     |
   |                        |                   | (elle sera, autant que    |
   |                        |                   | possible, incluse dans    |
   |                        |                   | les prochaines            |
   |                        |                   | solutions).               |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Lors de l'affichage d'une |
   |                        |                   | solution, marque l'action |
   | SolutionActionReject   | r                 | actuellement selectionnee |
   |                        |                   | comme << rejete >> (les   |
   |                        |                   | prochaines solutions ne   |
   |                        |                   | la contiendront pas).     |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Deploie ou reduit         |
   |                        |                   | l'arborescence            |
   | ToggleExpanded         | enter             | actuellement selectionnee |
   |                        |                   | dans une liste            |
   |                        |                   | hierarchique.             |
   |------------------------+-------------------+---------------------------|
   | ToggleMenuActive       | C-m,f10,C-space   | Active ou desactive le    |
   |                        |                   | menu principal.           |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Cancels the last action,  |
   |                        |                   | up to when aptitude was   |
   | Undo                   | C-_,C-u           | started OR the last time  |
   |                        |                   | you update the package    |
   |                        |                   | lists or installed        |
   |                        |                   | packages.                 |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Monte : par exemple, dans |
   |                        |                   | un ecran de selection, va |
   | Up                     | up,k              | au texte precedent, ou    |
   |                        |                   | dans une liste, va `a     |
   |                        |                   | l'entree precedente.      |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Met `a jour la liste de   |
   |                        |                   | paquets en telechargeant  |
   | UpdatePackageList      | u                 | de nouvelles listes       |
   |                        |                   | depuis Internet si        |
   |                        |                   | necessaire.               |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Affiche les versions      |
   | Versions               | v                 | disponibles du paquet     |
   |                        |                   | actuellement selectionne. |
   |------------------------+-------------------+---------------------------|
   |                        |                   | Cette sequence va         |
   | Yes                    | y ^[b]            | selectionner le bouton    |
   |                        |                   | << Oui >> dans les boites |
   |                        |                   | de dialogue oui/non.      |
   |------------------------------------------------------------------------|
   | ^[a] `a moins que Aptitude::Display-Planned-Action soit << false >>    |
   | (faux).                                                                |
   |                                                                        |
   | ^[b] Cette valeur par defaut peut varier suivant la locale             |
   | (c'est-`a-dire la langue du systeme).                                  |
   +------------------------------------------------------------------------+

   En plus des touches de lettres, chiffres et ponctuations, les touches
   << speciales >> suivantes peuvent etre liees dans une sequence :

   +------------------------------------------------------------------------+
   | Nom de la touche |                     Description                     |
   |------------------+-----------------------------------------------------|
   | a1               | Touche A1.                                          |
   |------------------+-----------------------------------------------------|
   | a3               | Touche A3.                                          |
   |------------------+-----------------------------------------------------|
   | b2               | Touche B2.                                          |
   |------------------+-----------------------------------------------------|
   | backspace        | Touche Retour Arriere.                              |
   |------------------+-----------------------------------------------------|
   | backtab          | Touche Tabulation Arriere.                          |
   |------------------+-----------------------------------------------------|
   | begin            | Touche Begin (pas Origine, c'est-`a-dire            |
   |                  | << Home >>).                                        |
   |------------------+-----------------------------------------------------|
   | break            | Touche << break >>.                                 |
   |------------------+-----------------------------------------------------|
   | c1               | Touche C1.                                          |
   |------------------+-----------------------------------------------------|
   | c3               | Touche C3.                                          |
   |------------------+-----------------------------------------------------|
   | cancel           | Touche Annuler (<< Cancel >>).                      |
   |------------------+-----------------------------------------------------|
   | create           | Touche Creation (<< Create >>).                     |
   |------------------+-----------------------------------------------------|
   |                  | Virgule (,) -- notez que, comme les virgules sont   |
   | comma            | utilisees pour lister les sequences, c'est l'unique |
   |                  | moyen de lier une virgule dans une sequence de      |
   |                  | touches.                                            |
   |------------------+-----------------------------------------------------|
   | command          | Touche Retour Arriere.                              |
   |------------------+-----------------------------------------------------|
   | copy             | Touche Copier.                                      |
   |------------------+-----------------------------------------------------|
   | delete           | Touche Supprime.                                    |
   |------------------+-----------------------------------------------------|
   | delete_line      | Touche << delete line >>.                           |
   |------------------+-----------------------------------------------------|
   | down             | Touche fleche << bas >>.                            |
   |------------------+-----------------------------------------------------|
   | end              | Touche Fin.                                         |
   |------------------+-----------------------------------------------------|
   | entry            | Touche Entree.                                      |
   |------------------+-----------------------------------------------------|
   | exit             | Touche Sortie (<< Exit >>).                         |
   |------------------+-----------------------------------------------------|
   | f1, f2, ..., f10 | Les touches F1 `a F10.                              |
   |------------------+-----------------------------------------------------|
   | find             | Touche Recherche.                                   |
   |------------------+-----------------------------------------------------|
   | home             | Touche Origine.                                     |
   |------------------+-----------------------------------------------------|
   | insert           | Touche Inserer.                                     |
   |------------------+-----------------------------------------------------|
   | insert_exit      | Touche << insert exit >>.                           |
   |------------------+-----------------------------------------------------|
   | clear            | Touche << clear >>.                                 |
   |------------------+-----------------------------------------------------|
   | clear_eol        | Touche << clear to end of line >>.                  |
   |------------------+-----------------------------------------------------|
   | clear_eos        | Touche << clear to end of screen >>.                |
   |------------------+-----------------------------------------------------|
   | insert_line      | Touche << insert line >>.                           |
   |------------------+-----------------------------------------------------|
   | left             | Touche fleche << gauche >>.                         |
   |------------------+-----------------------------------------------------|
   | mark             | Touche Mark.                                        |
   |------------------+-----------------------------------------------------|
   | message          | Touche Message.                                     |
   |------------------+-----------------------------------------------------|
   | move             | Touche Move.                                        |
   |------------------+-----------------------------------------------------|
   | next             | Touche Suivant.                                     |
   |------------------+-----------------------------------------------------|
   | open             | Touche Open.                                        |
   |------------------+-----------------------------------------------------|
   | previous         | Touche Precedent.                                   |
   |------------------+-----------------------------------------------------|
   | print            | Touche Imprimer.                                    |
   |------------------+-----------------------------------------------------|
   | redo             | Touche Refaire.                                     |
   |------------------+-----------------------------------------------------|
   | reference        | Touche Reference.                                   |
   |------------------+-----------------------------------------------------|
   | refresh          | Touche Refresh.                                     |
   |------------------+-----------------------------------------------------|
   | replace          | Touche Replace.                                     |
   |------------------+-----------------------------------------------------|
   | restart          | Touche Restart.                                     |
   |------------------+-----------------------------------------------------|
   | resume           | Touche Resume.                                      |
   |------------------+-----------------------------------------------------|
   | return           | Touche Retour.                                      |
   |------------------+-----------------------------------------------------|
   | right            | Touche fleche << droite >>.                         |
   |------------------+-----------------------------------------------------|
   | save             | Touche Save.                                        |
   |------------------+-----------------------------------------------------|
   | scrollf          | Touche << scroll forward >>.                        |
   |------------------+-----------------------------------------------------|
   | scrollr          | Touche << scroll backward >>.                       |
   |------------------+-----------------------------------------------------|
   | select           | Touche Select.                                      |
   |------------------+-----------------------------------------------------|
   | suspend          | Touche Suspend.                                     |
   |------------------+-----------------------------------------------------|
   | pagedown         | Touche << Page Suivante >>.                         |
   |------------------+-----------------------------------------------------|
   | pageup           | Touche << Page Precedente >>.                       |
   |------------------+-----------------------------------------------------|
   | space            | Touche Espace.                                      |
   |------------------+-----------------------------------------------------|
   | tab              | Touche Tab.                                         |
   |------------------+-----------------------------------------------------|
   | undo             | Touche Annuler.                                     |
   |------------------+-----------------------------------------------------|
   | up               | Touche fleche << haut >>.                           |
   +------------------------------------------------------------------------+

   In addition to binding keys globally, it is possible to change key
   bindings for one particular part (or domain) of aptitude: for instance, to
   make Tab the equivalent of the right arrow key in menu bars, set
   Aptitude::UI::Keybindings::Menubar::Right to << tab,right >>. The
   following domains are available:

   +------------------------------------------------------------------------+
   |    Domaine    |                      Description                       |
   |---------------+--------------------------------------------------------|
   |               | Utilise par les boites de saisie de texte, comme le    |
   | EditLine      | champ de saisie de la boite de dialogue de             |
   |               | << recherche >>.                                       |
   |---------------+--------------------------------------------------------|
   | Menu          | Utilise par les onglets de menus.                      |
   |---------------+--------------------------------------------------------|
   | Menubar       | Utilise par la barre de menu du haut de l'ecran.       |
   |---------------+--------------------------------------------------------|
   | Minesweeper   | Utilise par le mode demineur.                          |
   |---------------+--------------------------------------------------------|
   |               | Utilise par les questions `a choix multiples qui       |
   | MinibufChoice | apparaissent si vous avez choisi de voir des questions |
   |               | apparaitre dans la ligne d'etat.                       |
   |---------------+--------------------------------------------------------|
   | Pager         | Utilise pour afficher un fichier present sur le disque |
   |               | (par exemple, le fichier texte d'aide).                |
   |---------------+--------------------------------------------------------|
   |               | Utilise par les paquets, les arborescences de paquets, |
   | PkgNode       | les versions et les dependances de paquets quand ils   |
   |               | apparaissent dans des listes de paquets.               |
   |---------------+--------------------------------------------------------|
   | PkgTree       | Utilise par les listes de paquets.                     |
   |---------------+--------------------------------------------------------|
   | Table         | Utilise par les presentations d'objets graphiques (par |
   |               | exemple, les boites de dialogue).                      |
   |---------------+--------------------------------------------------------|
   | TextLayout    | Utilise par les affichages formates de texte, tels que |
   |               | les descriptions de paquets.                           |
   |---------------+--------------------------------------------------------|
   |               | Utilise par tous les affichages d'arborescence (dont   |
   | Tree          | les listes de paquets pour lesquelles PkgTree reste    |
   |               | preponderant).                                         |
   +------------------------------------------------------------------------+

  Personnaliser la couleur du texte et les styles

   Les couleurs et les styles visuels utilises par aptitude pour l'affichage
   peuvent etre personnalisees. Chaque element visuel a un << style >>
   associe qui decrit les couleurs et caracteristiques visuelles
   particulieres qui sont utilisees pour l'afficher. Les styles prennent la
   forme d'une liste des parametres de couleurs et de caracteristiques. Cette
   liste n'est pas necessairement exhaustive, si des couleurs ou
   caracteristiques ne sont pas specifiees explicitement, leur valeur est
   prise du contexte d'affichage environnant. En fait, la plupart des
   elements visuels possedent un style << vide >> par defaut.

   Vous pouvez changer le contenu d'un style en creant un groupe de
   configuration du meme nom dans le fichier de configuration d'apt ou
   d'aptitude. Par exemple, le style << MenuBorder >> est utilise pour
   dessiner la bordure autour des menus deroulants. Par defaut, cette bordure
   est bleue sur blanc en gras. Mettre le texte suivant dans le fichier de
   configuration va le changer en blanc sur cyan :

 Aptitude::UI::Styles {
   MenuBorder {fg white; bg cyan; set bold;};
 };

   Comme vous pouvez le voir, un groupe de configuration de style consiste en
   une sequence d'instructions. Les categories generales des instructions
   sont :

   fg couleur

           Utilise la couleur donnee pour le texte actif. Une liste des
           couleurs acceptees par aptitude est disponible ci-dessous.

   bg couleur

           Utilise la couleur donnee pour le texte inactif. Une liste des
           couleurs acceptees par aptitude est disponible ci-dessous.

   set attribut

           Active l'attribut de texte donne. Une liste des attributs de texte
           acceptes par aptitude est disponible ci-dessous.

   clear attribut

           Desactive l'attribut de texte donne. Une liste des attributs de
           texte acceptes par aptitude est disponible ci-dessous.

   flip attribut

           Inverse l'etat de l'attribut de texte donne : s'il est active dans
           l'element environnant, il sera desactive et inversement. Une liste
           des attributs de texte acceptes par aptitude est disponible
           ci-dessous.

   The colors that aptitude recognizes are black, blue, cyan, green, magenta,
   red, white, and yellow ^[20]. In addition, you may specify default in
   place of a background color to use the default terminal background (this
   could be the default color, an image file, or even << transparent >>). The
   styles that aptitude recognizes are:

   blink

           Active le clignotement du texte.

   bold

           Rend la couleur du texte du premier plan (ou d'arriere plan si la
           video inverse est activee) plus claire.

   dim

           Peut entrainer le texte `a etre plus estompe sur certains
           terminaux. Aucun effet n'a ete observe sur les terminaux Linux
           usuels.

   reverse

           Inverse les couleurs d'avant et arriere plan. Beaucoup d'elements
           visuels utilisent cet attribut pour faire des effets de
           surbrillance.

   standout

           Active le << meilleur mode de surbrillance du terminal >>. Dans
           les xterms, c'est comparable, mais pas totalement identique `a la
           video inverse. Le comportement des autres terminaux peut varier.

   underline

           Active le soulignement du texte.

   Vous pouvez selectionner plusieurs de ces attributs en une fois en les
   separant par des virgules. Par exemple, vous pourriez utiliser set
   bold,standout;.

   [Note] Note
          Comme signale ci-dessus, l'interpretation des styles et des
          attributs de texte est hautement dependant du terminal. Il vous
          faudra certainement experimenter un peu pour trouver ce que
          certains parametrages font dans votre terminal.

   Les styles suivants peuvent etre personnalises dans aptitude :

   Figure 2.14. Styles personnalisables dans aptitude

  +----------------------------------------------------------------------------+
  |          Style           |  Valeur par   |           Description           |
  |                          |    defaut     |                                 |
  |--------------------------+---------------+---------------------------------|
  |Bullet                    |fg yellow; set |Style des puces dans les listes  |
  |                          |bold;          |`a puces.                        |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Style des nouvelles versions du  |
  |                          |               |paquet dans la vue affichant la  |
  |                          |               |liste de modification du paquet. |
  |                          |               |aptitude ne mettra en            |
  |ChangelogNewerVersion     |set bold;      |surbrillance les nouvelles       |
  |                          |               |versions du paquet que si vous   |
  |                          |               |avez le paquet                   |
  |                          |               |libparse-debianchangelog-perl    |
  |                          |               |installe.                        |
  |--------------------------+---------------+---------------------------------|
  |Default                   |fg white; bg   |Style de base de l'ecran.        |
  |                          |black;         |                                 |
  |--------------------------+---------------+---------------------------------|
  |DepBroken                 |fg black; bg   |Style des dependances non        |
  |                          |red;           |satisfaites.                     |
  |--------------------------+---------------+---------------------------------|
  |                          |fg black; bg   |Style des entrees de menu qui    |
  |DisabledMenuEntry         |blue; set dim; |sont desactivees et qui ne       |
  |                          |               |peuvent pas etre utilisees.      |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Style utilise pour indiquer qu'un|
  |                          |fg black; bg   |fichier a ete << atteint >>,     |
  |DownloadHit               |green;         |c'est-`a-dire, qu'il n'a pas     |
  |                          |               |change depuis la derniere fois   |
  |                          |               |qu'il a ete telecharge.          |
  |--------------------------+---------------+---------------------------------|
  |DownloadProgress          |fg blue; bg    |Style de la barre de progression |
  |                          |yellow;        |d'un telechargement.             |
  |--------------------------+---------------+---------------------------------|
  |                          |fg white; bg   |Style d'une ligne editable (par  |
  |EditLine                  |black; clear   |exemple la zone d'entree dans la |
  |                          |reverse;       |boite de dialogue de recherche). |
  |--------------------------+---------------+---------------------------------|
  |Error                     |fg white; bg   |Style des messages d'erreur.     |
  |                          |red; set bold; |                                 |
  |--------------------------+---------------+---------------------------------|
  |Header                    |fg white; bg   |Style du haut de l'ecran.        |
  |                          |blue; set bold;|                                 |
  |--------------------------+---------------+---------------------------------|
  |                          |fg white; bg   |Style du nom du menu actuellement|
  |HighlightedMenuBar        |blue; set      |selectionne dans la barre de     |
  |                          |bold,reverse;  |menu.                            |
  |--------------------------+---------------+---------------------------------|
  |                          |fg white; bg   |Style de choix actuellement      |
  |HighlightedMenuEntry      |blue; set      |selectionne dans un menu.        |
  |                          |bold,reverse;  |                                 |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Style de la boite de dialogue    |
  |MediaChange               |fg yellow; bg  |utilisee pour demander `a        |
  |                          |red; set bold; |l'utilisateur d'inserer un autre |
  |                          |               |CD.                              |
  |--------------------------+---------------+---------------------------------|
  |MenuBar                   |fg white; bg   |Style de la barre de menu.       |
  |                          |blue; set bold;|                                 |
  |--------------------------+---------------+---------------------------------|
  |MenuBorder                |fg white; bg   |Style de la bordure entourant un |
  |                          |blue; set bold;|menu deroulant.                  |
  |--------------------------+---------------+---------------------------------|
  |MenuEntry                 |fg white; bg   |Style de chaque entree d'un menu |
  |                          |blue;          |deroulant.                       |
  |--------------------------+---------------+---------------------------------|
  |MineBomb                  |fg red; set    |Style des bombes dans le         |
  |                          |bold;          |demineur.                        |
  |--------------------------+---------------+---------------------------------|
  |MineBorder                |set bold;      |Style de la bordure d'un tableau |
  |                          |               |du demineur.                     |
  |--------------------------+---------------+---------------------------------|
  |MineFlag                  |fg red; set    |Style des drapeaux dans le       |
  |                          |bold;          |demineur.                        |
  |--------------------------+---------------+---------------------------------|
  |MineNumberN               |Varies         |Style du nombre N dans le        |
  |                          |               |demineur. N est entre 0 et 8.    |
  |--------------------------+---------------+---------------------------------|
  |                          |fg white; bg   |Couleur utilisee pour afficher   |
  |MultiplexTab              |blue;          |les << onglets >> autres que     |
  |                          |               |celui actuellement selectionne.  |
  |--------------------------+---------------+---------------------------------|
  |                          |fg blue; bg    |Couleur utilisee pour afficher   |
  |MultiplexTabHighlighted   |white;         |l'<< onglet >> actuellement      |
  |                          |               |selectionne.                     |
  |--------------------------+---------------+---------------------------------|
  |                          |fg red; flip   |Dans la liste des paquets, style |
  |PkgBroken                 |reverse;       |des paquets qui ont des          |
  |                          |               |dependances non satisfaites.     |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Dans la liste des paquets, style |
  |PkgBrokenHighlighted      |fg red;        |des paquets en surbrillance qui  |
  |                          |               |ont des dependances non          |
  |                          |               |satisfaites.                     |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Style des paquets qui ne sont pas|
  |PkgNotInstalled           |               |actuellement installes et qu'il  |
  |                          |               |n'est pas prevu d'installer.     |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Style des paquets en surbrillance|
  |PkgNotInstalledHighlighted|               |qui ne sont pas actuellement     |
  |                          |               |installes et qu'il n'est pas     |
  |                          |               |prevu d'installer.               |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Style des paquets qui sont       |
  |PkgIsInstalled            |set bold;      |actuellement installes et sur    |
  |                          |               |lesquels aucune action n'est     |
  |                          |               |prevu.                           |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Style des paquets en surbrillance|
  |PkgIsInstalledHighlighted |set bold; flip |qui sont actuellement installes  |
  |                          |reverse;       |et sur lesquels aucune action    |
  |                          |               |n'est prevu.                     |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Dans la liste des paquets, style |
  |PkgToDowngrade            |set bold;      |des paquets qu'il est prevu de   |
  |                          |               |mettre `a jour.                  |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Dans la liste des paquets, style |
  |PkgToDowngradeHighlighted |set bold; flip |des paquets en surbrillance qu'il|
  |                          |reverse        |est prevu de mettre `a une       |
  |                          |               |version anterieure.              |
  |--------------------------+---------------+---------------------------------|
  |PkgToHold                 |fg white; flip |Dans la liste des paquets, style |
  |                          |reverse;       |des paquets qui sont geles.      |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Dans la liste des paquets, style |
  |PkgToHoldHighlighted      |fg white;      |des paquets en surbrillance qui  |
  |                          |               |sont geles.                      |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Dans la liste des paquets, style |
  |PkgToInstall              |fg green; flip |des paquets qu'il est prevu      |
  |                          |reverse;       |d'installer (pas de mettre `a    |
  |                          |               |jour) ou de reinstaller.         |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Dans la liste des paquets, style |
  |                          |               |des paquets en surbrillance qu'il|
  |PkgToInstallHighlighted   |fg green;      |est prevu d'installer (pas de    |
  |                          |               |mettre `a jour) ou de            |
  |                          |               |reinstaller.                     |
  |--------------------------+---------------+---------------------------------|
  |                          |fg magenta;    |Dans la liste des paquets, style |
  |PkgToRemove               |flip reverse;  |des paquets qu'il est prevu de   |
  |                          |               |supprimer ou de purger.          |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Dans la liste des paquets, style |
  |PkgToRemoveHighlighted    |fg magenta;    |des paquets en surbrillance qu'il|
  |                          |               |est prevu de supprimer ou de     |
  |                          |               |purger.                          |
  |--------------------------+---------------+---------------------------------|
  |                          |fg cyan; flip  |Dans la liste des paquets, style |
  |PkgToUpgrade              |reverse;       |des paquets qu'il est prevu de   |
  |                          |               |mettre `a jour.                  |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Dans la liste des paquets, style |
  |PkgToUpgradeHighlighted   |fg cyan;       |des paquets qu'il est prevu de   |
  |                          |               |mettre `a jour.                  |
  |--------------------------+---------------+---------------------------------|
  |                          |               |Style de l'indicateur            |
  |Progress                  |fg blue; bg    |d'avancement tel que celui qui   |
  |                          |yellow;        |apparait lors du chargement du   |
  |                          |               |cache des paquets.               |
  |--------------------------+---------------+---------------------------------|
  |SolutionActionApproved    |bg green;      |Style des solutions approuvees   |
  |                          |               |dans une solution.               |
  |--------------------------+---------------+---------------------------------|
  |SolutionActionRejected    |bg red;        |Style des solutions rejetees dans|
  |                          |               |une solution.                    |
  |--------------------------+---------------+---------------------------------|
  |Status                    |fg white; bg   |Style de la ligne d'etat en bas  |
  |                          |blue; set bold;|de l'ecran.                      |
  |--------------------------+---------------+---------------------------------|
  |TreeBackground            |               |Couleur de base de toutes les    |
  |                          |               |listes et arbres visuels.        |
  |--------------------------+---------------+---------------------------------|
  |                          |fg red; bg     |Couleur utilisees pour afficher  |
  |TrustWarning              |black; set     |les avertissements concernant les|
  |                          |bold;          |paquets de confiance.            |
  +----------------------------------------------------------------------------+

  Personnaliser la disposition de l'affichage

   Il est possible de reordonner la liste des paquets d'aptitude en apportant
   les modifications appropriees au fichier de configuration.

    Display elements

   La disposition est conservee dans le groupe de configuration
   Aptitude::UI::Default-Package-View et consiste en une liste d'elements
   d'affichage :

 Name Type {
   Row row;
   Column column;
   Width width;
   Height height;

   additional options...
 };

   Cela cree un element d'affichage nomme Nom dont le type est donne par
   Type. Les options Row, Column, Width et Height doivent etre presentes.
   Elles determinent ou l'element d'affichage est situe. Voyez ci-dessous
   pour une explication detaillee sur la maniere dont les elements
   d'affichage sont disposes.

   Vous trouverez des exemples concernant la maniere de modifier la
   disposition de l'affichage en consultant la definition du theme par defaut
   dans le fichier /usr/share/aptitude/aptitude-defaults.

   Les types d'elements d'affichage suivants sont disponibles :

   Description

           Cet element d'affichage contient la << zone d'information >>
           (typiquement une description du paquet actuellement selectionne).

           L'option PopUpDownKey donne le nom d'une commande clavier qui va
           montrer ou cacher l'element d'affichage. Par exemple, mettre cette
           option `a ShowHideDescription va donner `a l'element d'affichage
           actuel le meme comportement que celui par defaut pour la zone
           d'information. L'option PopUpDownLinked donne le nom d'un autre
           element d'affichage ; l'element courant sera montre ou cache `a
           chaque fois que l'autre element le sera.

   MainWidget

           C'est une reference `a l'element d'affichage << principal >> :
           typiquement c'est une liste de paquets. Une disposition
           d'affichage doit contenir exactement un element MainWidget : pas
           un de plus, pas un de moins.

   Static

           Zone de l'ecran qui affiche du texte ; elle peut contenir du code
           formate tel que decrit dans la section intitulee << Personnaliser
           la maniere d'afficher les paquets >>. Le texte `a afficher peut
           etre donne dans l'option Columns, ou etre stocke dans la variable
           specifiee par l'option ColumnsCfg. La couleur du texte est
           determinee par le nom de la couleur passe `a l'option Color.

           Les objets Static peuvent etre affiches et caches de la meme
           maniere que les objets Description en utilisant les options
           PopUpDownKey et PopUpDownLinked.

    Placement des elements d'affichage

   Les elements d'affichage sont disposes dans une << table >>. Le coin
   superieur gauche d'un element est dans la cellule donnee par les options
   Row et Column (commenc,ant habituellement `a la ligne 0 et la colonne 0
   bien que ce ne soit pas obligatoire). La largeur d'un element en cellule
   est donnee par son option Width, et sa hauteur est donnee par son option
   Height.

   Une fois que l'element d'affichage est dispose et qu'il a rec,u une
   etendue initiale `a l'ecran, il est possible qu'il reste de l'espace. S'il
   y a de l'espace libre verticalement chaque ligne contenant un element
   d'affichage dont l'option RowExpand est `a true se verra allouer une
   partie de l'espace libre. De fac,on analogue, s'il y a de l'espace libre
   horizontalement, chaque colonne contenant un element d'affichage dont
   l'option ColExpand est `a true se verra allouer une partie de l'espace
   libre.

   Dans le cas ou il n'y a pas assez d'espace, chaque ligne ou colonne dont
   tous les objets ont leurs options RowShrink ou ColShrink `a true sera
   retrecie. S'il n'y en a pas assez, toutes les lignes et colonnes sont
   reduites pour s'ajuster `a l'espace disponible.

   Si un element d'affichage n'est pas agrandi, mais ses lignes ou colonnes
   le sont, son alignement est determine par les options RowAlign et
   ColAlign. Les configurer `a Left (gauche), Right (droite), Top (haut),
   Bottom (bas), ou Center (centre) va indiquer `a aptitude ou placer
   l'element verticalement et horizontalement.

   Par exemple, le groupe de configuration suivant cree un element statique
   nomme << Header >> qui est large de trois cellules et qui s'agrandit
   horizontalement mais pas verticalement. Il a la meme couleur que les
   autres lignes d'en-tete et utilise le format standard des lignes
   d'en-tete :

 Header Static {
   Row 0;
   Column 0;
   Width 3;
   Height 1;

   ColExpand true;
   ColAlign Center;

   RowAlign Center;

   Color ScreenHeaderColor;
   ColumnsCfg HEADER;
 };

    Reference des options de la disposition de l'affichage

   Les options suivantes sont disponibles pour les elements d'affichage :

   ColAlign alignement;

           Alignement doit etre Left (gauche), Right (droite), ou Center
           (centre). Si la ligne contenant l'element d'affichage courant est
           plus large que l'element lui-meme et que ColExpand est false,
           l'element sera place dans la ligne selon la valeur alignement.

           Si cette option est absente, la valeur par defaut est Left.

   ColExpand true|false;

           Si cette option est mise `a true (vrai), la colonne contenant
           l'element d'affichage se verra allouer une partie de l'espace
           horizontal libre qui serait disponible.

           Si cette option est absente, la valeur par defaut est false
           (faux).

   Color couleur;

           Cette option s'applique `a l'element Static. Couleur est le nom
           d'une couleur (par exemple, ScreenStatusColor) qui devrait etre
           utilise comme couleur par defaut pour afficher l'element
           d'affichage.

           Si cette option est absente, la valeur par defaut est
           DefaultWidgetBackground.

   ColShrink true|false;

           Si cette option est mise `a true sur chaque element d'une colonne
           et qu'il n'y a pas assez d'espace horizontal, la colonne sera
           retrecie autant qu'il faut pour rentrer dans l'espace disponible.
           Remarquez qu'une colonne peut etre retrecie meme si ColShrink est
           false ; cela indique simplement qu'aptitude devrait essayer de
           reduire une colonne particuliere avec les autres.

           Si cette option est absente, la valeur par defaut est false
           (faux).

   Column colonne;

           Specifie la colonne la plus `a gauche pouvant contenir cet element
           d'affichage.

   Columns format;

           Cette option s'applique aux elements d'affichage Static pour
           lesquels l'option ColumnsCfg n'est pas configuree. Elle configure
           le contenu de l'affichage de la ligne d'etat. C'est une chaine de
           format comme decrit dans la section intitulee << Personnaliser la
           maniere d'afficher les paquets >>.

   ColumnsCfg HEADER|STATUS|nom;

           Cette option s'applique aux elements d'affichage Static. Il
           configure le format d'affichage de l'element courant `a la valeur
           d'une autre variable de configuration. Si c'est HEADER ou STATUS,
           les options, respectivement, Aptitude::UI::Package-Header-Format
           et Aptitude::UI::Package-Status-Format, sont utilisees. Sinon
           l'option nom est utilisee.

           Si cette option est absente, la valeur de l'option Columns est
           utilisee pour controler le contenu de l'element statique.

   Height hauteur;

           Specifie la hauteur de l'element d'affichage courant.

   PopUpDownKey commande;

           Cette option s'applique aux elements d'affichage Description et
           Static.

           Commande est le nom d'une commande clavier (par exemple,
           ShowHideDescription). Quand cette sequence de touches est pressee,
           l'element d'affichage est cache s'il est visible et affiche s'il
           est cache.

   PopUpDownLinked element;

           Cette option s'applique aux elements d'affichage Description et
           Static.

           element est le nom d'un element d'affichage. Quand element est
           affiche, l'element courant sera affiche lui aussi et quand element
           est cache, l'element courant sera cache lui aussi.

   Row ligne;

           Specifie la ligne se trouvant placee le plus haut et pouvant
           contenir cet element d'affichage.

   RowAlign alignement;

           alignement doit etre Top (haut), Bottom (bas) ou Center (centre).
           Si la ligne contenant l'element d'affichage courant est plus haute
           que l'element lui-meme et que RowExpand est false, l'element sera
           place dans la ligne selon la valeur alignement.

           Si cette option est absente, la valeur de l'option est Top.

   RowExpand true|false;

           Si cette option est mise `a true (vrai), la ligne contenant
           l'element d'affichage se verra allouer une partie de l'espace
           horizontal libre qui serait disponible.

           Si cette option est absente, la valeur par defaut est false
           (faux).

   RowShrink true|false;

           Si cette option est mise `a true sur chaque element d'une ligne,
           et s'il n'y a pas assez d'espace horizontal, la ligne sera
           retrecie autant qu'il faut pour rentrer dans l'espace disponible.
           Remarquez qu'une ligne peut etre retrecie meme si RowShrink est
           false ; cela indique simplement qu'aptitude devrait essayer de
           reduire une ligne particuliere avec les autres.

           Si cette option est absente, la valeur par defaut est false
           (faux).

   Visible true|false;

           Configure `a false (faux), cet element d'affichage sera
           initialement cache. Ce n'est probablement utile que combine avec
           PopUpDownKey et/ou PopUpDownLinked.

           Si cette option est absente, la valeur de l'option est true.

   Width largeur;

           Specifie la largeur de l'element d'affichage courant.

  Reference du fichier de configuration

    Format du fichier de configuration

   Basiquement, le fichier de configuration d'aptitude est une liste de
   couples d'options et de leurs valeurs. Chaque ligne du fichier devrait
   avoir la forme << Option Valeur; >> : par exemple, dans le fichier de
   configuration, la ligne suivante met l'option Aptitude::Theme `a
   << Dselect >>.

 Aptitude::Theme "Dselect";

   Une option peut << contenir >> d'autres options si elles sont ecrites
   entre accolades placees entre l'option et le point-virgule qui la suit,
   comme ceci :

 Aptitude::UI {
   Package-Status-Format "";
   Package-Display-Format "";
 };

   Une option qui contient d'autres options est parfois appelee groupe. En
   fait, le deux-points double, qui apparait dans les noms d'options est une
   maniere simplifiee pour indiquer l'inclusion : l'option
   Aptitude::UI::Default-Grouping est contenu dans le groupe Aptitude::UI,
   qui est lui-meme dans le groupe Aptitude. Ainsi, si vous le souhaitez,
   vous pourriez configurer cette option `a "" comme cela :

 Aptitude {
   UI {
     Default-Grouping "";
   };
 };

   Pour plus d'informations sur le format du fichier de configuration,
   consultez la page de manuel apt.conf(5).

    Emplacement des fichiers de configuration

   La configuration d'aptitude est lue, dans l'ordre, depuis les sources
   suivantes :

    1. Le fichier de configuration de l'utilisateur, ~/.aptitude/config. Ce
       fichier est ecrase lorsque l'utilisateur modifie la configuration dans
       le menu Options.

    2. Le fichier de configuration du systeme, /etc/apt/apt.conf.

    3. Les valeurs par defaut conservees dans
       /usr/share/aptitude/aptitude-defaults.

    4. Default values built into aptitude.

   Quand une option est evaluee, ces sources sont consultees dans l'ordre, et
   la premiere qui fournit une valeur pour l'option est utilisee. Par
   exemple, configurer une option dans /etc/apt/apt.conf va ecraser la valeur
   par defaut d'aptitude pour cette option, mais cela n'ecrasera pas la
   configuration de l'utilisateur dans ~/.aptitude/config.

    Options de configuration disponibles

   Les options de configuration suivantes sont utilisees par aptitude. Notez
   que ce ne sont pas les seules options de configuration disponibles ; les
   options utilisees par le systeme apt sous-jacent ne sont pas listees ici.
   Consultez les pages de manuel apt(8) et apt.conf(5) pour les informations
   sur les options d'apt.

   Option: Apt::AutoRemove::RecommendsImportant
   Valeur par defaut: true
   Description: If this option is true, then aptitude will not consider
   packages to be unused (and thus will not automatically remove them) as
   long as any installed package recommends them, even if
   Apt::Install-Recommends is false. For more information, see la section
   intitulee << Gerer les paquets automatiquement installes >>.
   Option: Apt::AutoRemove::SuggestsImportant
   Valeur par defaut: false
   Description: Si cette option est mise `a true, aptitude ne considerera pas
   les paquets comme inutilises (et donc ne les retirera pas automatiquement)
   tant qu'un paquet installe les suggere. Pour plus d'informations,
   consultez la section intitulee << Gerer les paquets automatiquement
   installes >>.
   Option: Apt::Get::List-Cleanup
   Valeur par defaut: true
   Description: A synonym for Apt::List-Cleanup. If either of these options
   is set to false, aptitude will not delete old package list files after
   downloading a new set of package lists.
   Option: Apt::List-Cleanup
   Valeur par defaut: true
   Description: A synonym for Apt::Get::List-Cleanup. If either of these
   options is set to false, aptitude will not delete old package list files
   after downloading a new set of package lists.
   Option: Apt::Install-Recommends
   Valeur par defaut: true
   Description: If this option is true and Aptitude::Auto-Install is true,
   then whenever you mark a package for installation, aptitude will also mark
   the packages it recommends for installation. Furthermore, if this option
   is true, aptitude will not consider packages to be unused (and thus will
   not automatically remove them) as long as any installed package reommends
   them. For more information, see la section intitulee << Gerer les paquets
   automatiquement installes >> and la section intitulee << Immediate
   dependency resolution >>.
   Option: Aptitude::Allow-Null-Upgrade
   Valeur par defaut: false
   Description: Normalement, si vous essayez de demarrer un processus
   d'installation alors qu'aucune action n'est prevue, aptitude affiche un
   avertissement et revient `a la liste des paquets. Si cette option est
   true, aptitude affichera l'aperc,u d'installation, meme s'il y a des
   paquets pouvant etre mis `a jour, plutot qu'afficher un rappel concernant
   la commande Actions -> Marquer comme etant susceptible de mise `a jour
   (U).
   Option: Aptitude::Always-Use-Safe-Resolver
   Valeur par defaut: false
   Description: If this option is true, aptitude's command-line actions will
   always use a << safe >> dependency resolver, as if --safe-resolver had
   been passed on the command line.
   Option: Aptitude::Autoclean-After-Update
   Valeur par defaut: false
   Description: Si cette option est mise `a true, aptitude fera le menage
   parmi les fichiers obsoletes (consultez Actions -> Enlever les fichiers
   perimes) `a chaque mise `a jour de la liste des paquets.
   Option: Aptitude::Auto-Fix-Broken
   Valeur par defaut: true
   Description: Si cette option est mise `a false, aptitude demandera la
   permission avant de tenter de corriger un paquet casse.
   Option: Aptitude::Auto-Install
   Valeur par defaut: true
   Description: If this option is true, aptitude will automatically attempt
   to fulfill the dependencies of a package when you mark a package to be
   installed or upgraded.
   Option: Aptitude::Auto-Install-Remove-Ok
   Valeur par defaut: false
   Description: If this option is true, aptitude will automatically remove
   conflicting packages when you mark a package to be installed or upgraded.
   Normally these conflicts are flagged and you must handle them manually.
   Option: Aptitude::Auto-Upgrade
   Valeur par defaut: false
   Description: Si cette option est mise `a true, aptitude marquera
   automatiquement tous les paquets pouvant etre mis `a jour pour qu'ils le
   soient au demarrage du programme, comme si vous aviez execute la commande
   Actions -> Marquer comme etant susceptible de mise `a jour (U).
   Option: Aptitude::CmdLine::Always-Prompt
   Valeur par defaut: false
   Description: En mode ligne de commande, si cette option est `a << true >>,
   aptitude demandera toujours confirmation avant de commencer `a installer
   ou supprimer des paquets, meme si la confirmation aurait normalement ete
   sautee. C'est equivalent `a l'option -P de la ligne de commande.
   Option: Aptitude::CmdLine::Assume-Yes
   Valeur par defaut: false
   Description: En mode ligne de commande, si cette option est `a << true >>,
   aptitude agira comme si l'utilisateur repondait << oui >> `a chaque
   invite, causant le saut de la plupart des questions. C'est equivalent `a
   l'option -y de la ligne de commande.
   Option: Aptitude::CmdLine::Disable-Columns
   Valeur par defaut: false
   Description: If this option is enabled, the results of command-line
   searches (performed via aptitude search) will not be formatted into
   fixed-width columns or truncated to the screen width. This is equivalent
   to the --disable-columns command-line option.
   Option: Aptitude::CmdLine::Download-Only
   Valeur par defaut: false
   Description: En mode ligne de commande, si cette option est `a << true >>,
   aptitude telechargera les paquets sans les installer. C'est equivalent `a
   l'option -d de la ligne de commande.
   Option: Aptitude::CmdLine::Fix-Broken
   Valeur par defaut: false
   Description: En mode ligne de commande, si cette option est `a << true >>,
   aptitude sera plus agressif lorsqu'il tentera de corriger les dependances
   de paquets casses. C'est equivalent `a l'option -f de la ligne de
   commande.
   Option: Aptitude::CmdLine::Versions-Group-By
   Valeur par defaut: Set to auto, none, package, or source-package to
   control whether and how the output of aptitude versions is grouped.
   Equivalent to the command-line option --group-by (see its documentation
   for more description of what the values mean).
   Option: Aptitude::CmdLine::Ignore-Trust-Violations
   Valeur par defaut: false
   Description: In command-line mode, causes aptitude to ignore the
   installation of untrusted packages. This is a synonym for
   Apt::Get::AllowUnauthenticated.
   Option: Aptitude::CmdLine::Package-Display-Format
   Valeur par defaut: %c%a%M %p# - %d#
   Description: C'est une chaine de format, tel que decrit dans la section
   intitulee << Personnaliser la maniere d'afficher les paquets >>, qui est
   utilisee pour afficher le resultat d'une recherche en ligne de commande.
   C'est equivalent `a l'option -F de la ligne de commande.
   Option: Aptitude::CmdLine::Package-Display-Width
   Valeur par defaut:
   Description: Cette option donne la largeur en caracteres avec laquelle les
   resultats des recherches en ligne de commande doivent etre formatees. Une
   chaine vide (la valeur par defaut, c'est-`a-dire "") indique que les
   resultats des recherches sont formates pour la taille du terminal actuel
   ou pour un affichage de 80 colonnes si la taille ne peut pas etre
   determinee.
   Option: Aptitude::CmdLine::Progress::Percent-On-Right
   Valeur par defaut: false
   Description: This option controls whether command-line progress indicators
   display the percentage on the left-hand side of the screen, in the same
   style as apt-get, or on the right-hand side (the default). This option
   does not affect download progress indicators.
   Option: Aptitude::CmdLine::Progress::Retain-Completed
   Valeur par defaut: false
   Description: If this value is false, then command-line progress indicators
   will be deleted and overwritten once the task they represent is completed.
   If it is true, then they will be left on the terminal. This option does
   not affect download progress indicators.
   Option: Aptitude::CmdLine::Request-Strictness
   Valeur par defaut: 10000
   Description: En mode ligne de commande, si des problemes de dependances
   sont rencontres, aptitude ajoutera cette valeur au score, donne par le
   solveur de dependances, de toute action que vous demandez explicitement.
   Option: Aptitude::CmdLine::Resolver-Debug
   Valeur par defaut: false
   Description: En mode ligne de commande, si cette option est `a true,
   aptitude affichera enormement d'informations pendant les tentatives de
   resolutions de dependances cassees. Comme le nom le suggere, c'est option
   est principalement destinee `a aider au debogage du solveur de probleme.
   Option: Aptitude::CmdLine::Resolver-Dump
   Valeur par defaut:
   Description: En mode ligne de commande, s'il est necessaire de resoudre
   des dependances cassees et que cette option contient le nom d'un fichier
   dans lequel il est possible d'ecrire, l'etat du solveur est ecrit dans ce
   fichier avant d'entreprendre toute resolution.
   Option: Aptitude::CmdLine::Resolver-Show-Steps
   Valeur par defaut: false
   Description: Quand cette option est `a true, une solution en dependance
   sera affichee comme une suite de dependances individuelles. Par exemple,
   << wesnoth depends upon wesnoth-data (= 1.2.4-1) -> installing
   wesnoth-data 1.2.4-1 (unstable) >>.
   Option: Aptitude::CmdLine::Safe-Upgrade::No-New-Installs
   Valeur par defaut: false
   Description: In command-line mode, if this option is true, the
   safe-upgrade command will not attempt to resolve dependencies by
   installing new packages. If upgrading package A would require package B to
   be newly installed, package A will not be upgraded. This corresponds to
   the command-line option --no-new-installs.
   Option: Aptitude::CmdLine::Safe-Upgrade::Show-Resolver-Actions
   Valeur par defaut: false
   Description: If this option is enabled, the safe-upgrade command will
   display an explanation of the actions taken by the resolver before showing
   the installation preview. This option is similar to
   Aptitude::Safe-Resolver::Show-Resolver-Actions, but only applies to the
   safe-upgrade command. Equivalent to the command-line option
   --show-resolver-actions.
   Option: Aptitude::CmdLine::Show-Deps
   Valeur par defaut: false
   Description: En mode ligne de commande, si cette option est `a << true >>,
   aptitude affichera un resume des dependances (s'il y en a) liees `a l'etat
   d'un paquet. C'est equivalent `a l'option -D de la ligne de commande.
   Option: Aptitude::CmdLine::Show-Size-Changes
   Valeur par defaut: false
   Description: En mode ligne de commande, si cette option est `a << true >>,
   aptitude affichera les changements attendus de l'espace disque utilise par
   chaque paquet. C'est equivalent `a l'option -Z de la ligne de commande.
   Option: Aptitude::CmdLine::Why-Display-Mode
   Valeur par defaut: no-summary
   Description: This option sets the default value of the command-line
   argument --show-summary. See the documentation of --show-summary for a
   list of the allowed values of this option and their meanings.
   Option: Aptitude::CmdLine::Show-Versions
   Valeur par defaut: false
   Description: En mode ligne de commande, si cette option est `a << true >>,
   aptitude affichera la version d'un paquet qui est sur le point d'etre
   installe ou supprime. C'est equivalent `a l'option -V de la ligne de
   commande.
   Option: Aptitude::CmdLine::Show-Why
   Valeur par defaut: false
   Description: In command-line mode, if this option is true, aptitude will
   display the manually installed packages that require each automatically
   installed package, or the manually installed packages that cause a
   conflict with each automatically removed package. This is equivalent to
   the -W command-line option and displays the same information you can
   access via aptitude why or by pressing i in a package list.
   Option: Aptitude::CmdLine::Version-Display-Format
   Valeur par defaut: %c%a%M %p# %t %i
   Description: This is a format string, as described in la section intitulee
   << Personnaliser la maniere d'afficher les paquets >>, which is used to
   display the output of aptitude versions. This is equivalent to the -F
   command-line option.
   Option: Aptitude::CmdLine::Versions-Show-Package-Names
   Valeur par defaut: Set to always, auto, or never to control when package
   names are displayed in the output of aptitude versions. Equivalent to the
   command-line option --show-package-names (see its documentation for more
   description of what the values mean).
   Option: Aptitude::Safe-Resolver::Show-Resolver-Actions
   Valeur par defaut: false
   Description: If this option is enabled, then when the << safe >>
   dependency resolver has been activated via --safe-resolver, it will
   display a summary of the actions taken by the resolver before showing the
   installation preview. This option is similar to
   Aptitude::Safe-Upgrade::Show-Resolver-Actions, but only applies to
   command-line actions other than safe-upgrade. Equivalent to the
   command-line option --show-resolver-actions.
   Option: Aptitude::Screenshot::IncrementalLoadLimit
   Valeur par defaut: 16384
   Description: The minimum size in bytes at which aptitude will begin to
   display screenshots incrementally. Below this size, screenshots will not
   appear until they are fully downloaded.
   Option: Aptitude::Screenshot::Cache-Max
   Valeur par defaut: 4194304
   Description: The maximum number of bytes of screenshot data that aptitude
   will store in memory for screenshots that are not currently being
   displayed. The default is four megabytes.
   Option: Aptitude::CmdLine::Simulate
   Valeur par defaut: false
   Description: This option is deprecated; use Aptitude::Simulate instead. In
   command-line mode, causes aptitude to just display the actions that would
   be performed (rather than actually performing them); in the visual
   interface, causes aptitude to start in read-only mode regardless of
   whether you are root or not. This is equivalent to the -s command-line
   option.
   Option: Aptitude::CmdLine::Verbose
   Valeur par defaut: 0
   Description: Cette option controle le niveau de verbosite du mode ligne de
   commande d'aptitude. Chaque occurrence de l'option -v sur la ligne de
   commande ajoute 1 `a cette valeur.
   Option: Aptitude::CmdLine::Visual-Preview
   Valeur par defaut: false
   Description: Si cette option est mise `a true, aptitude va entrer dans le
   mode graphique pour afficher l'aperc,u du processus d'installation et pour
   telecharger les paquets.
   Option: Aptitude::Debtags-Binary
   Valeur par defaut: /usr/bin/debtags
   Description: The absolute path to the debtags command. If configured with
   libept support, aptitude will invoke this program whenever the package
   lists are updated, passing it the arguments listed in
   Aptitude::Debtags-Update-Options.
   Option: Aptitude::Debtags-Update-Options
   Valeur par defaut: --local
   Description: Additional options to pass to debtags update when invoking it
   after the package lists are updated. These are split at whitespace; single
   and double-quoted strings are recognized, so setting this to
   << --vocabulary='/file with a space >> will store the debtags vocabulary
   in << /file with a space >>.
   Option: Aptitude::Delete-Unused
   Valeur par defaut: true
   Description: Si cette option est mise `a true, les paquets automatiquement
   installes qui ne sont plus necessaires seront automatiquement supprimes.
   Pour plus d'informations, consultez la section intitulee << Gerer les
   paquets automatiquement installes >>.
   Option: Aptitude::Delete-Unused-Pattern
   Valeur par defaut:
   Description: Obsolete, alias pour Aptitude::Keep-Unused-Pattern. Si
   Aptitude::Keep-Unused-Pattern n'est pas parametree ou parametree avec une
   chaine vide, la valeur de cette option de configuration va la supplanter.
   Sinon Aptitude::Delete-Unused-Pattern est ignoree.
   Option: Aptitude::Display-Planned-Action
   Valeur par defaut: true
   Description: Si cette option est mise `a true, aptitude affichera un
   aperc,u d'installation avant de reellement executer les actions que vous
   avez demandees.
   Option: Aptitude::Forget-New-On-Install
   Valeur par defaut: false
   Description: Si cette option est mise `a true, aptitude videra la liste
   des nouveaux paquets `a chaque fois que vous installez, mettez `a jour ou
   supprimez des paquets, comme si vous aviez execute la commande Actions ->
   Oublier quels paquets sont nouveaux (f).
   Option: Aptitude::Forget-New-On-Update
   Valeur par defaut: false
   Description: Si cette option est mise `a true, aptitude videra la liste
   des nouveaux paquets `a chaque fois que la liste des paquets est mise `a
   jour, comme si vous aviez execute la commande Actions -> Oublier quels
   paquets sont nouveaux (f).
   Option: Aptitude::Get-Root-Command
   Valeur par defaut: su:/bin/su
   Description: This option sets the external command that aptitude will use
   to switch to the root user (see la section intitulee << Devenir
   administrateur (<< root >>) >>). It has the form protocol:command.
   protocol must be either su or sudo; it determines how aptitude invokes the
   program when it wants to gain root privileges. If protocol is su, then
   << command -c arguments >> is used to become root; otherwise, aptitude
   uses << command arguments >>. The first word in command is the name of the
   program that should be invoked; remaining words are treated as arguments
   to that program.
   Option: Aptitude::Ignore-Old-Tmp
   Valeur par defaut: false
   Description: Les anciennes versions d'aptitude creaient un repertoire
   ~/.aptitude/.tmp qui n'est plus necessaire. Si ce repertoire existe et
   Aptitude::Ignore-Old-Tmp est `a true, aptitude vous demandera s'il faut le
   supprimer. Cette option est automatiquement mis `a true apres que vous
   ayez repondu. D'un autre cote, si ce repertoire n'existe pas, cette option
   est mise `a false et vous en seriez averti si ce repertoire venait `a
   reapparaitre.
   Option: Aptitude::Ignore-Recommends-Important
   Valeur par defaut: false
   Description: In previous versions of aptitude, the setting
   Aptitude::Recommends-Important caused recommendations to be installed
   automatically, the same way that Apt::Install-Recommends does today. If
   this option is set to false and Aptitude::Recommends-Important is also set
   to false, aptitude will set Apt::Install-Recommends to false and set
   Aptitude::Ignore-Recommends-Important to true on startup.
   Option: Aptitude::Keep-Recommends
   Valeur par defaut: false
   Description: This is an obsolete option; use
   Apt::AutoRemove::Recommends-Important instead. Setting this option to true
   has the same effect as setting Apt::AutoRemove::Recommends-Important to
   true.
   Option: Aptitude::Keep-Suggests
   Valeur par defaut: false
   Description: This is an obsolete option; use
   Apt::AutoRemove::Suggests-Important instead. Setting this option to true
   has the same effect as setting Apt::AutoRemove::Suggests-Important to
   true.
   Option: Aptitude::Keep-Unused-Pattern
   Valeur par defaut:
   Description: Si Aptitude::Delete-Unused est `a true, seul les paquets
   inutilises qui ne correspondent pas `a ce motif (voir la section intitulee
   << Search patterns >>) seront supprimes. Si cette option est configuree
   avec une chaine vide (valeur par defaut), tous les paquets inutilises sont
   supprimes.
   Option: Aptitude::LockFile
   Valeur par defaut: /var/lock/aptitude
   Description: A file that will be fcntl-locked to ensure that at most one
   aptitude process can modify the cache at once. In normal circumstances,
   you should never need to modify this; it may be useful for debugging.
   Note: if aptitude complains that it cannot acquire a lock, this is not
   because the lock file needs to be deleted. fcntl locks are managed by the
   kernel and will be destroyed when the program holding them terminates;
   failure to acquire the lock means that another running program is using
   it!
   Option: Aptitude::Log
   Valeur par defaut: /var/log/aptitude
   Description: Si cette option est une chaine non vide, aptitude
   journalisera les installations, suppressions et mises `a jour de paquets
   qu'il effectue. Si la valeur de Aptitude::Log commence par le caractere
   << | >>, le reste de cette valeur est utilise comme nom d'une commande `a
   travers laquelle le journal est envoye : par exemple, |mail -s 'Aptitude
   install run' root enverra le journal au compte root. Pour journaliser dans
   plusieurs fichiers ou commandes, vous pouvez configurer cette option sous
   la forme d'une liste de cibles pour la journalisation.
   Option: Aptitude::Logging::File
   Valeur par defaut:
   Description: If this is set to a nonempty string, aptitude will write
   logging messages to it; setting it to << - >> causes logging messages to
   be printed to standard output. This differs from the setting
   Aptitude::Log: that file is used to log installations and removals,
   whereas this file is used to log program events, errors, and debugging
   messages (if enabled). This option is equivalent to the command-line
   argument --log-file. See also Aptitude::Logging::Levels.
   Option: Aptitude::Logging::Levels
   Valeur par defaut: (empty)
   Description: This option is a group whose members control which log
   messages are written. Each entry is either << level >>, to set the global
   log level (the log level of the root logger) to the given level, or
   << category:level >>, where category is the category of messages to modify
   (such as aptitude.resolver.hints.match) and level is the lowest log level
   of messages in that category that should be displayed. Valid log levels
   are << fatal >>, << error >>, << warn >>, << info >>, << debug >>, and
   << trace >>. The command-line option --log-level can be used to set or
   override any log level.
   Option: Aptitude::Parse-Description-Bullets
   Valeur par defaut: true
   Description: Si cette option est activee, aptitude essaiera de detecter
   automatiquement les items d'une liste dans les descriptions de paquets.
   Cela ameliore generalement l'affichage des descriptions, mais le formatage
   des descriptions d'anciens paquets pourrait etre moins bon quand cette
   option est `a true plutot qu'`a false.
   Option: Aptitude::Pkg-Display-Limit
   Valeur par defaut:
   Description: Filtre par defaut s'appliquant `a la liste des paquets ;
   consultez la section intitulee << Search patterns >> pour plus de details
   sur son format.
   Option: Aptitude::ProblemResolver::Allow-Break-Holds
   Valeur par defaut: false
   Description: If this option is set to true, the problem resolver will
   consider breaking package holds or installing forbidden versions in order
   to resolve a dependency. If it is set to false, these actions will be
   rejected by default, although you can always enable them manually (see la
   section intitulee << Resolving Dependencies Interactively >>).
   Option: Aptitude::ProblemResolver::BreakHoldScore
   Valeur par defaut: -300
   Description: How much to reward or penalize solutions that change the
   state of a held package or install a forbidden version. Note that unless
   Aptitude::ProblemResolver::Allow-Break-Holds is set to true, the resolver
   will never break a hold or install a forbidden version unless it has
   explicit permission from the user.
   Option: Aptitude::ProblemResolver::Break-Hold-Level
   Valeur par defaut: 50000
   Description: The safety cost assigned to actions that break a hold set by
   the user (by upgrading a held package or by installing a forbidden version
   of a package). See la section intitulee << Safety costs >> for a
   description of safety costs.
   Option: Aptitude::ProblemResolver::BrokenScore
   Valeur par defaut: -100
   Description: Nombre de points ajoute ou retranche aux solutions
   potentielles en se basant sur le nombre de dependances qu'ils cassent.
   Pour chaque dependance cassee par une solution possible, ce nombre de
   points est ajoute `a son score ; Generalement, il s'agit de points
   negatifs.
   Option: Aptitude::ProblemResolver::DefaultResolutionScore
   Valeur par defaut: 400
   Description: How much to reward or penalize prospective solutions based on
   how many << default >> resolutions for currently unsatisfied dependencies
   they install. The default resolution is the resolution that << apt-get
   install >> or the << immediate dependency resolver >> would pick. The
   score is only applied for dependencies and recommendations whose targets
   are not currently installed.
   Option: Aptitude::ProblemResolver::Discard-Null-Solution
   Valeur par defaut: true
   Description: Si cette option est mise `a true, aptitude ne suggerera
   jamais d'annuler toutes les actions que vous aviez prevues pour resoudre
   un probleme de dependances.
   Option: Aptitude::ProblemResolver::EssentialRemoveScore
   Valeur par defaut: -100000
   Description: Nombre de points ajoute ou retire au score des solutions
   supprimant un paquet << essentiel >>.
   Option: Aptitude::ProblemResolver::Remove-Essential-Level
   Valeur par defaut: 60000
   Description: The safety cost assigned to actions that remove an Essential
   package. See la section intitulee << Safety costs >> for a description of
   safety costs.
   Option: Aptitude::ProblemResolver::ExtraScore
   Valeur par defaut: -1
   Description: Ce nombre de points sera ajoute au score de toute version
   d'un paquet dont la priorite est << extra >>.
   Option: Aptitude::ProblemResolver::FullReplacementScore
   Valeur par defaut: 500
   Description: Removing a package and installing another package that fully
   replaces it (i.e., conflicts with it, replaces it, and provides it) is
   assigned this score.
   Option: Aptitude::ProblemResolver::FutureHorizon
   Valeur par defaut: 50
   Description: How many << steps >> the resolver should run after finding
   the first solution. Although aptitude attempts to generate better
   solutions before worse solutions, sometimes it is unable to do so; this
   setting causes the resolver to briefly continue searching for a better
   solution before displaying its results, rather than stopping immediately
   after it finds the first solution.
   Option: Aptitude::ProblemResolver::Hints
   Valeur par defaut: (empty)
   Description: This option is a group whose members are used to configure
   the problem resolver. Each item in the group is a string describing an
   action that should be applied to one or more packages. The syntax for each
   hint, and the effect that hints have, may be found in la section intitulee
   << Configuring resolver hints >>.
   Option: Aptitude::ProblemResolver::ImportantScore
   Valeur par defaut: 5
   Description: Ce nombre de points sera ajoute au score de toute version
   d'un paquet dont la priorite est << important >>.
   Option: Aptitude::ProblemResolver::Infinity
   Valeur par defaut: 1000000
   Description: Score << maximum >>, surnomme infini, pour les solutions
   potentielles : si un ensemble d'actions `a un score pire que -infini, il
   sera ecarte immediatement.
   Option: Aptitude::ProblemResolver::InstallScore
   Valeur par defaut: -20
   Description: Nombre de points que le solveur de probleme devrait donner `a
   l'installation d'un paquet, s'il n'est pas dej`a prevu de l'installer.
   Option: Aptitude::ProblemResolver::Keep-All-Level
   Valeur par defaut: 20000
   Description: The safety cost assigned to the single solution that cancels
   all of the actions selected by the user. See la section intitulee
   << Safety costs >> for a description of safety costs.
   Option: Aptitude::ProblemResolver::KeepScore
   Valeur par defaut: 0
   Description: Nombre de points que le solveur devrait donner pour garder un
   paquet dans son etat actuel, s'il n'est pas dej`a prevu de garder ce
   paquet dans son etat courant.
   Option: Aptitude::ProblemResolver::NonDefaultScore
   Valeur par defaut: -40
   Description: Nombre de points que le solveur de probleme devrait donner `a
   l'installation d'une version d'un paquet autre que celle par defaut (une
   qui n'est ni la version actuelle, ni la << version candidate >>).
   Option: Aptitude::ProblemResolver::Non-Default-Level
   Valeur par defaut: 50000
   Description: The safety cost assigned to actions that install non-default
   versions of a package. For instance, if version 5 of a package is
   installed, versions 6, 7, and 8 are available, and version 7 is the
   default version, then versions 6 and 8 will be given a safety cost that is
   at least this high. See la section intitulee << Safety costs >> for a
   description of safety costs.
   Option: Aptitude::ProblemResolver::OptionalScore
   Valeur par defaut: 1
   Description: Ce nombre de points sera ajoute au score de toute version
   d'un paquet dont la priorite est << optionnel >>.
   Option: Aptitude::ProblemResolver::PreserveAutoScore
   Valeur par defaut: 0
   Description: Nombre de points que le solveur de probleme devrait donner `a
   la preservation des installations et suppressions automatiques.
   Option: Aptitude::ProblemResolver::PreserveManualScore
   Valeur par defaut: 60
   Description: Nombre de points que le solveur de probleme devrait donner `a
   la preservation des actions explicitement selectionnees par l'utilisateur.
   Option: Aptitude::ProblemResolver::RemoveScore
   Valeur par defaut: -300
   Description: Nombre de points que le solveur de probleme devrait donner `a
   la suppression d'un paquet s'il n'est pas dej`a marque pour suppression.
   Option: Aptitude::ProblemResolver::Remove-Level
   Valeur par defaut: 10000
   Description: The safety cost assigned to actions that remove a package.
   See la section intitulee << Safety costs >> for a description of safety
   costs.
   Option: Aptitude::ProblemResolver::RequiredScore
   Valeur par defaut: 4
   Description: Ce nombre de points sera ajoute au score de toute version
   d'un paquet dont la priorite est << requis >>.
   Option: Aptitude::ProblemResolver::ResolutionScore
   Valeur par defaut: 50
   Description: En dehors de tout autre facteur, les solutions potentielles
   qui resolvent toutes les dependances non satisfaites sont recompensees par
   ce bonus.
   Option: Aptitude::ProblemResolver::Safe-Level
   Valeur par defaut: 10000
   Description: The safety cost assigned to actions that install the default
   version of a package, upgrade a package to its default version, or cancel
   installing or upgrading a package. Solutions assigned this cost could be
   generated by aptitude safe-upgrade. See la section intitulee << Safety
   costs >> for a description of safety costs.
   Option: Aptitude::ProblemResolver::SolutionCost
   Valeur par defaut: safety,priority
   Description: Describes how to determine the cost of a solution. See la
   section intitulee << Costs in the interactive dependency resolver >> for a
   description of what solution costs are, what they do, and the syntax used
   to specify them. If the cost cannot be parsed, an error is issued and the
   default cost is used instead.
   Option: Aptitude::ProblemResolver::StandardScore
   Valeur par defaut: 3
   Description: Ce nombre de points sera ajoute au score de toute version
   d'un paquet dont la priorite est << standard >>.
   Option: Aptitude::ProblemResolver::StepLimit
   Valeur par defaut: 5000
   Description: The maximum number of << steps >> which should be performed
   by the problem resolver on each attempt to find a solution to a dependency
   problem. Decreasing this number will make aptitude << give up >> sooner;
   increasing it will permit the search for a solution to consume much more
   time and memory before it is aborted. Setting StepLimit to 0 will disable
   the problem resolver entirely. The default value is large enough to
   accomodate commonly encountered situations, while preventing aptitude from
   << blowing up >> if an overly complicated problem is encountered. (note:
   this applies only to command-line searches; in the visual interface, the
   resolver will continue working until it reaches a solution)
   Option: Aptitude::ProblemResolver::StepScore
   Valeur par defaut: 70
   Description: Nombre de points ajoute ou retranche aux solutions
   potentielles en se basant sur leur longueur. Pour chaque action comprise
   dans une solution, ce nombre de points est ajoute `a son score ; Plus
   cette valeur est grande, plus l'algorithme essaye de favoriser le premier
   choix plutot que de s'orienter vers une alternative. Cela permettra
   d'obtenir plus rapidement une solution, mais qui risque d'etre de qualite
   moindre `a ce qu'elle aurait pu etre.
   Option: Aptitude::ProblemResolver::Trace-Directory
   Valeur par defaut:
   Description: If this value is set, then each time the problem resolver
   produces a solution, a stripped-down version of the package state
   sufficient to reproduce that solution is written to the given file. If
   Aptitude::ProblemResolver::Trace-File is also set, the same information
   will also be written to the trace file. Trace directories are more
   transparent than trace files, and are more suitable for, e.g., including
   in source trees as test cases.
   Option: Aptitude::ProblemResolver::Trace-File
   Valeur par defaut:
   Description: If this value is set, then each time the problem resolver
   produces a solution, a stripped-down version of the package state
   sufficient to reproduce that solution is written to the given file. If
   Aptitude::ProblemResolver::Trace-Directory is also set, the same
   information will also be written to the trace directory. A trace file is
   simply a compressed archive of a trace directory; it will take less space
   than the trace directory and is suitable for transmission over a network.
   Option: Aptitude::ProblemResolver::UndoFullReplacementScore
   Valeur par defaut: -500
   Description: Installing a package and removing another package that fully
   replaces it (i.e., conflicts with it, replaces it, and provides it) is
   assigned this score.
   Option: Aptitude::ProblemResolver::UnfixedSoftScore
   Valeur par defaut: -200
   Description: Nombre de points ajoute ou retranche aux solutions
   potentielles qui laissent une recommandation (champ << Recommande >>) non
   satisfaite. Il est generalement plus petit que << RemoveScore >>, car
   sinon aptitude pourrait supprimer des paquets plutot que de laisser leurs
   recommandations non satisfaites. Consultez la section intitulee
   << Resolving Dependencies Interactively >> pour plus de details.
   Option: Aptitude::ProblemResolver::UpgradeScore
   Valeur par defaut: 0
   Description: Quel nombre de points le solveur de probleme devrait donner
   `a la montee (ou la descente) en version vers la version candidate du
   paquet, s'il n'est pas dej`a prevu de le mettre `a jour.
   Option: Aptitude::Purge-Unused
   Valeur par defaut: false
   Description: Si cette option est mise `a true et si
   Aptitude::Delete-Unused est aussi `a true, les paquets qui ne sont plus
   utilises seront purge du systeme, en supprimant leurs fichiers de
   configuration et peut-etre des donnees importantes. Pour plus
   d'informations sur les paquets consideres comme << inutilise >>, consultez
   la section intitulee << Gerer les paquets automatiquement installes >>.
   CETTE OPTION PEUT ENTRAINER DES PERTES DE DONNEES ! NE L'ACTIVEZ QUE SI
   VOUS SAVEZ CE QUE VOUS FAITES !
   Option: Aptitude::Recommends-Important
   Valeur par defaut: true
   Description: This is an obsolete configuration option that has been
   superseded by Apt::Install-Recommends. On startup, aptitude will copy
   Aptitude::Recommends-Important (if it exists) to Apt::Install-Recommends
   and then clear Aptitude::Recommends-Important in your user configuration
   file.
   Option: Aptitude::Safe-Resolver::No-New-Installs
   Valeur par defaut: false
   Description: If this option is true, then when the << safe >> dependency
   resolver has been activated via --safe-resolver, the resolver will not be
   allowed to install packages that are not currently installed. This is
   similar to Aptitude::CmdLine::Safe-Upgrade::No-New-Installs, but applies
   only to command-line actions other than safe-upgrade.
   Option: Aptitude::Safe-Resolver::No-New-Upgrades
   Valeur par defaut: false
   Description: If this option is enabled, then when the << safe >>
   dependency resolver has been activated via --safe-resolver, the resolver
   will not be allowed to resolve dependencies by upgrading packages.
   Option: Aptitude::Sections::Descriptions
   Valeur par defaut: See $prefix/share/aptitude/section-descriptions
   Description: This option is a group whose members define the descriptions
   displayed for each section when using the << section >> package hierarchy
   grouping policy. Descriptions are assigned to section trees based on the
   last component of the name: for instance, a member of this group named
   << games >> will be used to describe the Sections << games >>,
   << non-free/games >>, and << non-free/desktop/games >>. Within the text of
   section descriptions, the string << \n >> will be replaced by a
   line-break, and the string << '' >> will be replaced by a double-quote
   character.
   Option: Aptitude::Sections::Top-Sections
   Valeur par defaut: "main"; "contrib"; "non-free"; "non-US";
   Description: A configuration group whose elements are the names of the
   top-level archive sections. The << topdir >>, << subdir >>, and
   << subdirs >> grouping policies use this list to interpret Section fields:
   if the first path element of a package's Section is not contained in this
   list, or if its Section has only one element, then the package will be
   grouped using the first member of this list as its first path element. For
   example, if the first member of Top-Sections is << main >>, then a package
   whose Section is << games >> will be treated as if its Section field were
   << games/arcade >>.
   Option: Aptitude::Simulate
   Valeur par defaut: false
   Description: In command-line mode, causes aptitude to just display the
   actions that would be performed (rather than actually performing them); in
   the visual interface, causes aptitude to start in read-only mode
   regardless of whether you are root or not. This is equivalent to the -s
   command-line option.
   Option: Aptitude::Spin-Interval
   Valeur par defaut: 500
   Description: Nombre de millisecondes d'attente entre la mise `a jour du
   << spinner >> qui apparait pendant le fonctionnement du solveur.
   Option: Aptitude::Suggests-Important
   Valeur par defaut: false
   Description: This is an obsolete option; use
   Apt::AutoRemove::Suggests-Important instead. Setting this option to true
   has the same effect as setting Apt::AutoRemove::Suggests-Important to
   true.
   Option: Aptitude::Suppress-Read-Only-Warning
   Valeur par defaut: false
   Description: If this option is false, aptitude will display a warning the
   first time that you attempt to modify package states while aptitude is in
   read-only mode.
   Option: Aptitude::Theme
   Valeur par defaut:
   Description: Theme qu'aptitude doit utiliser. Consultez la section
   intitulee << Themes >> pour plus d'informations.
   Option: Aptitude::Track-Dselect-State
   Valeur par defaut: true
   Description: Si cette option est mise `a true, aptitude essaiera de
   detecter si un changement a ete apporte `a l'etat du paquet par
   l'utilisation de dselect ou dpkg : par exemple, si vous supprimez un
   paquet avec dpkg, aptitude n'essaiera pas de le reinstaller. Notez que
   cela peut ne pas toujours fonctionner parfaitement.
   Option: Aptitude::UI::Advance-On-Action
   Valeur par defaut: false
   Description: Si cette option est mise `a true, changer l'etat d'un paquet
   (par exemple, le marquer pour installation) basculera la mise en
   surbrillance vers le prochain paquet dans le groupe courant.
   Option: Aptitude::UI::Auto-Show-Reasons
   Valeur par defaut: true
   Description: Si cette option est mise `a true, selectionner un paquet qui
   est casse, ou qui semble avoir casse d'autres paquets, va entrainer
   l'affichage dans la zone d'information des raisons expliquant pourquoi ce
   paquet est casse.
   Option: Aptitude::UI::Default-Grouping
   Valeur par defaut:
   filter(missing),status,section(subdirs,passthrough),section(topdir)
   Description: Configure la politique de regroupement par defaut utilisee
   pour la liste des paquets. Consultez la section intitulee << Personnaliser
   la hierarchie des paquets >> pour des informations supplementaires sur les
   politiques de regroupement.
   Option: Aptitude::UI::Default-Package-View
   Valeur par defaut:
   Description: Cette option est un groupe dont les membres definissent
   l'apparence par defaut de l'affichage d'aptitude. Consultez la section
   intitulee << Personnaliser la disposition de l'affichage >> pour plus
   d'informations.
   Option: Aptitude::UI::Default-Preview-Grouping
   Valeur par defaut: action
   Description: Configure la politique de regroupement par defaut utilisee
   pour les ecrans d'aperc,u. Consultez la section intitulee << Personnaliser
   la hierarchie des paquets >> pour des informations supplementaires sur les
   politiques de regroupement.
   Option: Aptitude::UI::Default-Sorting
   Valeur par defaut: name
   Description: Configure la politique de tri par defaut des vues de paquets.
   Consultez la section intitulee << Personnaliser la maniere de trier les
   paquets >> pour plus d'informations.
   Option: Aptitude::UI::Description-Visible-By-Default
   Valeur par defaut: true
   Description: Quand une liste de paquets est affichee pour la premiere
   fois, la zone d'information (qui contient generalement la description
   longue du paquet courant) sera visible si cette option est mise `a true et
   cachee si elle est `a false.
   Option: Aptitude::UI::Exit-On-Last-Close
   Valeur par defaut: true
   Description: Si cette option est mise `a true, fermer toutes les vues
   actives quittera aptitude. Sinon, aptitude ne quittera pas avant que vous
   executiez la commande Actions -> Quitter (Q). Consultezla section
   intitulee << Travailler avec plusieurs vues >> pour plus d'informations.
   Option: Aptitude::UI::Fill-Text
   Valeur par defaut: false
   Description: Si cette option est mise `a true, aptitude formatera les
   lignes pour qu'elles occupent exactement la largeur de l'ecran.
   Option: Aptitude::UI::Flat-View-As-First-View
   Valeur par defaut: false
   Description: If this option is true, aptitude will display a flat view on
   startup instead of the default view.
   Option: Aptitude::UI::HelpBar
   Valeur par defaut: true
   Description: Si cette option est mise `a true, une ligne d'information sur
   les raccourcis clavier importants est affichee en haut de l'ecran.
   Option: Aptitude::UI::Incremental-Search
   Valeur par defaut: true
   Description: Si cette option est mise `a true, aptitude effectuera des
   recherches << incrementales >> : pendant que vous tapez le motif de
   recherche, il cherchera le paquet suivant qui correspond `a ce que vous
   avez tape jusque l`a.
   Option: Aptitude::UI::InfoAreaTabs
   Valeur par defaut: false
   Description: If this option is true, aptitude will display tabs at the top
   of the information area (the pane at the bottom of the screen) describing
   the different modes the area can be set to.
   Option: Aptitude::UI::Keybindings
   Valeur par defaut:
   Description: C'est un groupe de configuration dont les membres definissent
   les relations entre sequences de touches et commandes dans aptitude. Pour
   plus d'informations, consultez la section intitulee << Personnaliser les
   raccourcis clavier >>.
   Option: Aptitude::UI::Menubar-Autohide
   Valeur par defaut: false
   Description: Si cette option est mise `a true, la barre de menu sera
   cachee lorsqu'elle ne sera pas utilisee.
   Option: Aptitude::UI::Minibuf-Download-Bar
   Valeur par defaut: false
   Description: Si cette option est mise `a true, aptitude utilisera un
   mecanisme plus discret pour afficher l'avancement des telechargements :
   une barre en bas de l'ecran apparaitra pour afficher l'etat actuel du
   telechargement. Lorsqu'un telechargement est actif, appuyer sur q
   l'annulera.
   Option: Aptitude::UI::Minibuf-Prompts
   Valeur par defaut: false
   Description: Si cette option est mise `a true, certaines questions (comme
   les questions oui/non ou `a choix multiples) seront affichees en bas de
   l'ecran plutot que dans une boite de dialogue.
   Option: Aptitude::UI::New-Package-Commands
   Valeur par defaut: true
   Description: Si cette option est mise `a false, des commandes comme Paquet
   -> Installer (+) auront le comportement depasse qu'elles avaient dans
   d'anciennes versions d'aptitude.
   Option: Aptitude::UI::Package-Display-Format
   Valeur par defaut: %c%a%M %p %Z %v %V
   Description: Cette option controle la chaine de format utilisee pour
   afficher les paquets dans les listes de paquets. Pour plus d'informations
   sur les chaines de format, consultez la section intitulee << Personnaliser
   la maniere d'afficher les paquets >>.
   Option: Aptitude::UI::Package-Header-Format
   Valeur par defaut: %N %n #%B %u %o
   Description: Cette option controle la chaine de format utilisee pour
   afficher la ligne d'en-tete de la liste des paquets (c'est-`a-dire la
   ligne qui apparait entre la liste de paquets et la barre de menu). Pour
   plus d'informations sur les chaines de format, consultez la section
   intitulee << Personnaliser la maniere d'afficher les paquets >>.
   Option: Aptitude::UI::Package-Status-Format
   Valeur par defaut: %d
   Description: Cette option controle la chaine de format utilisee pour
   afficher la ligne d'etat de la liste des paquets (c'est-`a-dire la ligne
   qui apparait entre la liste de paquets et la zone d'information). Pour
   plus d'informations sur les chaines de format, consultez la section
   intitulee << Personnaliser la maniere d'afficher les paquets >>.
   Option: Aptitude::UI::Pause-After-Download
   Valeur par defaut: OnlyIfError
   Description: Si cette option est `a true, apres avoir fini de telecharger
   les paquets, aptitude affichera un message demandant si vous souhaitez
   continuer l'installation. Si cette option est `a OnlyIfError, un message
   ne sera affiche qu'en cas d'echec du telechargement. Si cette option est
   `a false, aptitude enchainera immediatement avec l'ecran suivant `a la fin
   du telechargement.
   Option: Aptitude::UI::Preview-Limit
   Valeur par defaut:
   Description: Filtre par defaut applique `a l'ecran de previsualisation.
   Consultez la section intitulee << Search patterns >> pour des details sur
   son format.
   Option: Aptitude::UI::Prompt-On-Exit
   Valeur par defaut: true
   Description: Si cette option est mise `a true, aptitude affichera une
   demande de confirmation avant de quitter.
   Option: Aptitude::UI::Styles
   Valeur par defaut:
   Description: Ceci est le groupe de configuration dont le contenu definit
   quels styles textuels aptitude utilise pour afficher l'information. Pour
   plus d'informations, consultez la section intitulee << Personnaliser la
   couleur du texte et les styles >>.
   Option: Aptitude::UI::ViewTabs
   Valeur par defaut: true
   Description: Si cette option est mise `a false, aptitude n'affichera pas
   le bandeau listant les vues actuellement actives en haut de l'ecran.
   Option: Aptitude::Warn-Not-Root
   Valeur par defaut: true
   Description: Si cette option est mise `a true, aptitude detectera quand
   vous avez besoin des privileges d'administration et vous demandera si vous
   souhaitez passer sous le compte administrateur (root) si vous ne l'etes
   pas dej`a. Consultez la section intitulee << Devenir administrateur
   (<< root >>) >> pour plus d'informations.
   Option: DebTags::Vocabulary
   Valeur par defaut: /usr/share/debtags/vocabulary
   Description: Emplacement du fichier de vocabulaire de debtags utilise pour
   charger les metadonnees des marqueurs du paquet.
   Option: Dir::Aptitude::state
   Valeur par defaut: /var/lib/aptitude
   Description: Repertoire dans lequel les informations d'etat persistant
   d'aptitude sont conservees.
   Option: Quiet
   Valeur par defaut: 0
   Description: Cette option controle le niveau de silence de la ligne de
   commande. La parametrer `a un niveau plus important desactive d'avantage
   les indicateurs d'avancement.

  Themes

   Dans aptitude, un theme est juste un ensemble d'options de configuration.
   Les themes sont utilises pour venir recouvrir les valeurs par defaut de
   certaines options. Si une option n'est pas configuree dans le fichier de
   configuration du systeme ou dans votre fichier de configuration personnel,
   aptitude utilisera les valeurs des options provenant du theme actuel, s'il
   y en a un de disponible, avant d'utiliser les valeurs par defaut standard.

   Un theme est simplement un groupe nomme sous Aptitude::Themes dont chacune
   des options de configuration recouvrira l'option correspondante de la
   configuration globale. Par exemple, si le theme Dselect est selectionne,
   l'option Aptitude::Themes::Dselect::Aptitude::UI::Package-Display-Format
   recouvrira la valeur par defaut de l'option
   Aptitude::UI::Package-Display-Format.

   Pour selectionner un theme, donner le nom du theme comme valeur de
   l'option de configuration d'Aptitude::Theme. Par exemple :

 Aptitude::Theme Vertical-Split;

   Les themes suivants sont fournis avec aptitude dans
   /usr/share/aptitude/aptitude-defaults :

   Dselect

           Ce theme donne `a aptitude une apparence et un comportement proche
           du venerable gestionnaire de paquet dselect :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 --\ Installed Packages
   --\ Priority required
     --\ base - The Debian base system
 c   base  base-file 3.0.16      3.0.16      Debian base system miscellaneous fil
 c   base  base-pass 3.5.7       3.5.7       Debian base system master password a
 c   base  bash      2.05b-15    2.05b-15    The GNU Bourne Again SHell
 c   base  bsdutils  1:2.12-7    1:2.12-7    Basic utilities from 4.4BSD-Lite
 c   base  coreutils 5.0.91-2    5.0.91-2    The GNU core utilities
 c   base  debianuti 2.8.3       2.8.3       Miscellaneous utilities specific to
 c   base  diff      2.8.1-6     2.8.1-6     File comparison utilities
 base-files                      installed ; none                       required
 This package contains the basic filesystem hierarchy of a Debian system, and
 several important miscellaneous files, such as /etc/debian_version,
 /etc/host.conf, /etc/issue, /etc/motd, /etc/profile, /etc/nsswitch.conf, and
 others, and the text of several common licenses in use on Debian systems.







   Vertical-Split

           Ce theme arrange l'affichage de maniere `a ce que la description
           du paquet actuel s'affiche `a droite de la liste des paquets
           plutot qu'en-dessous de cette liste. Ce theme est utile avec des
           terminaux tres larges, et peut-etre aussi lors de l'edition de la
           hierarchie des paquets integree.

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 aptitude 0.2.14.1
 --\ Installed Packages                  Modern computers support the Advanced  #
   --\ admin - Administrative utilities  Configuration and Power Interface
     --\ main - The main Debian archive  (ACPI) to allow intelligent power
 i   acpid         1.0.3-19   1.0.3-19   management on your system and to query
 i   alien         8.44       8.44       battery and configuration status.
 i   anacron       2.3-9      2.3-9
 i   apt-show-vers 0.07       0.07       ACPID is a completely flexible, totally
 i A apt-utils     0.5.25     0.5.25     extensible daemon for delivering ACPI
 i   apt-watch     0.3.2-2    0.3.2-2    events. It listens on a file
 i   aptitude      0.2.14.1-2 0.2.14.1-2 (/proc/acpi/event) and when an event
 i   at            3.1.8-11   3.1.8-11   occurs, executes programs to handle the
 i   auto-apt      0.3.20     0.3.20     event. The programs it executes are
 i   cron          3.0pl1-83  3.0pl1-83  configured through a set of
 i   debconf       1.4.29     1.4.29     configuration files, which can be
 i   debconf-i18n  1.4.29     1.4.29     dropped into place by packages or by
 i A debootstrap   0.2.39     0.2.39     the admin.
 i A deborphan     1.7.3      1.7.3
 i   debtags       0.16       0.16       In order to use this package you need a
 i A defoma        0.11.8     0.11.8     recent Kernel (=>2.4.7). This can be
 i   discover      2.0.4-5    2.0.4-5    one including the patches on
 Utilities for using ACPI power management

Jouer au demineur

   Au cas ou vous seriez fatigue d'installer et supprimer des paquets,
   aptitude inclut une version du jeu classique << demineur >>. Pour le
   lancer, selectionner Actions -> Jouer au demineur. Le plateau initial du
   demineur apparaitra alors :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 Minesweeper                                              10/10 mines  13 seconds





                                    +--------+
                                    |        |
                                    |        |
                                    |        |
                                    |        |
                                    |        |
                                    |        |
                                    |        |
                                    |        |
                                    +--------+






   A l'interieur du rectangle qui apparait `a l'ecran sont cachees dix mines.
   Votre but est de determiner, grace `a votre intuition, votre logique et la
   chance, ou ces mines se trouvent sans en faire exploser une seule ! Pour
   ce faire, vous devez decouvrir toutes les cases qui ne contiennent pas de
   mines. Ce faisant, vous allez obtenir des informations importantes
   concernant les cases qui contiennent des mines. Attention tout de meme,
   decouvrir une case qui contient une mine la fera exploser, mettant fin au
   jeu immediatement !

   Pour decouvrir une case (et savoir si une mine y est cachee), selectionnez
   la case avec les fleches et appuyer sur Entree :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 Minesweeper                                             10/10 mines  387 seconds





                                    +--------+
                                    | 2......|
                                    | 2111...|
                                    |    1...|
                                    | 1111...|
                                    |11...111|
                                    |...113  |
                                    |1122    |
                                    |        |
                                    +--------+






   Comme vous pouvez le voir, une partie de la zone cachee (vide) du plateau
   a ete revelee dans cette capture d'ecran. Les cases contenant un . sont
   les cases qui ne sont adjacentes `a aucune mine. Les chiffres dans les
   autres cases indiquent combien de mines il y a dans les cases adjacentes.

   Si vous pensez savoir ou une mine se trouve, vous pouvez placer un drapeau
   sur celle-ci. Pour faire cela, selectionner la case suspecte et appuyer
   sur f. Par exemple, dans la capture suivante, j'ai decide que la case sur
   la partie gauche de l'ecran avait l'air suspecte...

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 Minesweeper                                              9/10 mines  961 seconds





                                    +--------+
                                    | 2......|
                                    | 2111...|
                                    |    1...|
                                    |F1111...|
                                    |11...111|
                                    |...113  |
                                    |1122    |
                                    |        |
                                    +--------+






   Comme vous pouvez le voir, un F est apparu sur la case selectionnee. Il
   n'est plus possible de decouvrir cette case, meme accidentellement,
   jusqu'`a ce que le drapeau soit enleve (en appuyant `a nouveau sur f). Une
   fois que vous avez place un drapeau sur toutes les mines qui sont `a cote
   d'une case (par exemple, les cases avec un 1 `a cote du drapeau au
   dessus), pour pouvez << faire le menage >> autour de la case. Ce n'est
   qu'une facilite pour decouvrir toutes les cases adjacentes (`a l'exception
   de celles contenant un drapeau, bien sur). Par exemple, faisons le menage
   autour du 1 ci-dessus :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 Minesweeper                                              9/10 mines  2290 seconds





                                    +--------+
                                    | 2......|
                                    | 2111...|
                                    |221 1...|
                                    |F1111...|
                                    |11...111|
                                    |...113  |
                                    |1122    |
                                    |        |
                                    +--------+






   Heureusement, ma supposition sur l'emplacement de cette mine etait bon. Si
   j'avais eu tort, j'aurais perdu immediatement :

  Actions  Undo  Package  Search  Options  Views  Help
 f10: Menu  ?: Help  q: Quit  u: Update  g: Download/Install/Remove Pkgs
 Minesweeper                                   Minesweeper    Lost in 2388 seconds





                                    +--------+
                                    |^2......|
                                    |^2111...|
                                    |221^1...|
                                    |^1111...|
                                    |11...111|
                                    |...113^ |
                                    |1122* ^ |
                                    | ^ ^   ^|
                                    +--------+






   Quand vous avez perdu, l'emplacement de toutes les mines est revele : les
   mines non explosees sont indiquees par un accent circonflexe (^), et celle
   sur laquelle vous avez << marche >> est indiquee par une asterisque (*).

   --------------

   ^[7] J'ai plaisir `a dire que le nombre de ces requetes a fortement
   diminue juste apres la premiere parution de ce guide. Esperons qu'il y ait
   un lien entre ces deux evenements.

   ^[8] Cela est parfois appele << processus d'installation >>, meme s'il se
   peut que vous mettiez `a jour ou supprimiez des paquets en plus d'en
   installer.

   ^[9] Comme indique plus haut, cela n'indique pas que les paquets dans
   l'archive sont surs ou non malveillants ; il montre simplement qu'ils sont
   d'origine.

   ^[10] More precisely: they will be removed when there is no path via
   Depends, PreDepends, or Recommends to them from a manually installed
   package. If Aptitude::Keep-Suggests is true, a Suggests relationship is
   also enough to keep a package installed.

   ^[11] Or when immediate resolution is disabled.

   ^[12] The package with the highest dpkg priority, not the package with the
   highest apt pin priority.

   ^[13] This limit was imposed because more complex cost structures could
   make it difficult to optimize the resolver. Future versions of the program
   might remove some of the restrictions if they turn out to be unnecessary.

   ^[14] aptitude will only treat the comma as special if there is a second
   argument, so (for instance) << ?name(apt,itude) >> searches for the string
   << apt,itude >> in the Name field of packages.

   While this behavior is well-defined, it may be surprising; I recommend
   using quoted strings for any pattern that contains characters that could
   have a special meaning.

   ^[15] Characters with a special meaning include: << + >>, << - >>,
   << . >>, << ( >>, << ) >>, << | >>, << [ >>, << ] >>, << ^ >>, << $ >>,
   and << ? >>. Note that some of these are also aptitude metacharacters, so
   if you want to type (for instance) a literal << | >>, it must be
   double-escaped: << ?description(\~|) >> will match packages whose
   description contains a vertical bar character (<< | >>).

   ^[16] Les sequences d'echappement \\, \n et \t sont egalement disponibles.

   ^[17] Astute readers will note that this is essentially a way to
   explicitly name the variable in the l-terms corresponding to the term. A
   typical term would have the form << l x . name-equals(x, pattern) >>;
   giving this an explicit target makes x visible in the search language.

   ^[18] This is provided largely for symmetry with ?true.

   ^[19] Actuellement l'etiquetage n'est pas gere, cette commande est
   destinee `a un usage futur.

   ^[20] Sur certains terminaux, un arriere plan << yellow >> (jaune)
   s'affichera en brun.

Chapitre 3. aptitude frequently asked questions

     << Quel... est ton nom ? >>

     << Arthur, roi des Anglais. >>

     << Quelle... est ta quete ? >>

     << Je cherche le Saint Graal ! >>

     << Quelle... est la vitesse d'une hirondelle `a vide ? >>

     << Qu'est-ce que vous voulez dire ? Une hirondelle d'Afrique ou
     d'Europe ? >>

     << Euh ? Je ... je n'sais pa--AAAAAAAS ! >>
                                                 -- Monty Python, sacre Graal

   3.1. Comment puis-je trouver un paquet par son nom exact ?

   3.2. Comment puis-je trouver les paquets casses ?

   3.3. Je veux selectionner du texte avec la souris, pourquoi aptitude ne me
   laisse-t-il pas faire ?

   3.1. Comment puis-je trouver un paquet par son nom exact ?
        Comme signale dans la section intitulee << Search patterns >>, quand
        vous recherchez un paquet par son nom, le texte que vous tapez est en
        fait une expression rationnelle. Donc, le motif de recherche
        << ^nom$ >> correspondra uniquement au paquet nomme nom.

        Par exemple, vous pouvez rechercher apt (mais pas aptitude ou
        synaptic) en tapant ^apt$. Vous pouvez rechercher g++ (mais pas
        g++-2.95 ou g++-3.0) en tapant ^g\+\+$.
   3.2. Comment puis-je trouver les paquets casses ?
        Utiliser la commande Rechercher -> Rechercher les casses (b).
   3.3. Je veux selectionner du texte avec la souris, pourquoi aptitude ne me
        laisse-t-il pas faire ?
        Normally, you cannot select text in an xterm while a program running
        in that terminal (such as aptitude) is using the mouse. However, you
        can override this behavior and perform a selection by holding the
        Shift key down while you click on the terminal.

Chapitre 4. Credits

           Personne ne se rappelle du chanteur. La chanson reste.
                                         -- Terry Pratchett, Le dernier heros

   Cette section garde le souvenir des personnes qui ont contribue `a
   aptitude un jour ou l'autre.

   [Note] Note
          This section is presently rather incomplete and will likely be
          updated and expanded as time goes on (in particular, there are many
          missing translation credits due to the huge number of sources of
          translations ^[21]). If you think you should be on this list,
          please email <dburrows@debian.org> with an explanation of why you
          think so.

   Translations and internationalization

   Traduction bresilienne

           Andre Luis Lopes, Gustavo Silva

   Traduction chinoise

           Carlos Z.F. Liu

   Traduction tcheque

           Miroslav Kure

   Traduction danoise

           Morten Brix Pedersen, Morten Bo Johansen

   Traduction neerlandaise

           Luk Claes

   Traduction finnoise

           Jaakko Kangasharju

   Traduction franc,aise

           Martin Quinson, Jean-Luc Coulon

   Traduction allemande

           Sebastian Schaffert, Erich Schubert, Sebastian Kapfer, Jens Seidel

   Traduction italienne

           Danilo Piazzalunga

   Traduction japonaise

           Yasuo Eto, Noritada Kobayashi

   Traduction lituanienne

           Darius Zitkevicius

   Traduction polonaise

           Michal Politowski

   Traduction portugaise

           Nuno Senica, Miguel Figueiredo

   Traduction norvegienne

           Haavard Korsvoll

   Traduction espagnole

           Jordi Malloch, Ruben Porras

   Traduction suedoise

           Daniel Nylander

   Correctif initial d'internationalisation (i18n)

           Masato Taruishi

   Maintenance et tri de l'i18n

           Christian Perrier

   Documentation

   Manuel de l'utilisateur

           Daniel Burrows

   Programmation

   Conception et mise en oeuvre du programme

           Daniel Burrows

   Gestion du champ Casse pour dpkg.

           Ian Jackson, Michael Vogt

   --------------

   ^[21] Il devrait etre possible de creer une liste assez complete des
   contributeurs de l'internationalisation en se basant sur le ChangeLog, les
   references au systeme de gestion des bogues Debian et les versions de
   l'historique d'aptitude, mais cela demanderait un enorme investissement en
   temps qui n'est pas possible actuellement.

                             Command-line reference

   --------------------------------------------------------------------------

   Table des matieres

   aptitude -- interface evoluee pour le gestionnaire de paquets

   aptitude-create-state-bundle -- bundle the current aptitude state

   aptitude-run-state-bundle -- unpack an aptitude state bundle and invoke
   aptitude on it

Nom

   aptitude -- interface evoluee pour le gestionnaire de paquets

Synopsis

   aptitude [options...] { autoclean | clean | forget-new | keep-all | update
   }

   aptitude [options...] { full-upgrade | safe-upgrade } [packages...]

   aptitude [options...] { build-dep | build-depends | changelog | download |
   forbid-version | hold | install | markauto | purge | reinstall | remove |
   show | unhold | unmarkauto | versions } packages...

   aptitude extract-cache-subset output-directory packages...

   aptitude [options...] search motifs...

   aptitude [options...] { add-user-tag | remove-user-tag } tag packages...

   aptitude [options...] { why | why-not } [patterns...] package

   aptitude [-S fname] [ --autoclean-on-startup | --clean-on-startup | -i |
   -u ]

   aptitude help

Description

   aptitude est une interface en mode texte pour le gestionnaire de paquets
   de Debian GNU/Linux.

   Elle permet `a l'utilisateur de connaitre la liste des paquets et de
   realiser des taches d'administration comme l'installation, la mise `a jour
   ou l'effacement de paquets. Ces taches peuvent etre realisees en mode
   << interactif >> ou `a partir de la << ligne de commande >>.

Command-line actions

   Le premier argument qui ne commence pas par un tiret (<< - >>) sera
   considere comme etant la commande que le programme doit realiser. Si
   aucune commande n'est donnee, aptitude demarrera en mode interactif.

   Commandes disponibles :

   install

           Install one or more packages. The packages should be listed after
           the << install >> command; if a package name contains a tilde
           character (<< ~ >>) or a question mark (<< ? >>), it will be
           treated as a search pattern and every package matching the pattern
           will be installed (see the section << Search Patterns >> in the
           aptitude reference manual).

           Pour selectionner une version precise d'un paquet, ajoutez
           << =version >> au nom du paquet : par exemple, << aptitude install
           apt=0.3.1 >>. De la meme fac,on, pour choisir un paquet d'une
           archive precise, ajoutez << /archive >> au nom du paquet : par
           exemple, << aptitude install apt/experimental >>.

           Tous les paquets listes sur la ligne de commande ne doivent pas
           necessairement etre installe. Vous pouvez dire `a aptitude d'agir
           differemment avec un paquet en suffixant un << attribut de
           surcharge >> au nom du paquet. Par exemple, aptitude remove
           wesnoth+ installera wesnoth au lieu de le supprimer. Les attributs
           de surcharge suivants sont disponibles :

                paquet+

                        Installe paquet.

                paquet+M

                        Installe paquet et le marque comme installe
                        automatiquement (notez que si aucun autre paquet ne
                        depend de paquet, cela entrainera sa suppression
                        immediate).

                paquet-

                        Supprime paquet.

                paquet_

                        Purge paquet : supprime le paquet ainsi que tous ses
                        fichiers de configuration.

                paquet=

                        Marque paquet comme etant `a conserver : annule toute
                        action d'installation, de mise `a jour ou de
                        suppression, et empeche ce paquet d'etre mis `a jour
                        automatiquement dans le futur.

                paquet:

                        Garde paquet `a sa version actuelle : annule toute
                        action d'installation, de mise `a jour ou de
                        suppression. Contrairement `a << hold >> (voir
                        ci-dessus), cela n'empeche pas ce paquet d'etre mis
                        `a jour automatiquement dans le futur.

                paquet&M

                        Marque paquet comme ayant ete installe
                        automatiquement.

                paquet&m

                        Marque paquet comme ayant ete installe manuellement.

           Cas particulier, << install >> sans autre argument resoudra les
           commandes en suspens ou differees.

           [Note] Note
                  Une fois que vous avez appuye sur Y `a l'invite de
                  confirmation finale, la commande << install >> modifie les
                  informations enregistrees sur les actions qu'aptitude doit
                  realiser. De ce fait, si vous lancez la commande
                  << aptitude install toto titi >> puis que vous arretiez
                  l'installation alors qu'aptitude a dej`a commence `a
                  telecharger et installer des paquets, vous devrez lancer
                  << aptitude remove toto titi >> pour l'annuler.

   remove, purge, hold, unhold, keep, reinstall

           These commands are the same as << install >>, but apply the named
           action to all packages given on the command line for which it is
           not overridden. The difference between hold and keep is that hold
           will cause a package to be ignored by future safe-upgrade or
           full-upgrade commands, while keep merely cancels any scheduled
           actions on the package. unhold will allow a package to be upgraded
           by future safe-upgrade or full-upgrade commands, without otherwise
           altering its state.

           Par exemple, << aptitude remove '~ndeity' >> supprimera tous les
           paquets dont le nom contient << deity >>).

   markauto, unmarkauto

           Indique que les paquets ont ete respectivement installes
           automatiquement, ou `a la main. Vous pouvez choisir les paquets
           grace `a la syntaxe vue plus haut, et meme indiquer les commandes
           `a realiser. Par exemple, << aptitude markauto '~slibs' >>
           marquera tous les paquets de la section << libs >> comme ayant ete
           installes automatiquement.

           Pour plus d'informations sur les paquets installes
           automatiquement, consultez la section << Gerer les paquets
           automatiquement installes >> dans le manuel de reference
           d'aptitude.

   build-depends, build-dep

           Satisfy the build-dependencies of a package. Each package name may
           be a source package, in which case the build dependencies of that
           source package are installed; otherwise, binary packages are found
           in the same way as for the << install >> command, and the
           build-dependencies of the source packages that build those binary
           packages are satisfied.

           If the command-line parameter --arch-only is present, only
           architecture-dependent build dependencies (i.e., not
           Build-Depends-Indep or Build-Conflicts-Indep) will be obeyed.

   forbid-version

           Empeche la mise `a jour vers une version precise d'un paquet.
           Cette option interdit `a aptitude la mise `a jour automatique vers
           cette version, mais permettra le passage aux versions suivantes.
           Par defaut, aptitude choisira la version vers laquelle ce paquet
           aurait normalement du etre mis `a jour. Vous pouvez modifier ce
           choix en ajoutant << =version >> au nom du paquet : par exemple,
           << aptitude forbid-version vim=1.2.3.broken-4 >>.

           Cette commande est pratique pour eviter les versions boguees des
           paquets sans avoir `a definir ou supprimer des gels `a la main. Si
           vous decidez finalement d'installer la version que vous aviez
           interdite, la commande << install >> mettra fin `a l'interdiction.

   update

           Met `a jour la liste des paquets disponibles sur les serveurs
           maitres. (C'est l'equivalent de << apt-get update >>).

   safe-upgrade

           Upgrades installed packages to their most recent version.
           Installed packages will not be removed unless they are unused (see
           the section << Managing Automatically Installed Packages >> in the
           aptitude reference manual). Packages which are not currently
           installed may be installed to resolve dependencies unless the
           --no-new-installs command-line option is supplied.

           If no packages are listed on the command line, aptitude will
           attempt to upgrade every package that can be upgraded. Otherwise,
           aptitude will attempt to upgrade only the packages which it is
           instructed to upgrade. The packages can be extended with suffixes
           in the same manner as arguments to aptitude install, so you can
           also give additional instructions to aptitude here; for instance,
           aptitude safe-upgrade bash dash- will attempt to upgrade the bash
           package and remove the dash package.

           It is sometimes necessary to remove one package in order to
           upgrade another; this command is not able to upgrade packages in
           such situations. Use the full-upgrade command to upgrade as many
           packages as possible.

   full-upgrade

           Upgrades installed packages to their most recent version, removing
           or installing packages as necessary. This command is less
           conservative than safe-upgrade and thus more likely to perform
           unwanted actions. However, it is capable of upgrading packages
           that safe-upgrade cannot upgrade.

           If no packages are listed on the command line, aptitude will
           attempt to upgrade every package that can be upgraded. Otherwise,
           aptitude will attempt to upgrade only the packages which it is
           instructed to upgrade. The packages can be extended with suffixes
           in the same manner as arguments to aptitude install, so you can
           also give additional instructions to aptitude here; for instance,
           aptitude full-upgrade bash dash- will attempt to upgrade the bash
           package and remove the dash package.

           [Note] Note
                  Cette commande s'appellait dist-upgrade pour des raisons
                  historiques, aptitude la reconnait toujours. dist-upgrade
                  est un synonyme de full-upgrade.

   keep-all

           Annule toutes les actions prevues sur des paquets. Tout paquet
           dont l'etat indique une action prevue d'installation, de
           suppression ou de mise `a jour verra son etat remis `a zero.

   forget-new

           Ignore les << nouveaux >> paquets (equivaut `a presser << f >> en
           mode interactif).

   search

           Recherche les paquets qui correspondent `a un ou plusieurs motifs
           donnes sur la ligne de commande. Tous les paquets correspondant
           aux expressions demandees seront affiches. Par exemple,
           << aptitude search '~N' edit >> affichera tous les << nouveaux >>
           paquets et ceux dont le nom contient << edit >>. Les expressions
           de recherche sont expliquees en detail dans << Motifs de
           recherche >> dans le manuel de reference d'aptitude.

           [Note] Note
                  In the example above, << aptitude search '~N' edit >> has
                  two arguments after search and thus is searching for two
                  patterns: << ~N >> and << edit >>. As described in the
                  search pattern reference, a single pattern composed of two
                  sub-patterns separated by a space (such as << ~N edit >>)
                  matches only if both patterns match. Thus, the command
                  << aptitude search '~N edit' >> will only show << new >>
                  packages whose name contains << edit >>.

           A moins d'avoir invoque l'option -F, la sortie de la commande
           aptitude search ressemblera `a quelque chose comme ceci :

 i   apt                             - Advanced front-end for dpkg
 pi  apt-build                       - frontend to apt to build, optimize and in
 cp  apt-file                        - APT package searching utility -- command-
 ihA raptor-utils                    - Raptor RDF Parser utilities

           Les resultats sont presentes ligne par ligne. Le premier caractere
           de chaque ligne indique l'etat courant du paquet : les etats les
           plus courants sont p qui signifie qu'aucune trace du paquet n'est
           presente sur le systeme, c qui signifie que le paquet `a ete
           supprime mais que ses fichiers de configuration sont toujours
           present sur le systeme, i qui signifie que le paquet est installe
           et v qui signifie que le paquet est virtuel. Le second caractere
           indique l'action prevue (s'il y en a une, un espace sinon) sur le
           paquet. Les actions les plus courantes sont : i pour les paquets
           sur le point `a installer, d pour ceux `a supprimer et p pour ceux
           `a purger (c-`a-d, `a supprimer ainsi que ses fichiers de
           configuration). Si le dernier caractere est un A, le paquet a ete
           installe automatiquement.

           For a complete list of the possible state and action flags, see
           the section << Accessing Package Information >> in the aptitude
           reference guide. To customize the output of search, see the
           command-line options -F and --sort.

   show

           Displays detailed information about one or more packages, listed
           following the search command. If a package name contains a tilde
           character (<< ~ >>) or a question mark (<< ? >>), it will be
           treated as a search pattern and all matching packages will be
           displayed (see the section << Search Patterns >> in the aptitude
           reference manual).

           Si le niveau de verbosite est au moins 1 (c'est-`a-dire que
           l'option -v est presente sur la ligne de commande), les
           informations sur toutes les versions du paquets sont affichees.
           Sinon, seules les informations sur la << version installable >>
           sont affichees (la version qui serait telechargee par << aptitude
           install >>).

           You can display information about a different version of the
           package by appending =version to the package name; you can display
           the version from a particular archive or release by appending
           /archive or /release to the package name: for instance, /unstable
           or /sid. If either of these is present, then only the version you
           request will be displayed, regardless of the verbosity level.

           Si le niveau de verbosite est au moins 1, les champs architecture,
           taille compressee, nom de fichier et somme md5 du paquet sont
           affiches. Si le niveau de verbosite est au moins 2, la ou les
           versions selectionnees seront affichees une fois pour chacune des
           archives dans lesquelles elles sont trouvees.

   versions

           Displays the versions of the packages listed on the command-line.

 $ aptitude versions wesnoth
 p   1:1.4.5-1                                                             100
 p   1:1.6.5-1                                    unstable                 500
 p   1:1.7.14-1                                   experimental             1

           Each version is listed on a separate line. The leftmost three
           characters indicate the current state, planned state (if any), and
           whether the package was automatically installed; for more
           information on their meanings, see the documentation of aptitude
           search. To the right of the version number you can find the
           releases from which the version is available, and the pin priority
           of the version.

           If a package name contains a tilde character (<< ~ >>) or a
           question mark (<< ? >>), it will be treated as a search pattern
           and all matching versions will be displayed (see the section
           << Search Patterns >> in the aptitude reference manual). This
           means that, for instance, aptitude versions '~i' will display all
           the versions that are currently installed on the system and
           nothing else, not even other versions of the same packages.

 $ aptitude versions '~nexim4-daemon-light'
 Package exim4-daemon-light:
 i   4.71-3                                                                100
 p   4.71-4                                       unstable                 500

 Package exim4-daemon-light-dbg:
 p   4.71-4                                       unstable                 500

           If the input is a search pattern, or if more than one package's
           versions are to be displayed, aptitude will automatically group
           the output by package, as shown above. You can disable this via
           --group-by=none, in which case aptitude will display a single list
           of all the versions that were found and automatically include the
           package name in each output line:

 $ aptitude versions --group-by=none '~nexim4-daemon-light'
 i   exim4-daemon-light 4.71-3                                             100
 p   exim4-daemon-light 4.71-4                    unstable                 500
 p   exim4-daemon-light-dbg 4.71-4                unstable                 500

           To disable the package name, pass --show-package-names=never:

 $ aptitude versions --show-package-names=never --group-by=none '~nexim4-daemon-light'
 i   4.71-3                                                                100
 p   4.71-4                                       unstable                 500
 p   4.71-4                                       unstable                 500

           In addition to the above options, the information printed for each
           version can be controlled by the command-line option -F. The order
           in which versions are displayed can be controlled by the
           command-line option --sort. To prevent aptitude from formatting
           the output into columns, use --disable-columns.

   add-user-tag, remove-user-tag

           Adds a user tag to or removes a user tag from the selected group
           of packages. If a package name contains a tilde (<< ~ >>) or
           question mark (<< ? >>), it is treated as a search pattern and the
           tag is added to or removed from all the packages that match the
           pattern (see the section << Search Patterns >> in the aptitude
           reference manual).

           User tags are arbitrary strings associated with a package. They
           can be used with the ?user-tag(tag) search term, which will select
           all the packages that have a user tag matching tag.

   why, why-not

           Explains the reason that a particular package should or cannot be
           installed on the system.

           Cette commande cherche les paquets qui dependent ou sont en
           conflit avec ce paquet. Il affiche la suite de dependances qui
           s'enchainent jusqu'au paquet vise, et une note indique l'etat de
           chacun des paquets de la suite de dependances.

 $ aptitude why kdepim
 i   nautilus-data Recommends nautilus
 i A nautilus      Recommends desktop-base (>= 0.2)
 i A desktop-base  Suggests   gnome | kde | xfce4 | wmaker
 p   kde           Depends    kdepim (>= 4:3.4.3)

           The command why finds a dependency chain that installs the package
           named on the command line, as above. Note that the dependency that
           aptitude produced in this case is only a suggestion. This is
           because no package currently installed on this computer depends on
           or recommends the kdepim package; if a stronger dependency were
           available, aptitude would have displayed it.

           A contrario, why-not cherche la chaine de dependances qui conduit
           au conflit avec le paquet cible.

 $ aptitude why-not textopo
 i   ocaml-core          Depends   ocamlweb
 i A ocamlweb            Depends   tetex-extra | texlive-latex-extra
 i A texlive-latex-extra Conflicts textopo

           If one or more patterns are present, then aptitude will begin its
           search at these patterns; that is, the first package in the chain
           it prints will be a package matching the pattern in question. The
           patterns are considered to be package names unless they contain a
           tilde character (<< ~ >>) or a question mark (<< ? >>), in which
           case they are treated as search patterns (see the section
           << Search Patterns >> in the aptitude reference manual).

           If no patterns are present, then aptitude will search for
           dependency chains beginning at manually installed packages. This
           effectively shows the packages that have caused or would cause a
           given package to be installed.

           [Note] Note
                  aptitude why ne realise par une recherche complete de
                  dependances. Il n'affiche que les relations directes entre
                  paquet. Par exemple, si A a besoin de B, que C a besoin de
                  D, et que B et C sont en conflit, << aptitude why-not D >>
                  ne trouvera pas la reponse << A depend de BB, B est en
                  conflit avec C, et D depend de C >>.

           Aptitude n'affiche par defaut que les chaines de dependances
           << most installed, strongest, tightest, shortest >>. Dans ce cas,
           il cherche une chaine qui ne contient que les paquets qui sont
           installes ou qui seront installes. Il recherche les dependances
           les plus fortes possibles dans ce cadre, et recherche les chaines
           qui evitent les dependances ORed et Provides, et il recherche la
           chaine de dependance la plus courte qui respecte ces contraintes.
           Ces regles sont appliquees de fac,on de moins en moins stricte
           jusqu'`a ce qu'une correspondance soit trouvee.

           Si le niveau du mode verbeux est `a 1 ou plus, alors toutes les
           explications qu'aptitude trouvera seront affichees, dans l'ordre
           de pertinence decroissante. Si le niveau de mode verbeux est de 2
           ou plus, un tres important niveau d'information de debogage sera
           affiche sur la sortie standard.

           Cette commande renvoie un 0 si elle reussit, 1 si aucune
           explication n'a ete trouvee, et -1 si une erreur apparait.

   clean

           Supprime tous les paquets .deb telecharges et enregistres dans le
           repertoire cache (normalement /var/cache/apt/archives).

   autoclean

           Supprime tout paquet enregistre dans le cache et qui n'est plus
           propose au telechargement. Cela vous permet d'empecher que le
           cache ne grossisse demesurement avec le temps, sans avoir `a le
           vider completement.

   changelog

           Telecharge et affiche le journal des modifications pour chaque
           paquet source ou binaires.

           By default, the changelog for the version which would be installed
           with << aptitude install >> is downloaded. You can select a
           particular version of a package by appending =version to the
           package name; you can select the version from a particular archive
           or release by appending /archive or /release to the package name
           (for instance, /unstable or /sid).

   download

           Downloads the .deb file for the given package to the current
           directory. If a package name contains a tilde character (<< ~ >>)
           or a question mark (<< ? >>), it will be treated as a search
           pattern and all the matching packages will be downloaded (see the
           section << Search Patterns >> in the aptitude reference manual).

           By default, the version which would be installed with << aptitude
           install >> is downloaded. You can select a particular version of a
           package by appending =version to the package name; you can select
           the version from a particular archive or release by appending
           /archive or /release to the package name (for instance: /unstable
           or /sid).

   extract-cache-subset

           Copy the apt configuration directory (/etc/apt) and a subset of
           the package database to the specified directory. If no packages
           are listed, the entire package database is copied; otherwise only
           the entries corresponding to the named packages are copied. Each
           package name may be a search pattern, and all the packages
           matching that pattern will be selected (see the section << Search
           Patterns >> in the aptitude reference manual). Any existing
           package database files in the output directory will be
           overwritten.

           Dependencies in binary package stanzas will be rewritten to remove
           references to packages not in the selected set.

   help

           Affiche un bref resume des commandes et options disponibles.

Options

   Les options qui suivent peuvent etre utilisees afin de modifier le
   comportement des commandes ci-dessus. Remarquez que les commandes ne vont
   pas toutes reagir `a chaque option (en effet, certaines options n'ont
   aucun sens pour certaines commandes).

   --add-user-tag tag

           For full-upgrade, safe-upgrade, forbid-version, hold, install,
           keep-all, markauto, unmarkauto, purge, reinstall, remove, unhold,
           and unmarkauto: add the user tag tag to all packages that are
           installed, removed, or upgraded by this command as if with the
           add-user-tag command.

   --add-user-tag-to tag,pattern

           For full-upgrade, safe-upgrade forbid-version, hold, install,
           keep-all, markauto, unmarkauto, purge, reinstall, remove, unhold,
           and unmarkauto: add the user tag tag to all packages that match
           pattern as if with the add-user-tag command. The pattern is a
           search pattern as described in the section << Search Patterns >>
           in the aptitude reference manual.

           For instance, aptitude safe-upgrade --add-user-tag-to
           "new-installs,?action(install)" will add the tag new-installs to
           all the packages installed by the safe-upgrade command.

   --allow-new-upgrades

           When the safe resolver is being used (i.e., --safe-resolver was
           passed or Aptitude::Always-Use-Safe-Resolver is set to true),
           allow the dependency resolver to install upgrades for packages
           regardless of the value of
           Aptitude::Safe-Resolver::No-New-Upgrades.

   --allow-new-installs

           Allow the safe-upgrade command to install new packages; when the
           safe resolver is being used (i.e., --safe-resolver was passed or
           Aptitude::Always-Use-Safe-Resolver is set to true), allow the
           dependency resolver to install new packages. This option takes
           effect regardless of the value of
           Aptitude::Safe-Resolver::No-New-Installs.

   --allow-untrusted

           Install packages from untrusted sources without prompting. You
           should only use this if you know what you are doing, as it could
           easily compromise your system's security.

   --disable-columns

           This option causes aptitude search and aptitude version to output
           their results without any special formatting. In particular:
           normally aptitude will add whitespace or truncate search results
           in an attempt to fit its results into vertical << columns >>. With
           this flag, each line will be formed by replacing any format
           escapes in the format string with the correponding text; column
           widths will be ignored.

           For instance, the first few lines of output from << aptitude
           search -F '%p %V' --disable-columns libedataserver >> might be:

 disksearch 1.2.1-3
 hp-search-mac 0.1.3
 libbsearch-ruby 1.5-5
 libbsearch-ruby1.8 1.5-5
 libclass-dbi-abstractsearch-perl 0.07-2
 libdbix-fulltextsearch-perl 0.73-10

           As in the above example, --disable-columns is often useful in
           combination with a custom display format set using the
           command-line option -F.

           This corresponds to the configuration option
           Aptitude::CmdLine::Disable-Columns.

   -D, --show-deps

           For commands that will install or remove packages (install,
           full-upgrade, etc), show brief explanations of automatic
           installations and removals.

           Directive du fichier de configuration :
           Aptitude::CmdLine::Show-Deps.

   -d, --download-only

           N'installe ni ne supprime aucun paquet. Telecharge simplement les
           paquets necessaires dans le cache.

           Directive du fichier de configuration :
           Aptitude::CmdLine::Download-Only.

   -F format, --display-format format

           Specify the format which should be used to display output from the
           search and version commands. For instance, passing << %p %V %v >>
           for format will display a package's name, followed by its
           currently installed version and its available version (see the
           section << Customizing how packages are displayed >> in the
           aptitude reference manual for more information).

           The command-line option --disable-columns is often useful in
           combination with -F.

           For search, this corresponds to the configuration option
           Aptitude::CmdLine::Package-Display-Format; for versions, this
           corresponds to the configuration option
           Aptitude::CmdLine::Version-Display-Format.

   -f

           Essaye temerairement de resoudre les dependances des paquets
           casses, meme si cela implique d'ignorer des actions demandees sur
           la ligne de commande.

           Directive du fichier de configuration :
           Aptitude::CmdLine::Fix-Broken.

   --full-resolver

           When package dependency problems are encountered, use the default
           << full >> resolver to solve them. Unlike the << safe >> resolver
           activated by --safe-resolver, the full resolver will happily
           remove packages to fulfill dependencies. It can resolve more
           situations than the safe algorithm, but its solutions are more
           likely to be undesirable.

           This option can be used to force the use of the full resolver even
           when Aptitude::Always-Use-Safe-Resolver is true. The safe-upgrade
           command never uses the full resolver and does not accept the
           --full-resolver option.

   --group-by grouping-mode

           Control how the versions command groups its output. The following
           values are recognized:

              o archive to group packages by the archive they occur in
                (<< stable >>, << unstable >>, etc). If a package occurs in
                several archives, it will be displayed in each of them.

              o auto to group versions by their package unless there is
                exactly one argument and it is not a search pattern.

              o none to display all the versions in a single list without any
                grouping.

              o package to group versions by their package.

              o source-package to group versions by their source package.

              o source-version to group versions by their source package and
                source version.

           This corresponds to the configuration option
           Aptitude::CmdLine::Versions-Group-By.

   -h, --help

           Affiche un court message d'aide. Identique `a l'action help.

   --log-file=file

           If file is a nonempty string, log messages will be written to it,
           except that if file is << - >>, the messages will be written to
           standard output instead. If this option appears multiple times,
           the last occurrence is the one that will take effect.

           This does not affect the log of installations that aptitude has
           performed (/var/log/aptitude); the log messages written using this
           configuration include internal program events, errors, and
           debugging messages. See the command-line option --log-level to get
           more control over what gets logged.

           This corresponds to the configuration option
           Aptitude::Logging::File.

   --log-level=level, --log-level=category:level

           --log-level=level causes aptitude to only log messages whose level
           is level or higher. For instance, setting the log level to error
           will cause only messages at the log levels error and fatal to be
           displayed; all others will be hidden. Valid log levels (in
           descending order) are off, fatal, error, warn, info, debug, and
           trace. The default log level is warn.

           --log-level=category:level causes messages in category to only be
           logged if their level is level or higher.

           --log-level may appear multiple times on the command line; the
           most specific setting is the one that takes effect, so if you pass
           --log-level=aptitude.resolver:fatal and
           --log-level=aptitude.resolver.hints.match:trace, then messages in
           aptitude.resolver.hints.parse will only be printed if their level
           is fatal, but all messages in aptitude.resolver.hints.match will
           be printed. If you set the level of the same category two or more
           times, the last setting is the one that will take effect.

           This does not affect the log of installations that aptitude has
           performed (/var/log/aptitude); the log messages written using this
           configuration include internal program events, errors, and
           debugging messages. See the command-line option --log-file to
           change where log messages go.

           This corresponds to the configuration group
           Aptitude::Logging::Levels.

   --log-resolver

           Set some standard log levels related to the resolver, to produce
           logging output suitable for processing with automated tools. This
           is equivalent to the command-line options
           --log-level=aptitude.resolver.search:trace
           --log-level=aptitude.resolver.search.tiers:info.

   --no-new-installs

           Prevent safe-upgrade from installing any new packages; when the
           safe resolver is being used (i.e., --safe-resolver was passed or
           Aptitude::Always-Use-Safe-Resolver is set to true), forbid the
           dependency resolver from installing new packages. This option
           takes effect regardless of the value of
           Aptitude::Safe-Resolver::No-New-Installs.

           This mimics the historical behavior of apt-get upgrade.

           This corresponds to the configuration option
           Aptitude::CmdLine::Safe-Upgrade::No-New-Installs.

   --no-new-upgrades

           When the safe resolver is being used (i.e., --safe-resolver was
           passed or Aptitude::Always-Use-Safe-Resolver is set to true),
           allow the dependency resolver to install new packages regardless
           of the value of Aptitude::Safe-Resolver::No-New-Installs.

   --no-show-resolver-actions

           Do not display the actions performed by the << safe >> resolver,
           overriding any configuration option or earlier
           --show-resolver-actions.

   -O ordre, --sort ordre

           Specify the order in which output from the search and versions
           commands should be displayed. For instance, passing
           << installsize >> for order will list packages in order according
           to their size when installed (see the section << Customizing how
           packages are sorted >> in the aptitude reference manual for more
           information).

           The default sort order is name,version.

   -o clef=valeur

           Definit une option du fichier de configuration `a la volee.
           Utilisez par exemple -o Aptitude::Log=/tmp/mes-logs afin de
           consigner (logs) les evenements d'aptitude dans le fichier
           /tmp/mes-logs. Pour plus d'informations sur les options du fichier
           de configuration, consultez le chapitre << Reference du fichier de
           configuration >> dans le manuel de reference d'aptitude.

   -P, --prompt

           Always display a prompt before downloading, installing or removing
           packages, even when no actions other than those explicitly
           requested will be performed.

           Directive du fichier de configuration :
           Aptitude::CmdLine::Always-Prompt.

   --purge-unused

           If Aptitude::Delete-Unused is set to << true >> (its default),
           then in addition to removing each package that is no longer
           required by any installed package, aptitude will also purge them,
           removing their configuration files and perhaps other important
           data. For more information about which packages are considered to
           be << unused >>, see the section << Managing Automatically
           Installed Packages >> in the aptitude reference manual. THIS
           OPTION CAN CAUSE DATA LOSS! DO NOT USE IT UNLESS YOU KNOW WHAT YOU
           ARE DOING!

           This corresponds to the configuration option
           Aptitude::Purge-Unused.

   -q[=n], --quiet[=n]

           Enleve tous les indicateurs d'avancement et rend ainsi la sortie
           journalisable. Cette option peut etre passee plusieurs fois pour
           rendre le programme de plus en plus silencieux, mais contrairement
           `a apt-get, aptitude n'ajoute pas implicitement -y quand -q est
           passee plus d'une fois.

           Le parametre optionnel =n peut etre utilise pour configurer
           directement le taux de silence (par exemple, pour surcharger un
           parametrage dans /etc/apt/apt.conf) ; le programme agit alors
           comme si -q lui avait ete passee exactement n fois.

   -R, --without-recommends

           Ne gere pas les recommandations de dependances lors de
           l'installation de nouveaux paquets (prioritaire sur les reglages
           de /etc/apt/apt.conf and ~/.aptitude/config). Les paquets
           installes precedemment pour ces meme raisons de recommandation ne
           seront pas supprimes.

           This corresponds to the pair of configuration options
           Apt::Install-Recommends and Apt::AutoRemove::InstallRecommends.

   -r, --with-recommends

           Traite les suggestions ou les recommandations en tant que
           dependances lors de l'installation des nouveaux paquets.
           (Prioritaire sur les reglages de /etc/apt.conf et
           ~/.aptitude/config).

           This corresponds to the configuration option
           Apt::Install-Recommends

   --remove-user-tag tag

           For full-upgrade, safe-upgrade forbid-version, hold, install,
           keep-all, markauto, unmarkauto, purge, reinstall, remove, unhold,
           and unmarkauto: remove the user tag tag from all packages that are
           installed, removed, or upgraded by this command as if with the
           add-user-tag command.

   --remove-user-tag-from tag,pattern

           For full-upgrade, safe-upgrade forbid-version, hold, install,
           keep-all, markauto, unmarkauto, purge, reinstall, remove, unhold,
           and unmarkauto: remove the user tag tag from all packages that
           match pattern as if with the remove-user-tag command. The pattern
           is a search pattern as described in the section << Search
           Patterns >> in the aptitude reference manual.

           For instance, aptitude safe-upgrade --remove-user-tag-from
           "not-upgraded,?action(upgrade)" will remove the not-upgraded tag
           from all packages that the safe-upgrade command is able to
           upgrade.

   -s, --simulate

           En mode ligne de commande, affiche la liste des actions qui
           seraient realisees, mais ne les lance pas reellement. Il n'est pas
           necessaire d'avoir les privileges d'administration. Dans
           l'interface visuelle, ouvre toujours le cache en mode lecture
           seule que vous soyez administrateur ou non.

           Directive du fichier de configuration : Aptitude::Simulate.

   --safe-resolver

           When package dependency problems are encountered, use a << safe >>
           algorithm to solve them. This resolver attempts to preserve as
           many of your choices as possible; it will never remove a package
           or install a version of a package other than the package's default
           candidate version. It is the same algorithm used in safe-upgrade;
           indeed, aptitude --safe-resolver full-upgrade is equivalent to
           aptitude safe-upgrade. Because safe-upgrade always uses the safe
           resolver, it does not accept the --safe-resolver flag.

           This option is equivalent to setting the configuration variable
           Aptitude::Always-Use-Safe-Resolver to true.

   --schedule-only

           Pour les commandes qui modifient l'etat des paquets, programme les
           actions `a faire pour plus tard, mais ne les fait pas. Vous pouvez
           executer les actions programmees en lanc,ant aptitude install sans
           parametre. Cela revient `a faire la selection correspondante en
           mode visuel, puis `a quitter aptitude normalement.

           Par exemple, aptitude --schedule-only install evolution va
           programmer l'installation future du paquet evolution.

   --show-package-names when

           Controls when the versions command shows package names. The
           following settings are allowed:

              o always: display package names every time that aptitude
                versions runs.

              o auto: display package names when aptitude versions runs if
                the output is not grouped by package, and either there is a
                pattern-matching argument or there is more than one argument.

              o never: never display package names in the output of aptitude
                versions.

           This option corresponds to the configuration item
           Aptitude::CmdLine::Versions-Show-Package-Names.

   --show-resolver-actions

           Display the actions performed by the << safe >> resolver.

   --show-summary[=MODE]

           Changes the behavior of << aptitude why >> to summarize each
           dependency chain that it outputs, rather than displaying it in
           long form. If this option is present and MODE is not
           << no-summary >>, chains that contain Suggests dependencies will
           not be displayed: combine --show-summary with -v to see a summary
           of all the reasons for the target package to be installed.

           MODE can be any one of the following:

             1. no-summary: don't show a summary (the default behavior if
                --show-summary is not present).

             2. first-package: display the first package in each chain. This
                is the default value of MODE if it is not present.

             3. first-package-and-type: display the first package in each
                chain, along with the strength of the weakest dependency in
                the chain.

             4. all-packages: briefly display each chain of dependencies
                leading to the target package.

             5. all-packages-with-dep-versions: briefly display each chain of
                dependencies leading to the target package, including the
                target version of each dependency.

           This option corresponds to the configuration item
           Aptitude::CmdLine::Show-Summary; if --show-summary is present on
           the command-line, it will override
           Aptitude::CmdLine::Show-Summary.

           Exemple 10. Usage of --show-summary

           --show-summary used with -v to display all the reasons a package
           is installed:

 $ aptitude -v --show-summary why foomatic-db
 Packages requiring foomatic-db:
   cupsys-driver-gutenprint
   foomatic-db-engine
   foomatic-db-gutenprint
   foomatic-db-hpijs
   foomatic-filters-ppds
   foomatic-gui
   kde
   printconf
   wine

 $ aptitude -v --show-summary=first-package-and-type why foomatic-db
 Packages requiring foomatic-db:
   [Depends] cupsys-driver-gutenprint
   [Depends] foomatic-db-engine
   [Depends] foomatic-db-gutenprint
   [Depends] foomatic-db-hpijs
   [Depends] foomatic-filters-ppds
   [Depends] foomatic-gui
   [Depends] kde
   [Depends] printconf
   [Depends] wine

 $ aptitude -v --show-summary=all-packages why foomatic-db
 Packages requiring foomatic-db:
   cupsys-driver-gutenprint D: cups-driver-gutenprint D: cups R: foomatic-filters R: foomatic-db-engine D: foomatic-db
   foomatic-filters-ppds D: foomatic-filters R: foomatic-db-engine D: foomatic-db
   kde D: kdeadmin R: system-config-printer-kde D: system-config-printer R: hal-cups-utils D: cups R: foomatic-filters R: foomatic-db-engine D: foomatic-db
   wine D: libwine-print D: cups-bsd R: cups R: foomatic-filters R: foomatic-db-engine D: foomatic-db
   foomatic-db-engine D: foomatic-db
   foomatic-db-gutenprint D: foomatic-db
   foomatic-db-hpijs D: foomatic-db
   foomatic-gui D: python-foomatic D: foomatic-db-engine D: foomatic-db
   printconf D: foomatic-db

 $ aptitude -v --show-summary=all-packages-with-dep-versions why foomatic-db
 Packages requiring foomatic-db:
   cupsys-driver-gutenprint D: cups-driver-gutenprint (>= 5.0.2-4) D: cups (>= 1.3.0) R: foomatic-filters (>= 4.0) R: foomatic-db-engine (>= 4.0) D: foomatic-db (>= 20090301)
   foomatic-filters-ppds D: foomatic-filters R: foomatic-db-engine (>= 4.0) D: foomatic-db (>= 20090301)
   kde D: kdeadmin (>= 4:3.5.5) R: system-config-printer-kde (>= 4:4.2.2-1) D: system-config-printer (>= 1.0.0) R: hal-cups-utils D: cups R: foomatic-filters (>= 4.0) R: foomatic-db-engine (>= 4.0) D: foomatic-db (>= 20090301)
   wine D: libwine-print (= 1.1.15-1) D: cups-bsd R: cups R: foomatic-filters (>= 4.0) R: foomatic-db-engine (>= 4.0) D: foomatic-db (>= 20090301)
   foomatic-db-engine D: foomatic-db
   foomatic-db-gutenprint D: foomatic-db
   foomatic-db-hpijs D: foomatic-db
   foomatic-gui D: python-foomatic (>= 0.7.9.2) D: foomatic-db-engine D: foomatic-db (>= 20090301)
   printconf D: foomatic-db


           --show-summary used to list a chain on one line:

 $ aptitude --show-summary=all-packages why aptitude-gtk libglib2.0-data
 Packages requiring libglib2.0-data:
   aptitude-gtk D: libglib2.0-0 R: libglib2.0-data

   -t version, --target-release version

           Definit la version `a partir de laquelle les paquets devront etre
           installes. Par exemple, << aptitude -t experimental ... >>
           installera les paquets de la distribution experimentale, si rien
           d'autre n'est precise. Pour les actions de la ligne de commandes
           << changelog >>, << download >> et << show >>, cela revient `a
           suffixer /version au nom de chaque paquet cite sur la ligne de
           commandes. Pour les autres commandes, cela modifiera la version
           installee par defaut selon les regles decrites dans
           apt_preferences(5).

           Directive du fichier de configuration : APT::Default-Release.

   -V, --show-versions

           Indique quelle version du paquet sera installee.

           Directive du fichier de configuration :
           Aptitude::CmdLine::Show-Versions.

   -v, --verbose

           Force quelques commandes (show par exemple) `a afficher des
           informations supplementaires. Peut etre invoque plusieurs fois
           afin d'obtenir des informations de plus en plus completes.

           Directive du fichier de configuration :
           Aptitude::CmdLine::Verbose.

   --version

           Affiche la version et quelques informations sur l'environnement de
           compilation d'aptitude.

           When executing the command safe-upgrade or when the option
           --safe-resolver is present, aptitude will display a summary of the
           actions performed by the resolver before printing the installation
           preview. This is equivalent to the configuration options
           Aptitude::CmdLine::Safe-Upgrade::Show-Resolver-Actions and
           Aptitude::Safe-Resolver::Show-Resolver-Actions.

   --visual-preview

           Lance l'interface visuelle et affiche l'ecran d'accueil, plutot
           que d'afficher l'habituelle invite de commande en ligne.

   -W, --show-why

           In the preview displayed before packages are installed or removed,
           show which manually installed package requires each automatically
           installed package. For instance:

 $ aptitude --show-why install mediawiki
 ...
 The following NEW packages will be installed:
   libapache2-mod-php5{a} (for mediawiki)  mediawiki  php5{a} (for mediawiki)
   php5-cli{a} (for mediawiki)  php5-common{a} (for mediawiki)
   php5-mysql{a} (for mediawiki)

           When combined with -v or a non-zero value for
           Aptitude::CmdLine::Verbose, this displays the entire chain of
           dependencies that lead each package to be installed. For instance:

 $ aptitude -v --show-why install libdb4.2-dev
 The following NEW packages will be installed:
   libdb4.2{a} (libdb4.2-dev D: libdb4.2)  libdb4.2-dev
 The following packages will be REMOVED:
   libdb4.4-dev{a} (libdb4.2-dev C: libdb-dev P<- libdb-dev)

           This option will also describe why packages are being removed, as
           shown above. In this example, libdb4.2-dev conflicts with
           libdb-dev, which is provided by libdb-dev.

           This argument corresponds to the configuration option
           Aptitude::CmdLine::Show-Why and displays the same information that
           is computed by aptitude why and aptitude why-not.

   -w largeur, --width largeur

           Definit la largeur utilisee pour l'affichage du resultat de la
           commande search. (Par defaut, c'est la largeur du terminal).

           Directive du fichier de configuration :
           Aptitude::CmdLine::Package-Display-Width

   -y, --assume-yes

           Repond << oui >> `a toute question de type oui/non. En fait, cette
           option supprime l'invite (le prompt) qui apparait quand on
           installe, met `a jour ou supprime des paquets. N'affecte pas les
           reponses aux questions particulierement dangereuses, telles que la
           suppression des paquets essentiels. A priorite sur -P.

           Directive du fichier de configuration :
           Aptitude::CmdLine::Assume-Yes.

   -Z

           Affiche l'espace disque qui sera utilise ou libere par chacun des
           paquets `a installer, mettre `a jour ou supprimer.

           Directive du fichier de configuration :
           Aptitude::CmdLine::Show-Size-Changes.

   Les options suivantes s'appliquent au mode visuel du programme. Toutefois,
   elles ne sont utilisees qu'en interne. Normalement, vous n'en aurez pas
   besoin.

   --autoclean-on-startup

           Deletes old downloaded files when the program starts (equivalent
           to starting the program and immediately selecting Actions -> Clean
           obsolete files). You cannot use this option and
           << --autoclean-on-startup >>, << -i >>, or << -u >> at the same
           time.

   --clean-on-startup

           Cleans the package cache when the program starts (equivalent to
           starting the program and immediately selecting Actions -> Clean
           package cache). You cannot use this option and
           << --autoclean-on-startup >>, << -i >>, or << -u >> at the same
           time.

   -i

           Displays a download preview when the program starts (equivalent to
           starting the program and immediately pressing << g >>). You cannot
           use this option and << --autoclean-on-startup >>,
           << --clean-on-startup >>, or << -u >> at the same time.

   -S nom-fichier

           Charge les informations supplementaires `a partir de nom-fichier
           plutot qu'`a partir du fichier standard.

   -u

           Begins updating the package lists as soon as the program starts.
           You cannot use this option and << --autoclean-on-startup >>,
           << --clean-on-startup >>, or << -i >> at the same time.

Variables d'environnement

   HOME

           Si $HOME/.aptitude existe, aptitude stockera son fichier de
           configuration dans $HOME/.aptitude/config. Sinon, il recherchera
           le repertoire personnel de l'utilisateur courant, grace `a
           getpwuid(2) pour y placer son fichier de configuration.

   PAGER

           Quand cette variable d'environnement est parametree, aptitude
           l'utilisera pour afficher les journaux de modification `a
           l'invocation de << aptitude changelog >>. La valeur par defaut est
           more.

   TMP

           Quand TMPDIR n'est pas parametree, aptitude stockera ses fichiers
           temporaires dans TMP si cette derniere variable est parametree.
           Sinon, il les stockera dans /tmp.

   TMPDIR

           aptitude stockera ses fichiers temporaires dans le repertoire
           specifie par cette variable d'environnement. Si TMPDIR n'est pas
           parametree, alors TMP est utilisee. Si cette derniere ne l'est pas
           non plus, alors aptitude utilise /tmp.

Files

   /var/lib/aptitude/pkgstates

           The file in which stored package states and some package flags are
           stored.

   /etc/apt/apt.conf, /etc/apt/apt.conf.d/*, ~/.aptitude/config

           The configuration files for aptitude. ~/.aptitude/config overrides
           /etc/apt/apt.conf. See apt.conf(5) for documentation of the format
           and contents of these files.

See also

   apt-get(8), apt(8), /usr/share/doc/aptitude/html/lang/index.html du paquet
   aptitude-doc-lang

   --------------------------------------------------------------------------

Nom

   aptitude-create-state-bundle -- bundle the current aptitude state

Synopsis

   aptitude-create-state-bundle [options...] output-file

Description

   aptitude-create-state-bundle produces a compressed archive storing the
   files that are required to replicate the current package archive state.
   The following files and directories are included in the bundle:

     o $HOME/.aptitude

     o /var/lib/aptitude

     o /var/lib/apt

     o /var/cache/apt/*.bin

     o /etc/apt

     o /var/lib/dpkg/status

   The output of this program can be used as an argument to
   aptitude-run-state-bundle(1).

Options

   --force-bzip2

           Override the autodetection of which compression algorithm to use.
           By default, aptitude-create-state-bundle uses bzip2(1) if it is
           available, and gzip(1) otherwise. Passing this option forces the
           use of bzip2 even if it doesn't appear to be available.

   --force-gzip

           Override the autodetection of which compression algorithm to use.
           By default, aptitude-create-state-bundle uses bzip2(1) if it is
           available, and gzip(1) otherwise. Passing this option forces the
           use of gzip even if bzip2 is available.

   --help

           Print a brief usage message, then exit.

   --print-inputs

           Instead of creating a bundle, display a list of the files and
           directories that the program would include if it generated a
           bundle.

File format

   The bundle file is simply a tar(1) file compressed with bzip2(1) or
   gzip(1), with each of the input directory trees rooted at << . >>.

See also

   aptitude-run-state-bundle(1), aptitude(8), apt(8)

   --------------------------------------------------------------------------

Nom

   aptitude-run-state-bundle -- unpack an aptitude state bundle and invoke
   aptitude on it

Synopsis

   aptitude-run-state-bundle [options...] input-file [ program
   [arguments...]]

Description

   aptitude-run-state-bundle unpacks the given aptitude state bundle created
   by aptitude-create-state-bundle(1) to a temporary directory, invokes
   program on it with the supplied arguments, and removes the temporary
   directory afterwards. If program is not supplied, it defaults to
   aptitude(8).

Options

   The following options may occur on the command-line before the input file.
   Options following the input file are presumed to be arguments to aptitude.

   --append-args

           Place the options that give the location of the state bundle at
           the end of the command line when invoking program, rather than at
           the beginning (the default is to place options at the beginning).

   --help

           Display a brief usage summary.

   --prepend-args

           Place the options that give the location of the state bundle at
           the beginning of the command line when invoking program,
           overriding any previous --append-args (the default is to place
           options at the beginning).

   --no-clean

           Do not remove the unpacked state directory after running aptitude.
           You might want to use this if, for instance, you are debugging a
           problem that appears when aptitude's state file is modified. When
           aptitude finishes running, the name of the state directory will be
           printed so that you can access it in the future.

           This option is enabled automatically by --statedir.

   --really-clean

           Delete the state directory after running aptitude, even if
           --no-clean or --statedir was supplied.

   --statedir

           Instead of treating the input file as a state bundle, treat it as
           an unpacked state bundle. For instance, you can use this to access
           the state directory that was created by a prior run with
           --no-clean.

   --unpack

           Unpack the input file to a temporary directory, but don't actually
           run aptitude.

See also

   aptitude-create-state-bundle(1), aptitude(8), apt(8)
