#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <sys/mman.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "zdtmtst.h"

const char *test_doc	= "Create a bunch of small VMAs and test they survive transferring\n";
const char *test_author	= "Cyrill Gorcunov <gorcunov@openvz.org>";

#define NR_MAPS 4096

int main(int argc, char ** argv)
{
	void *map[NR_MAPS] = { };
	size_t i;

	test_init(argc, argv);

	for (i = 0; i < NR_MAPS; i++) {
		map[i] = mmap(i > 0 ? map[i - 1] + 8192 : NULL, 4096, PROT_READ | PROT_WRITE,
			      MAP_ANONYMOUS | MAP_PRIVATE | (i > 0 ? MAP_FIXED : 0), -1, 0);
		if (map[i] == MAP_FAILED) {
			err("Can't mmap");
			return 1;
		} else {
			/* Dirtify it */
			int *v = (void *)map[i];
			*v = i;
		}
	}

	test_daemon();
	test_waitsig();

	for (i = 0; i < NR_MAPS; i++) {
		int *v = (void *)map[i];

		if (*v != i) {
			fail("Data corrupted at page %lu", (unsigned long)i);
			return 1;
		}
	}
	pass();
	return 0;
}
